/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.acclimatiser;

import binnie.core.machines.IMachine;
import binnie.core.machines.power.ComponentProcessIndefinate;
import binnie.core.machines.power.ErrorState;
import binnie.core.util.I18N;
import binnie.genetics.machine.acclimatiser.Acclimatiser;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class AcclimatiserComponentLogic
extends ComponentProcessIndefinate {
    public AcclimatiserComponentLogic(IMachine machine) {
        super(machine, 2.0f);
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().getStack(4) == null) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.acclimatiser.error.noIndividual"), 4);
        }
        if (this.getUtil().getNonNullStacks(Acclimatiser.SLOT_ACCLIMATISER).isEmpty()) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.acclimatiser.error.noAcclimatizingItems"), Acclimatiser.SLOT_ACCLIMATISER);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (!Acclimatiser.canAcclimatise(this.getUtil().getStack(4), this.getUtil().getNonNullStacks(Acclimatiser.SLOT_ACCLIMATISER))) {
            return new ErrorState.InvalidItem(I18N.localise("genetics.machine.acclimatiser.error.invalidAcclimatizingItems"), 4);
        }
        return super.canProgress();
    }

    @Override
    protected boolean inProgress() {
        return this.canWork() == null;
    }

    @Override
    protected void onTickTask() {
        super.onTickTask();
        if (this.getUtil().getRandom().nextInt(100) == 0) {
            this.attemptAcclimatisation();
        }
    }

    protected void attemptAcclimatisation() {
        ArrayList<ItemStack> acclms = new ArrayList<ItemStack>();
        for (ItemStack s : this.getUtil().getNonNullStacks(Acclimatiser.SLOT_ACCLIMATISER)) {
            if (!Acclimatiser.canAcclimatise(this.getUtil().getStack(4), s)) continue;
            acclms.add(s);
        }
        ItemStack acc = (ItemStack)acclms.get(this.getUtil().getRandom().nextInt(acclms.size()));
        ItemStack acclimed = Acclimatiser.acclimatise(this.getUtil().getStack(4), acc);
        if (acclimed == null) {
            return;
        }
        this.getUtil().setStack(4, acclimed);
        boolean removed = false;
        for (int i : Acclimatiser.SLOT_ACCLIMATISER) {
            if (removed || this.getUtil().getStack(i) == null || !this.getUtil().getStack(i).func_77969_a(acc)) continue;
            this.getUtil().decreaseStack(i, 1);
            removed = true;
        }
    }
}

