/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.incubator;

import binnie.core.machines.MachineUtil;
import binnie.core.machines.transfer.TransferRequest;
import binnie.genetics.api.IIncubatorRecipe;
import binnie.genetics.machine.incubator.Incubator;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class IncubatorRecipe
implements IIncubatorRecipe {
    protected FluidStack input;
    protected FluidStack output;
    protected float lossChance;
    protected ItemStack outputStack;
    protected float tickChance;

    public IncubatorRecipe(FluidStack input, FluidStack output, float lossChance) {
        this(input, output, lossChance, 1.0f);
    }

    public IncubatorRecipe(FluidStack input, FluidStack output, float lossChance, float chance) {
        this.input = input;
        this.output = output;
        this.lossChance = lossChance;
        this.tickChance = chance;
    }

    @Override
    public float getChance() {
        return this.tickChance;
    }

    @Override
    public boolean isInputLiquid(FluidStack liquid) {
        return liquid != null && this.input.isFluidEqual(liquid);
    }

    @Override
    public boolean isInputLiquidSufficient(FluidStack liquid) {
        return liquid != null && liquid.amount >= 500;
    }

    @Override
    public void doTask(MachineUtil machine) {
        Random rand;
        machine.drainTank(0, this.input.amount);
        if (this.output != null) {
            machine.fillTank(1, this.output);
        }
        this.outputStack = this.getOutputStack(machine);
        if (this.outputStack != null) {
            ItemStack output = this.outputStack.func_77946_l();
            TransferRequest product = new TransferRequest(output, machine.getInventory()).setTargetSlots(Incubator.SLOT_OUTPUT).ignoreValidation();
            product.transfer(true);
        }
        if ((rand = machine.getRandom()).nextFloat() < this.lossChance) {
            machine.decreaseStack(3, 1);
        }
    }

    public IncubatorRecipe setOutputStack(ItemStack stack) {
        this.outputStack = stack;
        return this;
    }

    protected ItemStack getOutputStack(MachineUtil util) {
        return this.outputStack;
    }

    @Override
    public boolean roomForOutput(MachineUtil machine) {
        if (!(this.output == null || machine.isTankEmpty(1) || machine.getFluid(1).isFluidEqual(this.output) && machine.spaceInTank(1, this.output.amount))) {
            return false;
        }
        ItemStack outputStack = this.getOutputStack(machine);
        if (outputStack == null) {
            return true;
        }
        ItemStack output = outputStack.func_77946_l();
        TransferRequest product = new TransferRequest(output, machine.getInventory()).setTargetSlots(Incubator.SLOT_OUTPUT).ignoreValidation();
        return product.transfer(false) == null;
    }
}

