/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.Mods;
import binnie.core.util.I18N;
import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public enum ExtraBeesFlowers implements IFlowerProvider,
IAlleleFlowers,
IChromosomeType
{
    WATER,
    SUGAR,
    ROCK,
    BOOK,
    DEAD,
    REDSTONE,
    WOOD,
    LEAVES,
    SAPLING,
    FRUIT,
    MYSTICAL;

    protected boolean dominant = true;

    public static void doInit() {
        for (ExtraBeesFlowers effect : ExtraBeesFlowers.values()) {
            effect.register();
        }
    }

    public String getUID() {
        return "extrabees.flower." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public IFlowerProvider getProvider() {
        return this;
    }

    public String getDescription() {
        return I18N.localise("extrabees.flowers." + this.name().toLowerCase() + ".name");
    }

    public void register() {
        for (ItemStack stack : this.getItemStacks()) {
            FlowerManager.flowerRegistry.registerAcceptableFlower(Block.func_149634_a((Item)stack.func_77973_b()), new String[]{this.getUID()});
        }
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{this});
    }

    public ItemStack[] getItemStacks() {
        switch (this) {
            case WATER: {
                return new ItemStack[]{new ItemStack(Blocks.field_150392_bi)};
            }
            case SUGAR: {
                return new ItemStack[]{new ItemStack(Blocks.field_150436_aH)};
            }
            case ROCK: {
                return new ItemStack[]{new ItemStack(Blocks.field_150347_e)};
            }
            case BOOK: {
                return new ItemStack[]{new ItemStack(Blocks.field_150342_X)};
            }
            case REDSTONE: {
                return new ItemStack[]{new ItemStack(Blocks.field_150429_aA)};
            }
            case DEAD: {
                return new ItemStack[]{new ItemStack((Block)Blocks.field_150330_I)};
            }
            case FRUIT: {
                return new ItemStack[]{new ItemStack(Items.field_151034_e)};
            }
            case LEAVES: {
                return new ItemStack[]{new ItemStack((Block)Blocks.field_150362_t)};
            }
            case SAPLING: {
                return new ItemStack[]{new ItemStack(Blocks.field_150345_g)};
            }
            case WOOD: {
                return new ItemStack[]{new ItemStack(Blocks.field_150364_r)};
            }
        }
        return new ItemStack[0];
    }

    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    public boolean isAcceptedFlower(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        switch (this) {
            case WATER: {
                return block == Blocks.field_150392_bi;
            }
            case ROCK: {
                return block.func_149688_o() == Material.field_151576_e;
            }
            case SUGAR: {
                return block == Blocks.field_150436_aH;
            }
            case BOOK: {
                return block == Blocks.field_150342_X;
            }
            case REDSTONE: {
                return block == Blocks.field_150429_aA;
            }
            case DEAD: {
                return block == Blocks.field_150330_I;
            }
            case WOOD: {
                return block.isWood((IBlockAccess)world, x, y, z);
            }
            case FRUIT: {
                return world.func_147438_o(x, y, z) instanceof IFruitBearer;
            }
            case LEAVES: {
                return block.isLeaves((IBlockAccess)world, x, y, z);
            }
            case SAPLING: {
                return block.getClass().getName().toLowerCase().contains("sapling");
            }
            case MYSTICAL: {
                return block == Mods.botania.block("flower");
            }
        }
        return false;
    }

    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        switch (this) {
            case WATER: {
                return world.func_147437_c(x, y, z) && world.func_147439_a(x, y - 1, z) == Blocks.field_150355_j && world.func_147465_d(x, y, z, Blocks.field_150392_bi, 0, 2);
            }
            case SUGAR: {
                return world.func_147439_a(x, y - 1, z) == Blocks.field_150436_aH && world.func_147437_c(x, y, z) && world.func_147465_d(x, y, z, Blocks.field_150436_aH, 0, 0);
            }
        }
        return false;
    }

    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        if (this == MYSTICAL) {
            ArrayList<ItemStack> prods = new ArrayList<ItemStack>();
            Collections.addAll(prods, products);
            for (int k = 0; k < 50; ++k) {
                int z2;
                int y2;
                int tX = 7;
                int tY = 7;
                int tZ = 3;
                int x2 = x - tX + world.field_73012_v.nextInt(1 + 2 * tX);
                Block block = world.func_147439_a(x2, y2 = y - tY + world.field_73012_v.nextInt(1 + 2 * tY), z2 = z - tZ + world.field_73012_v.nextInt(1 + 2 * tZ));
                if (block == null || block != Mods.botania.block("flower")) continue;
                int meta = world.func_72805_g(x2, y2, z2);
                Item item = Mods.botania.item("petal");
                if (item == null) continue;
                prods.add(new ItemStack(item, 1, meta));
            }
            return prods.toArray(new ItemStack[0]);
        }
        return products;
    }

    public String getName() {
        return this.getDescription();
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }

    public String getFlowerType() {
        return this.getUID();
    }

    public Set<IFlower> getFlowers() {
        return new HashSet<IFlower>();
    }

    public Class<? extends IAllele> getAlleleClass() {
        return ((Object)((Object)this)).getClass();
    }

    public ISpeciesRoot getSpeciesRoot() {
        return AlleleManager.alleleRegistry.getSpeciesRoot(this.getUID());
    }
}

