/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.designer;

import binnie.core.machines.Machine;
import binnie.core.machines.component.ComponentRecipe;
import binnie.core.machines.component.IComponentRecipe;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateSource;
import binnie.core.util.I18N;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.machines.designer.DesignerType;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WoodworkerRecipeComponent
extends ComponentRecipe
implements IComponentRecipe,
INetwork.GuiNBT,
IErrorStateSource {
    public DesignerType type;
    private IDesign design = EnumDesign.Diamond;

    public WoodworkerRecipeComponent(Machine machine, DesignerType type) {
        super(machine);
        this.type = type;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.setDesign(CarpentryManager.carpentryInterface.getDesign(nbttagcompound.func_74762_e("design")));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("design", CarpentryManager.carpentryInterface.getDesignIndex(this.design));
    }

    @Override
    public boolean isRecipe() {
        return this.getProduct() != null;
    }

    @Override
    public ItemStack getProduct() {
        ItemStack plank1 = this.getUtil().getStack(1);
        ItemStack plank2 = this.getUtil().getStack(2);
        if (plank1 == null || plank2 == null) {
            return null;
        }
        IDesignMaterial type1 = this.type.getSystem().getMaterial(plank1);
        IDesignMaterial type2 = this.type.getSystem().getMaterial(plank2);
        IDesign design = this.getDesign();
        ItemStack stack = this.type.getBlock(type1, type2, design);
        return stack;
    }

    @Override
    public ItemStack doRecipe(boolean takeItem) {
        if (!this.isRecipe() || this.canWork() != null) {
            return null;
        }
        ItemStack product = this.getProduct();
        if (takeItem) {
            ItemStack a = this.getUtil().decreaseStack(1, 1);
            if (a == null) {
                this.getUtil().decreaseStack(2, 1);
            } else if (this.design != EnumDesign.Blank) {
                this.getUtil().decreaseStack(2, 1);
            }
            this.getUtil().decreaseStack(0, 1);
        }
        return product;
    }

    public IDesign getDesign() {
        return this.design;
    }

    private void setDesign(IDesign design) {
        this.design = design;
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("recipe")) {
            int fit;
            InventoryPlayer playerInv = player.field_71071_by;
            ItemStack recipe = this.doRecipe(false);
            if (recipe == null) {
                return;
            }
            if (playerInv.func_70445_o() == null) {
                playerInv.func_70437_b(this.doRecipe(true));
            } else if (playerInv.func_70445_o().func_77969_a(recipe) && ItemStack.func_77970_a((ItemStack)playerInv.func_70445_o(), (ItemStack)recipe) && (fit = recipe.func_77976_d() - (recipe.field_77994_a + playerInv.func_70445_o().field_77994_a)) >= 0) {
                ItemStack doRecipe;
                ItemStack rec = doRecipe = this.doRecipe(true);
                doRecipe.field_77994_a += playerInv.func_70445_o().field_77994_a;
                playerInv.func_70437_b(rec);
            }
            player.field_71070_bA.func_75142_b();
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71113_k();
            }
        } else if (name.equals("design")) {
            this.setDesign(CarpentryManager.carpentryInterface.getDesign(nbt.func_74765_d("d")));
        }
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(0)) {
            return new ErrorState.NoItem(I18N.localise("extratrees.machine.worker.error.glueRequired"), 0);
        }
        return null;
    }

    @Override
    public ErrorState canProgress() {
        return null;
    }

    @Override
    public void sendGuiNBT(Map<String, NBTTagCompound> nbts) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74777_a("d", (short)CarpentryManager.carpentryInterface.getDesignIndex(this.getDesign()));
        nbts.put("design", tag);
    }

    public DesignerType getDesignerType() {
        return this.type;
    }
}

