/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics.effect;

import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class FireworkCreator {

    public static class Firework {
        protected boolean flicker = false;
        protected boolean trail = false;
        protected ArrayList<Integer> colors = new ArrayList();
        protected byte shape = 0;

        public void setTrail() {
            this.trail = true;
        }

        public void setShape(Shape shape) {
            this.shape = (byte)shape.ordinal();
        }

        public void addColor(int color) {
            this.colors.add(color);
        }

        public NBTTagCompound getNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.flicker) {
                nbt.func_74757_a("Flicker", true);
            }
            if (this.trail) {
                nbt.func_74757_a("Trail", true);
            }
            if (this.colors.size() == 0) {
                this.addColor(0xFFFFFF);
            }
            int[] array = new int[this.colors.size()];
            for (int i = 0; i < this.colors.size(); ++i) {
                array[i] = this.colors.get(i);
            }
            nbt.func_74783_a("Colors", array);
            nbt.func_74774_a("Type", this.shape);
            return nbt;
        }

        public ItemStack getFirework() {
            NBTTagCompound fireworksNbt = new NBTTagCompound();
            NBTTagCompound fireworkNbt = new NBTTagCompound();
            NBTTagList explosions = new NBTTagList();
            explosions.func_74742_a((NBTBase)this.getNBT());
            fireworkNbt.func_74782_a("Explosions", (NBTBase)explosions);
            fireworkNbt.func_74774_a("Flight", (byte)0);
            fireworksNbt.func_74782_a("Fireworks", (NBTBase)fireworkNbt);
            ItemStack item = new ItemStack(Items.field_151152_bP);
            item.func_77982_d(fireworksNbt);
            return item;
        }
    }

    public static enum Shape {
        Ball,
        LargeBall,
        Star,
        Creeper,
        Burst;

    }
}

