/*
 * Decompiled with CFR 0.152.
 */
package binnie.core;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.core.gui.IBinnieGUID;
import binnie.core.mod.parser.FieldParser;
import binnie.core.network.BinniePacketHandler;
import binnie.core.network.IPacketID;
import binnie.core.network.IPacketProvider;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.proxy.IProxyCore;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;

public abstract class AbstractMod
implements IPacketProvider,
IInitializable {
    private SimpleNetworkWrapper wrapper;
    private final LinkedHashSet<Field> fields = new LinkedHashSet();
    protected final List<IInitializable> modules = new ArrayList<IInitializable>();

    public AbstractMod() {
        BinnieCore.registerMod(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public abstract boolean isActive();

    @Override
    public abstract String getChannel();

    @Override
    public IPacketID[] getPacketIDs() {
        return new IPacketID[0];
    }

    public IBinnieGUID[] getGUIDs() {
        return new IBinnieGUID[0];
    }

    public Class[] getConfigs() {
        return new Class[0];
    }

    public abstract IProxyCore getProxy();

    public abstract String getModID();

    public SimpleNetworkWrapper getNetworkWrapper() {
        return this.wrapper;
    }

    protected abstract Class<? extends BinniePacketHandler> getPacketHandler();

    @Override
    public void preInit() {
        if (!this.isActive()) {
            return;
        }
        if (this.getConfigs() != null) {
            for (Class clazz : this.getConfigs()) {
                Binnie.Configuration.registerConfiguration(clazz, this);
            }
        }
        this.getProxy().preInit();
        for (IInitializable module : this.modules) {
            module.preInit();
        }
        Collections.addAll(this.fields, this.getClass().getFields());
        for (Class<?> clazz : this.getClass().getClasses()) {
            Collections.addAll(this.fields, this.getClass().getFields());
        }
        for (IInitializable module : this.modules) {
            Collections.addAll(this.fields, module.getClass().getFields());
        }
        for (Field field4 : this.fields) {
            try {
                FieldParser.preInitParse(field4, this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void init() {
        if (!this.isActive()) {
            return;
        }
        this.getProxy().init();
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(this.getChannel());
        this.wrapper.registerMessage(this.getPacketHandler(), MessageBinnie.class, 1, Side.CLIENT);
        this.wrapper.registerMessage(this.getPacketHandler(), MessageBinnie.class, 1, Side.SERVER);
        for (IInitializable module : this.modules) {
            module.init();
        }
        for (Field field : this.fields) {
            try {
                FieldParser.initParse(field, this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void postInit() {
        if (!this.isActive()) {
            return;
        }
        this.getProxy().postInit();
        for (IInitializable module : this.modules) {
            module.postInit();
        }
        for (Field field : this.fields) {
            try {
                FieldParser.postInitParse(field, this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void addModule(IInitializable init) {
        this.modules.add(init);
        MinecraftForge.EVENT_BUS.register((Object)init);
    }
}

