/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary.machine.stimulator;

import binnie.core.machines.Machine;
import binnie.extrabees.apiary.ComponentBeeModifier;
import binnie.extrabees.apiary.machine.stimulator.StimulatorCircuit;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import java.util.ArrayList;

public class StimulatorModifierComponent
extends ComponentBeeModifier
implements IBeeModifier,
IBeeListener {
    protected float powerUsage = 0.0f;
    protected boolean powered = false;
    protected StimulatorCircuit[] modifiers = new StimulatorCircuit[0];

    public StimulatorModifierComponent(Machine machine) {
        super(machine);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.modifiers = this.getCircuits();
        this.powerUsage = 0.0f;
        for (StimulatorCircuit beeMod : this.modifiers) {
            this.powerUsage += (float)beeMod.getPowerUsage();
        }
        this.powered = this.getUtil().hasEnergyMJ(this.powerUsage);
    }

    public ICircuitBoard getHiveFrame() {
        if (!this.getUtil().isSlotEmpty(0)) {
            return ChipsetManager.circuitRegistry.getCircuitboard(this.getUtil().getStack(0));
        }
        return null;
    }

    public StimulatorCircuit[] getCircuits() {
        ICircuitBoard board = this.getHiveFrame();
        if (board == null) {
            return new StimulatorCircuit[0];
        }
        ICircuit[] circuits = board.getCircuits();
        ArrayList<IBeeModifier> mod = new ArrayList<IBeeModifier>();
        for (ICircuit circuit : circuits) {
            if (!(circuit instanceof StimulatorCircuit)) continue;
            mod.add((IBeeModifier)circuit);
        }
        return mod.toArray(new StimulatorCircuit[0]);
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getTerritoryModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getMutationModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getLifespanModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getProductionModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getFloweringModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getGeneticDecay(genome, mod);
        }
        return mod;
    }

    @Override
    public boolean isSealed() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isSealed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isSelfLighted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isSunlightSimulated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHellish() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isHellish()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void wearOutEquipment(int amount) {
        this.getUtil().useEnergyMJ(this.powerUsage);
    }
}

