/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.Binnie;
import binnie.core.Mods;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.ResourceType;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterflyRoot;
import java.awt.Color;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public enum ButterflySpecies implements IAlleleButterflySpecies
{
    WhiteAdmiral("whiteAdmiral", "Limenitis camilla", new Color(0xFAFAFA)),
    PurpleEmperor("purpleEmperor", "Apatura iris", new Color(4338374)),
    RedAdmiral("redAdmiral", "Vanessa atalanta", new Color(15101764)),
    PaintedLady("paintedLady", "Vanessa cardui", new Color(15573064)),
    SmallTortoiseshell("smallTortoiseshell", "Aglais urticae", new Color(15365387)),
    CamberwellBeauty("camberwellBeauty", "Aglais antiopa", new Color(9806540)),
    Peacock("peacock", "Inachis io", new Color(13842434)),
    Wall("wall", "Lasiommata megera", new Color(15707678)),
    CrimsonRose("crimsonRose", "Atrophaneura hector", new Color(16736891)),
    KaiserIHind("kaiserIHind", "Teinopalpus imperialis", new Color(7839808)),
    GoldenBirdwing("goldenBirdwing", "Troides aeacus", new Color(16374814)),
    MarshFritillary("marshFritillary", "Euphydryas aurinia", new Color(16747520)),
    PearlBorderedFritillary("pearlBorderedFritillary", "Boloria euphrosyne", new Color(16747267)),
    QueenOfSpainFritillary("queenOfSpainFritillary", "Issoria lathonia", new Color(16765247)),
    SpeckledWood("speckledWood", "Pararge aegeria", new Color(16119949)),
    ScotchAngus("scotchAngus", "Erebia aethiops", new Color(12735523)),
    Gatekeeper("gatekeeper", "Pyronia tithonus", new Color(16433962)),
    MeadowBrown("meadowBrown", "Maniola jurtina", new Color(14914841)),
    SmallHeath("smallHeath", "Coenonympha pamphilus", new Color(16754226)),
    Ringlet("ringlet", "Aphantopus hyperantus", new Color(9919799)),
    Monarch("monarch", "Danaus plexippus", new Color(16757254)),
    MarbledWhite("marbledWhite", "Melanargia galathea", new Color(0xECECEC));

    public IClassification branch;
    protected String name;
    protected String branchName;
    protected String scientific;
    protected BinnieResource texture;
    protected int color;
    private Map<ItemStack, Float> butterflyLoot;
    private Map<ItemStack, Float> caterpillarLoot;

    private ButterflySpecies(String name, String scientific, Color color) {
        this.name = name;
        this.scientific = scientific.split(" ")[1];
        this.color = color.getRGB();
        this.butterflyLoot = new HashMap<ItemStack, Float>();
        this.caterpillarLoot = new HashMap<ItemStack, Float>();
        this.branchName = scientific.split(" ")[0].toLowerCase();
        this.texture = Binnie.Resource.getPNG(ExtraTrees.instance, ResourceType.Entity, this.toString());
    }

    public String getName() {
        return I18N.localise("extratrees.butterflies.species." + this.name);
    }

    public String getDescription() {
        return "";
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.NORMAL;
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.NORMAL;
    }

    public boolean hasEffect() {
        return false;
    }

    public boolean isSecret() {
        return false;
    }

    public boolean isCounted() {
        return true;
    }

    public String getBinomial() {
        return this.scientific;
    }

    public String getAuthority() {
        return "Binnie";
    }

    public IClassification getBranch() {
        return this.branch;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return null;
    }

    public String getUID() {
        return "extrabutterflies.species." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return true;
    }

    public String getEntityTexture() {
        return this.texture.getResourceLocation().toString();
    }

    public IAllele[] getTemplate() {
        IAllele[] def = (IAllele[])this.getRoot().getDefaultTemplate().clone();
        def[0] = this;
        return def;
    }

    public IButterflyRoot getRoot() {
        return Binnie.Genetics.getButterflyRoot();
    }

    public float getRarity() {
        return 0.5f;
    }

    public boolean isNocturnal() {
        return false;
    }

    public int getIconColour(int renderPass) {
        return renderPass > 0 ? 0xFFFFFF : this.color;
    }

    public Map<ItemStack, Float> getButterflyLoot() {
        return new HashMap<ItemStack, Float>();
    }

    public Map<ItemStack, Float> getCaterpillarLoot() {
        return new HashMap<ItemStack, Float>();
    }

    public int getComplexity() {
        return 4;
    }

    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        if (itemstack.func_77973_b() == Items.field_151069_bo) {
            return 0.9f;
        }
        for (ItemStack itemStack : this.butterflyLoot.keySet()) {
            if (!itemStack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack itemStack : this.caterpillarLoot.keySet()) {
            if (!itemStack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        if (itemstack.func_77973_b() == Mods.forestry.item("honeyDrop")) {
            return 0.5f;
        }
        if (itemstack.func_77973_b() == Mods.forestry.item("honeydew")) {
            return 0.7f;
        }
        if (itemstack.func_77973_b() == Mods.forestry.item("beeComb")) {
            return 0.4f;
        }
        if (AlleleManager.alleleRegistry.isIndividual(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry entry : this.getRoot().getResearchCatalysts().entrySet()) {
            if (!((ItemStack)entry.getKey()).func_77969_a(itemstack)) continue;
            return ((Float)entry.getValue()).floatValue();
        }
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        return new ItemStack[]{this.getRoot().getMemberStack(individual.copy(), EnumFlutterType.SERUM.ordinal())};
    }

    public EnumSet<BiomeDictionary.Type> getSpawnBiomes() {
        return EnumSet.noneOf(BiomeDictionary.Type.class);
    }

    public boolean strictSpawnMatch() {
        return false;
    }

    public float getFlightDistance() {
        return 5.0f;
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }
}

