/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.network.data;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IInterfaceViewable;
import appeng.api.util.IReadOnlyCollection;
import appeng.helpers.IInterfaceHost;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.automation.UpgradeInventory;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.parts.p2p.PartP2PTunnelStatic;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import com.projecturanus.betterp2p.BetterP2P;
import com.projecturanus.betterp2p.network.data.P2PInfo;
import com.projecturanus.betterp2p.network.data.P2PInfoKt;
import com.projecturanus.betterp2p.network.data.P2PLocation;
import com.projecturanus.betterp2p.network.data.P2PLocationKt;
import com.projecturanus.betterp2p.util.p2p.P2PUtilKt;
import com.projecturanus.betterp2p.util.p2p.TunnelInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u001a\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00122\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0013J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J,\u0010\u001f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012J\u0014\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010$\u001a\u00020\u0012J8\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u001c\u001a\u00020\u00122\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\"\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010.\u001a\u00020/H\u0002J\u0016\u00100\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010.\u001a\u00020/J6\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u0002032\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/projecturanus/betterp2p/network/data/GridServerCache;", "", "grid", "Lappeng/api/networking/IGrid;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "type", "", "<init>", "(Lappeng/api/networking/IGrid;Lnet/minecraft/entity/player/EntityPlayer;I)V", "getPlayer", "()Lnet/minecraft/entity/player/EntityPlayer;", "getType", "()I", "setType", "(I)V", "listP2P", "", "Lcom/projecturanus/betterp2p/network/data/P2PLocation;", "Lappeng/parts/p2p/PartP2PTunnel;", "dirtyP2P", "", "rebuildList", "", "retrieveP2PList", "", "Lcom/projecturanus/betterp2p/network/data/P2PInfo;", "markDirty", "key", "p2p", "getP2PUpdates", "linkP2P", "Lkotlin/Pair;", "inputIndex", "outputIndex", "unlinkP2P", "p2pIndex", "updateP2P", "tunnel", "frequency", "", "output", "", "name", "", "changeP2PType", "newType", "Lcom/projecturanus/betterp2p/util/p2p/TunnelInfo;", "changeAllP2Ps", "handleInterface", "oldIn", "Lappeng/helpers/IInterfaceHost;", "oldOut", "newIn", "newOut", "drops", "", "Lnet/minecraft/item/ItemStack;", "betterp2p"})
@SourceDebugExtension(value={"SMAP\nGridServerCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridServerCache.kt\ncom/projecturanus/betterp2p/network/data/GridServerCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1863#2:351\n1863#2,2:352\n1864#2:354\n1611#2,9:355\n1863#2:364\n1864#2:366\n1620#2:367\n1611#2,9:368\n1863#2:377\n1864#2:379\n1620#2:380\n1872#2,3:381\n1872#2,3:384\n1872#2,3:387\n1872#2,3:390\n1863#2,2:393\n1863#2,2:395\n1872#2,3:397\n1#3:365\n1#3:378\n*S KotlinDebug\n*F\n+ 1 GridServerCache.kt\ncom/projecturanus/betterp2p/network/data/GridServerCache\n*L\n53#1:351\n57#1:352,2\n53#1:354\n77#1:355,9\n77#1:364\n77#1:366\n77#1:367\n102#1:368,9\n102#1:377\n102#1:379\n102#1:380\n316#1:381,3\n320#1:384,3\n324#1:387,3\n328#1:390,3\n332#1:393,2\n336#1:395,2\n342#1:397,3\n77#1:365\n102#1:378\n*E\n"})
public final class GridServerCache {
    @NotNull
    private final IGrid grid;
    @NotNull
    private final EntityPlayer player;
    private int type;
    @NotNull
    private final Map<P2PLocation, PartP2PTunnel<?>> listP2P;
    @NotNull
    private final Set<P2PLocation> dirtyP2P;

    public GridServerCache(@NotNull IGrid grid, @NotNull EntityPlayer player, int type) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.grid = grid;
        this.player = player;
        this.type = type;
        this.listP2P = new LinkedHashMap();
        this.dirtyP2P = new LinkedHashSet();
        this.rebuildList(this.type);
    }

    @NotNull
    public final EntityPlayer getPlayer() {
        return this.player;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rebuildList(int type) {
        Map<P2PLocation, PartP2PTunnel<?>> map = this.listP2P;
        synchronized (map) {
            boolean bl = false;
            this.listP2P.clear();
            this.dirtyP2P.clear();
            IReadOnlyCollection iReadOnlyCollection = this.grid.getMachinesClasses();
            Intrinsics.checkNotNullExpressionValue((Object)iReadOnlyCollection, (String)"getMachinesClasses(...)");
            Iterable $this$forEach$iv = (Iterable)iReadOnlyCollection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Class it = (Class)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getSuperclass().getSuperclass(), PartP2PTunnel.class)) continue;
                if (type != -1) {
                    TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromIndex(type);
                    if (!Intrinsics.areEqual(tunnelInfo != null ? tunnelInfo.getClazz() : null, (Object)it)) continue;
                }
                IMachineSet iMachineSet = this.grid.getMachines(it);
                Intrinsics.checkNotNullExpressionValue((Object)iMachineSet, (String)"getMachines(...)");
                Iterable $this$forEach$iv2 = (Iterable)iMachineSet;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    IGridNode gridNode = (IGridNode)element$iv2;
                    boolean bl3 = false;
                    IGridHost iGridHost = gridNode.getMachine();
                    Intrinsics.checkNotNull((Object)iGridHost, (String)"null cannot be cast to non-null type appeng.parts.p2p.PartP2PTunnel<*>");
                    PartP2PTunnel p2p = (PartP2PTunnel)iGridHost;
                    this.listP2P.put(P2PLocationKt.toLoc(p2p), p2p);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<P2PInfo> retrieveP2PList() {
        void $this$mapNotNullTo$iv$iv;
        if (this.grid instanceof ISecurityGrid && !((ISecurityGrid)this.grid).hasPermission(this.player, SecurityPermissions.BUILD)) {
            return CollectionsKt.emptyList();
        }
        this.rebuildList(this.type);
        Iterable $this$mapNotNull$iv = this.listP2P.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            P2PInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PartP2PTunnel it = (PartP2PTunnel)element$iv$iv;
            boolean bl2 = false;
            TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromClass(it.getClass());
            int index = tunnelInfo != null ? tunnelInfo.getIndex() : -1;
            if ((this.type == -1 || index == this.type ? P2PInfoKt.toInfo(it) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markDirty(@NotNull P2PLocation key, @NotNull PartP2PTunnel<?> p2p) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(p2p, (String)"p2p");
        Map<P2PLocation, PartP2PTunnel<?>> map = this.listP2P;
        synchronized (map) {
            boolean bl = false;
            if (this.type == -1 || P2PUtilKt.getTypeIndex(p2p) == this.type) {
                this.listP2P.put(key, p2p);
                this.dirtyP2P.add(key);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<P2PInfo> getP2PUpdates() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.dirtyP2P;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            P2PInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            P2PLocation it = (P2PLocation)element$iv$iv;
            boolean bl2 = false;
            PartP2PTunnel<?> partP2PTunnel = this.listP2P.get(it);
            if ((partP2PTunnel != null ? P2PInfoKt.toInfo(partP2PTunnel) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List result = (List)destination$iv$iv;
        this.dirtyP2P.clear();
        return result;
    }

    @Nullable
    public final Pair<PartP2PTunnel<?>, PartP2PTunnel<?>> linkP2P(@NotNull P2PLocation inputIndex, @NotNull P2PLocation outputIndex) {
        PartP2PTunnel originalInput;
        Intrinsics.checkNotNullParameter((Object)inputIndex, (String)"inputIndex");
        Intrinsics.checkNotNullParameter((Object)outputIndex, (String)"outputIndex");
        PartP2PTunnel<?> partP2PTunnel = this.listP2P.get(inputIndex);
        if (partP2PTunnel == null) {
            return null;
        }
        PartP2PTunnel<?> input = partP2PTunnel;
        PartP2PTunnel<?> partP2PTunnel2 = this.listP2P.get(outputIndex);
        if (partP2PTunnel2 == null) {
            return null;
        }
        PartP2PTunnel<?> output = partP2PTunnel2;
        if (this.grid instanceof ISecurityGrid && !((ISecurityGrid)this.grid).hasPermission(this.player, SecurityPermissions.BUILD)) {
            return null;
        }
        if (!Intrinsics.areEqual(input.getClass(), output.getClass())) {
            TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromClass(input.getClass());
            Intrinsics.checkNotNull((Object)tunnelInfo);
            PartP2PTunnel<?> partP2PTunnel3 = this.changeP2PType(output, tunnelInfo);
            if (partP2PTunnel3 == null) {
                return null;
            }
            output = partP2PTunnel3;
        }
        if (Intrinsics.areEqual(input, output)) {
            return null;
        }
        long frequency = input.getFrequency();
        P2PCache cache = input.getProxy().getP2P();
        if (input.getFrequency() == 0L || input.isOutput()) {
            frequency = System.currentTimeMillis();
        }
        if (cache.getInput(frequency) != null && !Intrinsics.areEqual((Object)(originalInput = cache.getInput(frequency)), input)) {
            Intrinsics.checkNotNull((Object)originalInput);
            P2PLocation p2PLocation = P2PLocationKt.toLoc(originalInput);
            String string = input.getCustomName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCustomName(...)");
            this.updateP2P(p2PLocation, originalInput, frequency, true, string);
        }
        String string = input.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCustomName(...)");
        PartP2PTunnel<?> inputResult = this.updateP2P(inputIndex, input, frequency, false, string);
        String string2 = input.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCustomName(...)");
        PartP2PTunnel<?> outputResult = this.updateP2P(outputIndex, output, frequency, true, string2);
        if (input instanceof IInterfaceHost && output instanceof IInterfaceHost) {
            List drops = new ArrayList();
            IInterfaceHost iInterfaceHost = (IInterfaceHost)input;
            IInterfaceHost iInterfaceHost2 = (IInterfaceHost)output;
            Intrinsics.checkNotNull(inputResult, (String)"null cannot be cast to non-null type appeng.helpers.IInterfaceHost");
            IInterfaceHost iInterfaceHost3 = (IInterfaceHost)inputResult;
            Intrinsics.checkNotNull(outputResult, (String)"null cannot be cast to non-null type appeng.helpers.IInterfaceHost");
            this.handleInterface(iInterfaceHost, iInterfaceHost2, iInterfaceHost3, (IInterfaceHost)outputResult, drops);
            Platform.spawnDrops((World)this.player.field_70170_p, (int)((IInterfaceViewable)output).getLocation().x, (int)((IInterfaceViewable)output).getLocation().y, (int)((IInterfaceViewable)output).getLocation().z, (List)drops);
        }
        return TuplesKt.to(inputResult, outputResult);
    }

    @Nullable
    public final PartP2PTunnel<?> unlinkP2P(@NotNull P2PLocation p2pIndex) {
        Intrinsics.checkNotNullParameter((Object)p2pIndex, (String)"p2pIndex");
        PartP2PTunnel<?> partP2PTunnel = this.listP2P.get(p2pIndex);
        if (partP2PTunnel == null) {
            return null;
        }
        PartP2PTunnel<?> tunnel = partP2PTunnel;
        long oldFreq = tunnel.getFrequency();
        if (oldFreq == 0L) {
            return tunnel;
        }
        String string = tunnel.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCustomName(...)");
        return this.updateP2P(p2pIndex, tunnel, 0L, false, string);
    }

    private final PartP2PTunnel<?> updateP2P(P2PLocation key, PartP2PTunnel<?> tunnel, long frequency, boolean output, String name) {
        ForgeDirection side = tunnel.getSide();
        NBTTagCompound data = new NBTTagCompound();
        tunnel.getHost().removePart(side, true);
        ItemStack itemStack = tunnel.getItemStack(PartItemStack.Wrench);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        ItemStack p2pItem = itemStack;
        p2pItem.func_77955_b(data);
        data.func_74772_a("freq", frequency);
        ItemStack newType = ItemStack.func_77949_a((NBTTagCompound)data);
        IPartHost iPartHost = tunnel.getHost();
        if (iPartHost == null || (iPartHost = iPartHost.addPart(newType, side, this.player)) == null) {
            throw new RuntimeException("Cannot bind");
        }
        IPartHost dir = iPartHost;
        IPart iPart = tunnel.getHost().getPart((ForgeDirection)dir);
        Intrinsics.checkNotNullExpressionValue((Object)iPart, (String)"getPart(...)");
        IPart newBus = iPart;
        if (newBus instanceof PartP2PTunnel) {
            P2PUtilKt.setOutputProperty((PartP2PTunnel)newBus, output);
            if (!StringsKt.isBlank((CharSequence)name)) {
                ((PartP2PTunnel)newBus).setCustomName(name);
            }
            try {
                P2PCache p2p = ((PartP2PTunnel)newBus).getProxy().getP2P();
                p2p.updateFreq((PartP2PTunnel)newBus, frequency);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            ((PartP2PTunnel)newBus).onTunnelNetworkChange();
            this.markDirty(key, (PartP2PTunnel)newBus);
            return (PartP2PTunnel)newBus;
        }
        throw new IllegalStateException("Cannot bind");
    }

    private final PartP2PTunnel<?> changeP2PType(PartP2PTunnel<?> tunnel, TunnelInfo newType) {
        if (Intrinsics.areEqual((Object)BetterP2P.INSTANCE.getProxy().getP2PFromClass(tunnel.getClass()), (Object)newType)) {
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.advanced_memory_card.error.same_type", new Object[0]));
            return null;
        }
        if (Intrinsics.areEqual(newType.getClazz().getSuperclass(), PartP2PTunnelStatic.class)) {
            boolean canConvert = false;
            Intrinsics.checkNotNullExpressionValue((Object)this.player.field_71071_by.field_70462_a, (String)"mainInventory");
            Object[] objectArray = this.player.field_71071_by.field_70462_a;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack stack;
                int i2 = i;
                ItemStack itemStack = stack = objectArray[i];
                boolean bl = itemStack != null ? itemStack.func_77969_a(newType.getStack()) : false;
                if (!bl) continue;
                this.player.field_71071_by.func_70298_a(i2, 1);
                canConvert = true;
                break;
            }
            if (!canConvert) {
                objectArray = new Object[]{1, newType.getStack().func_82833_r()};
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.advanced_memory_card.error.missing_items", objectArray));
                return null;
            }
        }
        if (tunnel instanceof PartP2PTunnelStatic) {
            ItemStack drop = ItemStack.func_77944_b((ItemStack)((PartP2PTunnelStatic)tunnel).getItemStack());
            drop.field_77994_a = 1;
            if (!this.player.field_71071_by.func_70441_a(drop)) {
                Object[] objectArray = new ItemStack[]{drop};
                List drops = CollectionsKt.mutableListOf((Object[])objectArray);
                tunnel.getDrops(drops, false);
                Platform.spawnDrops((World)this.player.field_70170_p, (int)this.player.field_70118_ct, (int)this.player.field_70117_cu, (int)this.player.field_70116_cv, (List)drops);
            }
        }
        IPartHost host = tunnel.getHost();
        host.removePart(tunnel.getSide(), false);
        ForgeDirection dir = host.addPart(newType.getStack(), tunnel.getSide(), this.player);
        IPart newPart = host.getPart(dir);
        if (newPart instanceof PartP2PTunnel) {
            P2PUtilKt.setOutputProperty((PartP2PTunnel)newPart, tunnel.isOutput());
            try {
                P2PCache p2PCache = ((PartP2PTunnel)newPart).getProxy().getP2P();
                Intrinsics.checkNotNullExpressionValue((Object)p2PCache, (String)"getP2P(...)");
                P2PCache p2p = p2PCache;
                p2p.updateFreq((PartP2PTunnel)newPart, tunnel.getFrequency());
                return (PartP2PTunnel)newPart;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public final boolean changeAllP2Ps(@NotNull P2PLocation p2p, @NotNull TunnelInfo newType) {
        Intrinsics.checkNotNullParameter((Object)p2p, (String)"p2p");
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        if (this.grid instanceof ISecurityGrid && !((ISecurityGrid)this.grid).hasPermission(this.player, SecurityPermissions.BUILD)) {
            return false;
        }
        PartP2PTunnel partP2PTunnel = this.listP2P.get(p2p);
        if (partP2PTunnel == null) {
            return false;
        }
        PartP2PTunnel tunnel = partP2PTunnel;
        try {
            if (tunnel.isOutput() && tunnel.getInput() != null) {
                tunnel = tunnel.getInput();
            }
            TunnelCollection tunnelCollection = tunnel.getOutputs();
            Intrinsics.checkNotNullExpressionValue((Object)tunnelCollection, (String)"getOutputs(...)");
            List outputs = CollectionsKt.toMutableList((Iterable)((Iterable)tunnelCollection));
            if (Intrinsics.areEqual(newType.getClazz().getSuperclass(), PartP2PTunnelStatic.class)) {
                int amt = outputs.size() + 1;
                int hasItems = 0;
                Object[] objectArray = ArrayIteratorKt.iterator((Object[])this.player.field_71071_by.field_70462_a);
                while (objectArray.hasNext()) {
                    ItemStack stack;
                    ItemStack itemStack = stack = (ItemStack)objectArray.next();
                    boolean bl = itemStack != null ? itemStack.func_77969_a(newType.getStack()) : false;
                    if (!bl || (hasItems += stack.field_77994_a) < amt) continue;
                }
                if (hasItems < amt) {
                    objectArray = new Object[]{amt, newType.getStack().func_82833_r()};
                    this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.advanced_memory_card.error.missing_items", objectArray));
                    return false;
                }
            }
            this.changeP2PType(tunnel, newType);
            for (PartP2PTunnel o : outputs) {
                Intrinsics.checkNotNull((Object)o);
                this.changeP2PType(o, newType);
            }
            return true;
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInterface(IInterfaceHost oldIn, IInterfaceHost oldOut, IInterfaceHost newIn, IInterfaceHost newOut, List<ItemStack> drops) {
        IInventory iInventory = oldIn.getInterfaceDuality().getInventoryByName("upgrades");
        Intrinsics.checkNotNull((Object)iInventory, (String)"null cannot be cast to non-null type appeng.parts.automation.UpgradeInventory");
        UpgradeInventory upgradesIn = (UpgradeInventory)iInventory;
        Iterable $this$forEachIndexed$iv = (Iterable)upgradesIn;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void stack2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack itemStack = (ItemStack)item$iv;
            int index = n;
            boolean bl = false;
            IInventory iInventory2 = newIn.getInterfaceDuality().getInventoryByName("upgrades");
            Intrinsics.checkNotNull((Object)iInventory2, (String)"null cannot be cast to non-null type appeng.parts.automation.UpgradeInventory");
            ((UpgradeInventory)iInventory2).func_70299_a(index, (ItemStack)stack2);
        }
        IInventory iInventory3 = oldOut.getInterfaceDuality().getInventoryByName("upgrades");
        Intrinsics.checkNotNull((Object)iInventory3, (String)"null cannot be cast to non-null type appeng.parts.automation.UpgradeInventory");
        UpgradeInventory upgradesOut = (UpgradeInventory)iInventory3;
        Iterable $this$forEachIndexed$iv2 = (Iterable)upgradesOut;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv2) {
            void stack3;
            int stack2;
            if ((stack2 = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack index = (ItemStack)item$iv;
            int index2 = stack2;
            boolean bl = false;
            IInventory iInventory4 = newOut.getInterfaceDuality().getInventoryByName("upgrades");
            Intrinsics.checkNotNull((Object)iInventory4, (String)"null cannot be cast to non-null type appeng.parts.automation.UpgradeInventory");
            ((UpgradeInventory)iInventory4).func_70299_a(index2, (ItemStack)stack3);
        }
        AppEngInternalInventory appEngInternalInventory = oldIn.getInterfaceDuality().getStorage();
        Intrinsics.checkNotNull((Object)appEngInternalInventory, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
        AppEngInternalInventory itemsIn = appEngInternalInventory;
        Iterable $this$forEachIndexed$iv3 = (Iterable)itemsIn;
        boolean $i$f$forEachIndexed3 = false;
        int index$iv3 = 0;
        for (Object item$iv : $this$forEachIndexed$iv3) {
            void stack4;
            int stack3;
            if ((stack3 = index$iv3++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack index2 = (ItemStack)item$iv;
            int index = stack3;
            boolean bl = false;
            AppEngInternalInventory appEngInternalInventory2 = newIn.getInterfaceDuality().getStorage();
            Intrinsics.checkNotNull((Object)appEngInternalInventory2, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
            appEngInternalInventory2.func_70299_a(index, (ItemStack)stack4);
        }
        AppEngInternalInventory appEngInternalInventory3 = oldOut.getInterfaceDuality().getStorage();
        Intrinsics.checkNotNull((Object)appEngInternalInventory3, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
        AppEngInternalInventory itemsOut = appEngInternalInventory3;
        Iterable $this$forEachIndexed$iv4 = (Iterable)itemsOut;
        boolean $i$f$forEachIndexed4 = false;
        int index$iv4 = 0;
        for (Object item$iv : $this$forEachIndexed$iv4) {
            void stack;
            int stack4;
            if ((stack4 = index$iv4++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack index = (ItemStack)item$iv;
            int index3 = stack4;
            boolean bl = false;
            AppEngInternalInventory appEngInternalInventory4 = newOut.getInterfaceDuality().getStorage();
            Intrinsics.checkNotNull((Object)appEngInternalInventory4, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
            appEngInternalInventory4.func_70299_a(index3, (ItemStack)stack);
        }
        IConfigManager settingsIn = oldIn.getInterfaceDuality().getConfigManager();
        Set set = settingsIn.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getSettings(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Settings it = (Settings)element$iv;
            boolean bl = false;
            newIn.getConfigManager().putSetting(it, settingsIn.getSetting(it));
        }
        IConfigManager settingsOut = oldOut.getInterfaceDuality().getConfigManager();
        Set set2 = settingsOut.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getSettings(...)");
        Iterable $this$forEach$iv2 = set2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Settings it = (Settings)element$iv;
            boolean bl = false;
            newOut.getConfigManager().putSetting(it, settingsOut.getSetting(it));
        }
        AppEngInternalInventory appEngInternalInventory5 = oldIn.getInterfaceDuality().getPatterns();
        Intrinsics.checkNotNull((Object)appEngInternalInventory5, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
        AppEngInternalInventory patternsIn = appEngInternalInventory5;
        Iterable $this$forEachIndexed$iv5 = (Iterable)patternsIn;
        boolean $i$f$forEachIndexed5 = false;
        int index$iv5 = 0;
        for (Object item$iv : $this$forEachIndexed$iv5) {
            void stack;
            int n;
            if ((n = index$iv5++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack itemStack = (ItemStack)item$iv;
            int index = n;
            boolean bl = false;
            AppEngInternalInventory appEngInternalInventory6 = newIn.getInterfaceDuality().getPatterns();
            Intrinsics.checkNotNull((Object)appEngInternalInventory6, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
            appEngInternalInventory6.func_70299_a(index, (ItemStack)stack);
        }
        AppEngInternalInventory appEngInternalInventory7 = oldOut.getInterfaceDuality().getPatterns();
        Intrinsics.checkNotNull((Object)appEngInternalInventory7, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
        AppEngInternalInventory patternsOut = appEngInternalInventory7;
        CollectionsKt.addAll((Collection)drops, (Iterable)((Iterable)patternsOut));
    }
}

