/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.network;

import com.projecturanus.betterp2p.network.P2PInfo;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"readInfo", "Lcom/projecturanus/betterp2p/network/P2PInfo;", "buf", "Lio/netty/buffer/ByteBuf;", "writeInfo", "", "info", "betterp2p"})
public final class S2CRefreshInfoKt {
    @NotNull
    public static final P2PInfo readInfo(@NotNull ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        long freq = buf.readLong();
        int posX = buf.readInt();
        int posY = buf.readInt();
        int posZ = buf.readInt();
        int world = buf.readInt();
        ForgeDirection facing = ForgeDirection.values()[buf.readInt()];
        int nameLength = buf.readShort() - 1;
        String name = "";
        int i = 0;
        if (i <= nameLength) {
            while (true) {
                name = name + buf.readChar();
                if (i == nameLength) break;
                ++i;
            }
        }
        return new P2PInfo(freq, posX, posY, posZ, world, facing, name, buf.readBoolean(), buf.readBoolean());
    }

    public static final void writeInfo(@NotNull ByteBuf buf, @NotNull P2PInfo info) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        buf.writeLong(info.getFrequency());
        buf.writeInt(info.getPosX());
        buf.writeInt(info.getPosY());
        buf.writeInt(info.getPosZ());
        buf.writeInt(info.getWorld());
        buf.writeInt(info.getFacing().ordinal());
        buf.writeShort(info.getName().length());
        String string = info.getName();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            buf.writeChar((int)c);
        }
        buf.writeBoolean(info.getOutput());
        buf.writeBoolean(info.getHasChannel());
    }
}

