/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.client.render;

import com.projecturanus.betterp2p.util.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ShadowRenderer {
    public static void renderBlockPos(final List<Integer> p, List<Integer> center, double relX, double relY, double relZ, float red, float green, float blue) {
        if (p == null) {
            return;
        }
        ShadowRenderer.renderBlockList((List<List<Integer>>)new ArrayList<List<Integer>>(){
            {
                this.add(p);
            }
        }, center, relX, relY, relZ, red, green, blue);
    }

    public static void renderBlockPhantom(World world, List<Integer> pos, ItemStack stack, double relX, double relY, double relZ, List<Integer> target, boolean isSolid) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            int stateFromStack = stack.func_77960_j();
            ShadowRenderer.renderBlockPhantom(world, pos, stateFromStack, relX, relY, relZ, target, isSolid);
        }
    }

    public static void renderBlockPhantom(World world, List<Integer> pos, int state, double relX, double relY, double relZ, List<Integer> target, boolean isSolid) {
        int xOffset = target.get(0) - pos.get(0);
        int yOffset = target.get(1) - pos.get(1);
        int zOffset = target.get(2) - pos.get(2);
        Tessellator tessellator = Tessellator.field_78398_a;
        GlStateManager.pushMatrix();
        GlStateManager.translate(relX + 0.5, relY + 0.5, relZ + 0.5);
        RenderHelper.func_74518_a();
        if (!isSolid) {
            GlStateManager.blendFunc(770, 775);
            GlStateManager.enableBlend();
            GlStateManager.disableCull();
        }
        tessellator.func_78371_b(7);
        tessellator.func_78373_b(-0.5 - (double)pos.get(0).intValue() + (double)xOffset, -0.5 - (double)pos.get(1).intValue() + (double)yOffset, -0.5 - (double)pos.get(2).intValue() + (double)zOffset);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.popMatrix();
    }

    public static void renderBlockList(List<List<Integer>> blockPosList, List<Integer> center, double relX, double relY, double relZ, float red, float green, float blue) {
        GlStateManager.pushAttrib();
        GlStateManager.pushMatrix();
        GlStateManager.translate(relX + 0.5, relY + 0.5, relZ + 0.5);
        GlStateManager.disableLighting();
        GlStateManager.disableTexture2D();
        GlStateManager.blendFunc(770, 771);
        GlStateManager.enableBlend();
        float alpha = 0.5f;
        GlStateManager.color(red, green, blue, alpha);
        if (Minecraft.func_71379_u()) {
            GlStateManager.shadeModel(7425);
        } else {
            GlStateManager.shadeModel(7424);
        }
        for (List<Integer> p : blockPosList) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)(center.get(0) - p.get(0)) * -1.0f, (float)(center.get(1) - p.get(1)) * -1.0f, (float)(center.get(2) - p.get(2)) * -1.0f);
            ShadowRenderer.shadedCube(0.4f);
            GlStateManager.popMatrix();
        }
        GlStateManager.disableBlend();
        GlStateManager.enableTexture2D();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        GlStateManager.popAttrib();
    }

    private static void shadedCube(float scale) {
        float size = 1.0f * scale;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(7);
        tessellator.func_78377_a((double)(-size), (double)(-size), (double)size);
        tessellator.func_78377_a((double)size, (double)(-size), (double)size);
        tessellator.func_78377_a((double)size, (double)size, (double)size);
        tessellator.func_78377_a((double)(-size), (double)size, (double)size);
        tessellator.func_78377_a((double)(-size), (double)(-size), (double)(-size));
        tessellator.func_78377_a((double)(-size), (double)size, (double)(-size));
        tessellator.func_78377_a((double)size, (double)size, (double)(-size));
        tessellator.func_78377_a((double)size, (double)(-size), (double)(-size));
        tessellator.func_78377_a((double)(-size), (double)(-size), (double)(-size));
        tessellator.func_78377_a((double)(-size), (double)(-size), (double)size);
        tessellator.func_78377_a((double)(-size), (double)size, (double)size);
        tessellator.func_78377_a((double)(-size), (double)size, (double)(-size));
        tessellator.func_78377_a((double)size, (double)(-size), (double)(-size));
        tessellator.func_78377_a((double)size, (double)size, (double)(-size));
        tessellator.func_78377_a((double)size, (double)size, (double)size);
        tessellator.func_78377_a((double)size, (double)(-size), (double)size);
        tessellator.func_78377_a((double)(-size), (double)size, (double)(-size));
        tessellator.func_78377_a((double)(-size), (double)size, (double)size);
        tessellator.func_78377_a((double)size, (double)size, (double)size);
        tessellator.func_78377_a((double)size, (double)size, (double)(-size));
        tessellator.func_78377_a((double)(-size), (double)(-size), (double)(-size));
        tessellator.func_78377_a((double)size, (double)(-size), (double)(-size));
        tessellator.func_78377_a((double)size, (double)(-size), (double)size);
        tessellator.func_78377_a((double)(-size), (double)(-size), (double)size);
        tessellator.func_78381_a();
    }
}

