/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load;

import alexiil.mods.load.BetterLoadingScreen;
import alexiil.mods.load.LoadingFrame;
import alexiil.mods.load.MinecraftDisplayerWrapper;
import alexiil.mods.load.Translation;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public class ProgressDisplayer {
    private static boolean hasTurnedSplashOff = false;
    private static boolean forgeSplashWasTrue = false;
    private static IDisplayer displayer;
    private static int clientState;
    public static Configuration cfg;
    public static boolean playSound;
    public static File coreModLocation;
    public static ModContainer modContainer;
    private static boolean hasInitRL;

    public static boolean isClient() {
        StackTraceElement[] steArr;
        if (clientState != -1) {
            return clientState == 1;
        }
        for (StackTraceElement ste : steArr = Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().startsWith("cpw.mods.fml.relauncher.ServerLaunchWrapper")) continue;
            clientState = 0;
            return false;
        }
        clientState = 1;
        return true;
    }

    private static void loadResourceLoader() {
        try {
            Class<?> resLoaderClass = Class.forName("lumien.resourceloader.ResourceLoader");
            Object instance = resLoaderClass.newInstance();
            resLoaderClass.getField("INSTANCE").set(null, instance);
            Method m = resLoaderClass.getMethod("preInit", FMLPreInitializationEvent.class);
            m.invoke(instance, new Object[]{null});
            BetterLoadingScreen.log.debug("Resource loader loaded early successfully :)");
        }
        catch (ClassNotFoundException ex) {
            BetterLoadingScreen.log.warn("Resource loader not loaded, not initialising early");
        }
        catch (Throwable t) {
            BetterLoadingScreen.log.error("Resource Loader Compat FAILED!");
            t.printStackTrace();
        }
    }

    public static void start(File coremodLocation) {
        LoadingFrame.setSystemLAF();
        coreModLocation = coremodLocation;
        if (coreModLocation == null) {
            coreModLocation = new File("./../bin/");
        }
        ModMetadata md = new ModMetadata();
        md.name = "Better Loading Screen GTNH";
        md.modId = "betterloadingscreen";
        modContainer = new DummyModContainer(md){

            public Class<?> getCustomResourcePackClass() {
                return FMLFileResourcePack.class;
            }

            public File getSource() {
                return coreModLocation;
            }

            public String getModId() {
                return "betterloadingscreen";
            }
        };
        File fileOld = new File("./config/Betterloadingscreen/betterloadingscreen.cfg");
        String n = System.lineSeparator();
        cfg = new Configuration(fileOld);
        boolean useMinecraft = ProgressDisplayer.isClient();
        if (useMinecraft) {
            String comment = "Whether or not to use minecraft's display to show the progress. This looks better, but there is a possibility of not being ";
            comment = comment + "compatible, so if you do have any strange crash reports or compatibility issues, try setting this to false" + n + "Note: IIRC, setting this to false makes the screen black";
            useMinecraft = cfg.getBoolean("useMinecraft", "general", true, comment);
        }
        playSound = cfg.getBoolean("playSound", "general", true, "Play a sound after minecraft has finished starting up");
        displayer = useMinecraft ? new MinecraftDisplayerWrapper() : (!GraphicsEnvironment.isHeadless() ? new FrameDisplayer() : new LoggingDisplayer());
        displayer.open(cfg);
        cfg.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setForgeSplashEnabled(boolean enabled) throws IOException {
        boolean hasTurnedOff = false;
        File configFile = new File(Minecraft.func_71410_x().field_71412_D, "config/splash.properties");
        FileReader r = null;
        Properties config = new Properties();
        try {
            r = new FileReader(configFile);
            config.load(r);
        }
        catch (IOException e) {
            try {
                BetterLoadingScreen.log.info("Forge splash screen settings not found, will create a dummy one");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(r);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)r);
        }
        IOUtils.closeQuietly((Reader)r);
        config.setProperty("enabled", Boolean.toString(enabled));
        FileWriter w = null;
        try {
            w = new FileWriter(configFile);
            config.store(w, "Splash screen properties");
            hasTurnedOff = true;
            BetterLoadingScreen.log.info("Turned Forge splash screen " + (enabled ? "on" : "off") + " in splash.properties");
        }
        catch (IOException e) {
            try {
                BetterLoadingScreen.log.log(Level.ERROR, "Could not turn Forge splash screen " + (enabled ? "on" : "off") + " in splash.properties", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(w);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)w);
        }
        IOUtils.closeQuietly((Writer)w);
        return hasTurnedOff;
    }

    public static void displayProgress(String text, float percent) throws IOException {
        if (!hasTurnedSplashOff) {
            hasTurnedSplashOff = true;
            if (ProgressDisplayer.setForgeSplashEnabled(false)) {
                forgeSplashWasTrue = true;
            }
        }
        if (!hasInitRL) {
            ProgressDisplayer.loadResourceLoader();
            ProgressDisplayer.overrideForgeSplashProgress();
            hasInitRL = true;
        }
        displayer.displayProgress(text, percent);
    }

    public static void close() throws IOException {
        if (displayer == null) {
            return;
        }
        displayer.close();
        displayer = null;
        if (ProgressDisplayer.isClient() && playSound) {
            new Thread(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    MinecraftDisplayerWrapper.playFinishedSound();
                }
            }.start();
        }
        if (forgeSplashWasTrue) {
            ProgressDisplayer.setForgeSplashEnabled(true);
        }
    }

    private static void overrideForgeSplashProgress() {
        Class<?> cl = null;
        Field fi = null;
        try {
            cl = Class.forName("cpw.mods.fml.client.SplashProgress");
            fi = cl.getDeclaredField("enabled");
            fi.setAccessible(true);
            fi.set(null, false);
            fi = cl.getDeclaredField("done");
            fi.setAccessible(true);
            fi.set(null, true);
        }
        catch (Throwable t) {
            BetterLoadingScreen.log.error("Could not override forge's splash screen for some reason...");
            BetterLoadingScreen.log.error("class = " + cl);
            BetterLoadingScreen.log.error("field = " + fi);
            t.printStackTrace();
        }
    }

    public static void minecraftDisplayFirstProgress() throws IOException {
        ProgressDisplayer.displayProgress(Translation.translate("betterloadingscreen.state.minecraft_init", "Minecraft Initializing"), 0.0f);
    }

    static {
        clientState = -1;
        hasInitRL = false;
    }

    public static class LoggingDisplayer
    implements IDisplayer {
        @Override
        public void open(Configuration cfg) {
        }

        @Override
        public void displayProgress(String text, float percent) {
            BetterLoadingScreen.log.info(text + " (" + (int)(percent * 100.0f) + "%)");
        }

        @Override
        public void close() {
        }
    }

    public static class FrameDisplayer
    implements IDisplayer {
        private LoadingFrame frame = null;

        @Override
        public void open(Configuration cfg) {
            this.frame = LoadingFrame.openWindow();
            if (this.frame != null) {
                this.frame.setMessage("Minecraft Forge Starting");
                this.frame.setProgress(0.0);
            }
        }

        @Override
        public void displayProgress(String text, float percent) {
            if (this.frame == null) {
                return;
            }
            this.frame.setMessage(text);
            this.frame.setProgress(percent * 100.0f);
            this.frame.repaint();
        }

        @Override
        public void close() {
            if (this.frame != null) {
                this.frame.dispose();
            }
        }
    }

    public static interface IDisplayer {
        public void open(Configuration var1);

        public void displayProgress(String var1, float var2);

        public void close();
    }
}

