/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.heraldry;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;
import mods.battlegear2.api.core.BattlegearUtils;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class CrestImages
implements Comparable<CrestImages> {
    private static final int X_AMOUNT = 16;
    private static final int Y_AMOUNT = 16;
    private int ID;
    private String name;
    private byte[][] col;
    public static CrestImages[] images = new CrestImages[1281];
    private BufferedImage imageCache = null;
    private int lastRGB;
    public static final ResourceLocation crestNames = new ResourceLocation("battlegear2:textures/heraldry/crests/names");

    private CrestImages() {
        this.ID = 0;
        this.name = "None";
        this.col = new byte[][]{{0}};
        CrestImages.images[this.ID] = this;
    }

    private CrestImages(int sheet, int x_pos, int y_pos, String name, BufferedImage image) {
        this.ID = x_pos + y_pos * 16 + sheet * 16 * 16 + 1;
        this.name = name;
        BufferedImage sub = image.getSubimage(x_pos * 16, y_pos * 16, image.getWidth() / 16, image.getHeight() / 16);
        this.col = new byte[sub.getWidth()][sub.getHeight()];
        for (int x = 0; x < sub.getWidth(); ++x) {
            for (int y = 0; y < sub.getHeight(); ++y) {
                this.col[x][y] = (byte)(sub.getRGB(x, y) >> 16 & 0xFF);
            }
        }
        CrestImages.images[this.ID] = this;
    }

    public BufferedImage getImage(int rgb) {
        if (this.imageCache != null && rgb == this.lastRGB) {
            return this.imageCache;
        }
        this.imageCache = new BufferedImage(this.col.length, this.col[0].length, 6);
        System.out.println(this.imageCache.getHeight());
        this.lastRGB = rgb;
        for (int x = 0; x < this.col.length; ++x) {
            for (int y = 0; y < this.col[x].length; ++y) {
                this.imageCache.setRGB(x, y, rgb & 0xFFFFFF | this.col[x][y] << 24 & 0xFF000000);
            }
        }
        return this.imageCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialise(IResourceManager rm) {
        new CrestImages();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(rm.func_110536_a(crestNames).func_110527_b()));
            int current_sheet = 0;
            int currentID = 0;
            BufferedImage image = null;
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.startsWith("Sheet: ")) {
                    currentID = 0;
                    current_sheet = Integer.parseInt(String.valueOf(line.charAt(line.length() - 1)));
                    image = ImageIO.read(rm.func_110536_a(new ResourceLocation("battlegear2:textures/heraldry/crests/icons-" + current_sheet + ".png")).func_110527_b());
                    continue;
                }
                String[] names = line.split(",");
                for (int i = 0; i < names.length; ++i) {
                    int x = currentID % 16;
                    int y = currentID / 16;
                    new CrestImages(current_sheet, x, y, names[i], image);
                    ++currentID;
                }
            }
            BattlegearUtils.closeStream(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BattlegearUtils.closeStream(reader);
        }
    }

    public String toString() {
        return "CrestImages{ID=" + this.ID + ", name='" + this.name + ", size='" + this.col.length + "x" + this.col[0].length + '\'' + '}';
    }

    @Override
    public int compareTo(CrestImages crestImages) {
        if (this.ID == crestImages.ID) {
            return 0;
        }
        if (this.ID == 0) {
            return 1;
        }
        if (crestImages.ID == 0) {
            return -1;
        }
        return this.name.compareTo(crestImages.name);
    }

    public int getId() {
        return this.ID;
    }
}

