/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.EnchantmentHelper;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.packet.BattlegearAnimationPacket;
import mods.battlegear2.packet.BattlegearShieldBlockPacket;
import mods.battlegear2.utils.EnumBGAnimations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import xonin.backhand.api.core.BackhandUtils;

public final class BattlegearClientTickHandeler {
    private static final int FLASH_MAX = 30;
    private final KeyBinding special = new KeyBinding(I18n.func_135052_a((String)"key.special", (Object[])new Object[0]), 0, "key.categories.battlegear");
    private final Minecraft mc;
    private float blockBar = 1.0f;
    private float partialTick;
    private boolean wasBlocking = false;
    private int flashTimer;
    private boolean specialDone = false;
    public static final BattlegearClientTickHandeler INSTANCE = new BattlegearClientTickHandeler();

    private BattlegearClientTickHandeler() {
        ClientRegistry.registerKeyBinding((KeyBinding)this.special);
        this.mc = FMLClientHandler.instance().getClient();
    }

    @SubscribeEvent
    public void keyDown(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71439_g != null && this.mc.field_71441_e != null && this.mc.field_71462_r == null) {
            EntityClientPlayerMP player = this.mc.field_71439_g;
            if (event.phase == TickEvent.Phase.START) {
                if (!this.specialDone && this.special.func_151470_d() && ((IBattlePlayer)player).battlegear2$getSpecialActionTimer() == 0) {
                    ItemStack quiver = QuiverArrowRegistry.getArrowContainer((EntityPlayer)player);
                    if (quiver != null) {
                        FMLProxyPacket p = new BattlegearAnimationPacket(EnumBGAnimations.SpecialAction, (EntityPlayer)player).generatePacket();
                        Battlegear.packetHandler.sendPacketToServer(p);
                        ((IBattlePlayer)player).battlegear2$setSpecialActionTimer(2);
                    } else {
                        float shieldBashPenalty;
                        ItemStack offhand = BackhandUtils.getOffhandItem((EntityPlayer)player);
                        if (offhand != null && offhand.func_77973_b() instanceof IShield && this.blockBar >= (shieldBashPenalty = 0.33f - 0.06f * (float)EnchantmentHelper.getEnchantmentLevel(BaseEnchantment.bashWeight, offhand))) {
                            FMLProxyPacket p = new BattlegearAnimationPacket(EnumBGAnimations.SpecialAction, (EntityPlayer)player).generatePacket();
                            Battlegear.packetHandler.sendPacketToServer(p);
                            ((IBattlePlayer)player).battlegear2$setSpecialActionTimer(((IShield)offhand.func_77973_b()).getBashTimer(offhand));
                            this.blockBar -= shieldBashPenalty;
                        }
                    }
                    this.specialDone = true;
                } else if (this.specialDone && !this.special.func_151470_d()) {
                    this.specialDone = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player == this.mc.field_71439_g && event.phase == TickEvent.Phase.START) {
            this.tickStart((EntityPlayer)this.mc.field_71439_g);
        }
    }

    private void tickStart(EntityPlayer player) {
        ItemStack offhand = BackhandUtils.getOffhandItem((EntityPlayer)player);
        if (offhand != null && offhand.func_77973_b() instanceof IShield) {
            if (this.flashTimer == 30) {
                player.field_70181_x /= 2.0;
            }
            if (this.flashTimer > 0) {
                --this.flashTimer;
            }
            if (this.mc.field_71474_y.field_74313_G.func_151470_d() && !player.field_82175_bq) {
                this.blockBar -= ((IShield)offhand.func_77973_b()).getDecayRate(offhand);
                if (this.blockBar > 0.0f) {
                    if (!this.wasBlocking) {
                        Battlegear.packetHandler.sendPacketToServer(new BattlegearShieldBlockPacket(true, player).generatePacket());
                    }
                    this.wasBlocking = true;
                } else {
                    if (this.wasBlocking) {
                        Battlegear.packetHandler.sendPacketToServer(new BattlegearShieldBlockPacket(false, player).generatePacket());
                    }
                    this.wasBlocking = false;
                    this.blockBar = 0.0f;
                }
            } else {
                if (this.wasBlocking) {
                    Battlegear.packetHandler.sendPacketToServer(new BattlegearShieldBlockPacket(false, player).generatePacket());
                }
                this.wasBlocking = false;
                this.blockBar += ((IShield)offhand.func_77973_b()).getRecoveryRate(offhand);
                if (this.blockBar > 1.0f) {
                    this.blockBar = 1.0f;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.partialTick = event.renderTickTime;
        }
    }

    public static void resetFlash() {
        BattlegearClientTickHandeler.INSTANCE.flashTimer = 30;
    }

    public static int getFlashTimer() {
        return BattlegearClientTickHandeler.INSTANCE.flashTimer;
    }

    public static float getBlockTime() {
        return BattlegearClientTickHandeler.INSTANCE.blockBar;
    }

    public static void reduceBlockTime(float value) {
        BattlegearClientTickHandeler.INSTANCE.blockBar -= value;
    }

    public static float getPartialTick() {
        return BattlegearClientTickHandeler.INSTANCE.partialTick;
    }
}

