/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.IInventoryPlayerBattle;
import mods.battlegear2.packet.AbstractMBPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public final class BattlegearSyncItemPacket
extends AbstractMBPacket {
    public static final String packetName = "MB2|SyncItem";
    private String user;
    private InventoryPlayer inventory;
    private EntityPlayer player;

    public BattlegearSyncItemPacket(EntityPlayer player) {
        this(player.func_70005_c_(), player.field_71071_by, player);
    }

    private BattlegearSyncItemPacket(String user, InventoryPlayer inventory, EntityPlayer player) {
        this.user = user;
        this.inventory = inventory;
        this.player = player;
    }

    public BattlegearSyncItemPacket() {
    }

    @Override
    public void process(ByteBuf inputStream, EntityPlayer player) {
        this.user = ByteBufUtils.readUTF8String((ByteBuf)inputStream);
        this.player = player.field_70170_p.func_72924_a(this.user);
        if (this.player != null) {
            int current = inputStream.readInt();
            if (IInventoryPlayerBattle.isValidSwitch(current)) {
                this.player.field_71071_by.field_70461_c = current;
            }
            if (player.field_70170_p.field_72995_K) {
                ItemStack temp = ByteBufUtils.readItemStack((ByteBuf)inputStream);
                if (!ItemStack.func_77989_b((ItemStack)this.player.func_71045_bC(), (ItemStack)temp)) {
                    BattlegearUtils.setPlayerCurrentItem(this.player, temp);
                }
                for (int i = 0; i < 18; ++i) {
                    ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)inputStream);
                    if (ItemStack.func_77989_b((ItemStack)this.player.field_71071_by.func_70301_a(150 + i), (ItemStack)stack)) continue;
                    ((IInventoryPlayerBattle)this.player.field_71071_by).battlegear2$setInventorySlotContents(150 + i, stack, false);
                }
            } else if (BattlegearUtils.isPlayerInBattlemode(this.player)) {
                ItemStack inUse = ByteBufUtils.readItemStack((ByteBuf)inputStream);
                int time = inputStream.readInt();
                if (inUse != null && time > 0) {
                    this.player.func_71008_a(inUse, time);
                }
            }
            ((IBattlePlayer)this.player).battlegear2$setSpecialActionTimer(0);
        }
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void write(ByteBuf out) {
        ByteBufUtils.writeUTF8String((ByteBuf)out, (String)this.user);
        out.writeInt(this.inventory.field_70461_c);
        if (!this.player.field_70170_p.field_72995_K) {
            ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)this.inventory.func_70448_g());
            for (int i = 0; i < 18; ++i) {
                ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)this.inventory.func_70301_a(i + 150));
            }
        } else if (BattlegearUtils.isPlayerInBattlemode(this.player)) {
            ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)this.player.func_71011_bu());
            out.writeInt(this.player.func_71052_bv());
        }
    }
}

