/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.EnchantmentHelper;
import mods.battlegear2.api.IDyable;
import mods.battlegear2.api.RenderItemBarEvent;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.IInventoryPlayerBattle;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.api.weapons.IBackStabbable;
import mods.battlegear2.api.weapons.IExtendedReachWeapon;
import mods.battlegear2.api.weapons.IHitTimeModifier;
import mods.battlegear2.api.weapons.IPenetrateWeapon;
import mods.battlegear2.client.BattlegearClientTickHandeler;
import mods.battlegear2.client.ClientProxy;
import mods.battlegear2.client.gui.BattlegearInGameGUI;
import mods.battlegear2.client.gui.controls.GuiBGInventoryButton;
import mods.battlegear2.client.gui.controls.GuiPlaceableButton;
import mods.battlegear2.client.gui.controls.GuiSigilButton;
import mods.battlegear2.client.model.QuiverModel;
import mods.battlegear2.client.utils.BattlegearRenderHelper;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.items.ItemWeapon;
import mods.battlegear2.packet.PickBlockPacket;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderSkeleton;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.opengl.GL11;

public final class BattlegearClientEvents {
    private final BattlegearInGameGUI inGameGUI = new BattlegearInGameGUI();
    private final QuiverModel quiverModel = new QuiverModel();
    private final ResourceLocation quiverDetails = new ResourceLocation("battlegear2", "textures/armours/quiver/QuiverDetails.png");
    private final ResourceLocation quiverBase = new ResourceLocation("battlegear2", "textures/armours/quiver/QuiverBase.png");
    private static final int MAIN_INV = InventoryPlayer.func_70451_h();
    public static final GuiPlaceableButton[] tabsList = new GuiPlaceableButton[]{new GuiBGInventoryButton(0), new GuiSigilButton(1)};
    public static final BattlegearClientEvents INSTANCE = new BattlegearClientEvents();
    private static final int SKELETON_ARROW = 5;

    private BattlegearClientEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void postRenderBar(RenderItemBarEvent.BattleSlots event) {
        if (!event.isMainHand) {
            event.xOffset += BattlegearConfig.battleBarOffset[0];
            event.yOffset += BattlegearConfig.battleBarOffset[1];
        } else {
            event.xOffset += BattlegearConfig.battleBarOffset[2];
            event.yOffset += BattlegearConfig.battleBarOffset[3];
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void postRenderQuiver(RenderItemBarEvent.QuiverSlots event) {
        event.xOffset += BattlegearConfig.quiverBarOffset[0];
        event.yOffset += BattlegearConfig.quiverBarOffset[1];
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void postRenderShield(RenderItemBarEvent.ShieldBar event) {
        event.xOffset += BattlegearConfig.shieldBarOffset[0];
        event.yOffset += BattlegearConfig.shieldBarOffset[1];
    }

    @SubscribeEvent(receiveCanceled=true)
    public void postRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR && (BattlegearConfig.forceHUD || !event.isCanceled())) {
            this.inGameGUI.renderGameOverlay(event.partialTicks, event.mouseX, event.mouseY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderPlayerLeftItemUsage(RenderLivingEvent.Pre event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)event.entity;
            ItemStack offhand = ((IInventoryPlayerBattle)entityPlayer.field_71071_by).battlegear2$getCurrentOffhandWeapon();
            if (offhand != null && event.renderer instanceof RenderPlayer) {
                RenderPlayer renderer = (RenderPlayer)event.renderer;
                renderer.field_77109_a.field_78119_l = 1;
                renderer.field_77111_i.field_78119_l = 1;
                renderer.field_77108_b.field_78119_l = 1;
                if (entityPlayer.func_71052_bv() > 0 && entityPlayer.func_71011_bu() == offhand) {
                    EnumAction enumaction = offhand.func_77975_n();
                    if (enumaction == EnumAction.block) {
                        renderer.field_77109_a.field_78119_l = 3;
                        renderer.field_77111_i.field_78119_l = 3;
                        renderer.field_77108_b.field_78119_l = 3;
                    } else if (enumaction == EnumAction.bow) {
                        renderer.field_77109_a.field_78118_o = true;
                        renderer.field_77111_i.field_78118_o = true;
                        renderer.field_77108_b.field_78118_o = true;
                    }
                    ItemStack mainhand = entityPlayer.field_71071_by.func_70448_g();
                    renderer.field_77109_a.field_78120_m = mainhand != null ? 1 : 0;
                    renderer.field_77111_i.field_78120_m = renderer.field_77109_a.field_78120_m;
                    renderer.field_77108_b.field_78120_m = renderer.field_77109_a.field_78120_m;
                } else if (((IBattlePlayer)entityPlayer).battlegear2$isBlockingWithShield()) {
                    renderer.field_77109_a.field_78119_l = 3;
                    renderer.field_77111_i.field_78119_l = 3;
                    renderer.field_77108_b.field_78119_l = 3;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void resetPlayerLeftHand(RenderPlayerEvent.Post event) {
        event.renderer.field_77109_a.field_78119_l = 0;
        event.renderer.field_77111_i.field_78119_l = 0;
        event.renderer.field_77108_b.field_78119_l = 0;
    }

    @SubscribeEvent
    public void render3rdPersonBattlemode(RenderPlayerEvent.Specials.Post event) {
        ModelBiped biped = (ModelBiped)event.renderer.field_77045_g;
        BattlegearRenderHelper.renderItemIn3rdPerson(event.entityPlayer, biped, event.partialRenderTick);
        ItemStack quiverStack = QuiverArrowRegistry.getArrowContainer(event.entityPlayer);
        if (quiverStack != null && ((IArrowContainer2)quiverStack.func_77973_b()).renderDefaultQuiverModel(quiverStack)) {
            IArrowContainer2 quiver = (IArrowContainer2)quiverStack.func_77973_b();
            int maxStack = quiver.getSlotCount(quiverStack);
            int arrowCount = 0;
            for (int i = 0; i < maxStack; ++i) {
                arrowCount += quiver.getStackInSlot(quiverStack, i) == null ? 0 : 1;
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.quiverDetails);
            GL11.glPushMatrix();
            if (event.entityPlayer.func_71124_b(3) != null) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0625f);
            }
            biped.field_78115_e.func_78794_c(0.0625f);
            GL11.glScalef((float)1.05f, (float)1.05f, (float)1.05f);
            this.quiverModel.render(arrowCount, 0.0625f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.quiverBase);
            if (quiverStack.func_77973_b() instanceof IDyable) {
                int col = ((IDyable)((Object)quiver)).getColor(quiverStack);
                float red = (float)(col >> 16 & 0xFF) / 255.0f;
                float green = (float)(col >> 8 & 0xFF) / 255.0f;
                float blue = (float)(col & 0xFF) / 255.0f;
                GL11.glColor3f((float)red, (float)green, (float)blue);
            }
            this.quiverModel.render(0, 0.0625f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void renderLiving(RenderLivingEvent.Post event) {
        if (BattlegearConfig.enableSkeletonQuiver && event.entity instanceof EntitySkeleton && event.renderer instanceof RenderSkeleton) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.quiverDetails);
            double d0 = ((EntitySkeleton)event.entity).field_70142_S + (((EntitySkeleton)event.entity).field_70165_t - ((EntitySkeleton)event.entity).field_70142_S) * (double)BattlegearClientTickHandeler.getPartialTick();
            double d1 = ((EntitySkeleton)event.entity).field_70137_T + (((EntitySkeleton)event.entity).field_70163_u - ((EntitySkeleton)event.entity).field_70137_T) * (double)BattlegearClientTickHandeler.getPartialTick();
            double d2 = ((EntitySkeleton)event.entity).field_70136_U + (((EntitySkeleton)event.entity).field_70161_v - ((EntitySkeleton)event.entity).field_70136_U) * (double)BattlegearClientTickHandeler.getPartialTick();
            GL11.glTranslatef((float)((float)(d0 - RenderManager.field_78725_b)), (float)((float)(d1 - RenderManager.field_78726_c)), (float)((float)(d2 - RenderManager.field_78723_d)));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            float f2 = this.interpolateRotation(event.entity.field_70760_ar, event.entity.field_70761_aq, 0.0f);
            GL11.glRotatef((float)(180.0f - f2), (float)0.0f, (float)1.0f, (float)0.0f);
            if (event.entity.field_70725_aQ > 0) {
                float f3 = ((float)event.entity.field_70725_aQ + BattlegearClientTickHandeler.getPartialTick() - 1.0f) / 20.0f * 1.6f;
                if ((f3 = MathHelper.func_76129_c((float)f3)) > 1.0f) {
                    f3 = 1.0f;
                }
                GL11.glRotatef((float)(-f3 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
            GL11.glRotatef((float)event.entity.field_70125_A, (float)0.0f, (float)1.0f, (float)0.0f);
            if (event.entity.func_71124_b(3) != null) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0625f);
            }
            ((ModelBiped)event.renderer.field_77045_g).field_78115_e.func_78794_c(0.0625f);
            GL11.glScalef((float)1.05f, (float)1.05f, (float)1.05f);
            this.quiverModel.render(5, 0.0625f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.quiverBase);
            GL11.glColor3f((float)0.1f, (float)0.1f, (float)0.1f);
            this.quiverModel.render(0, 0.0625f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void onBowFOV(FOVUpdateEvent event) {
        ItemStack stack = event.entity.func_71011_bu();
        if (EnchantmentHelper.getEnchantmentLevel(BaseEnchantment.bowCharge, stack) > 0) {
            int i = event.entity.func_71057_bx();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.newfov /= 1.0f - f1 * 0.15f;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void replacePickBlock(MouseEvent event) {
        if (event.buttonstate) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (mc.field_71439_g != null && event.button - 100 == mc.field_71474_y.field_74322_I.func_151463_i()) {
                event.setCanceled(true);
                if (!((IBattlePlayer)mc.field_71439_g).battlegear2$isBattlemode()) {
                    boolean isCreative = mc.field_71439_g.field_71075_bZ.field_75098_d;
                    ItemStack stack = BattlegearClientEvents.getItemFromPointedAt(mc.field_71476_x, (EntityPlayer)mc.field_71439_g);
                    if (stack != null) {
                        int k = -1;
                        for (int slot = 0; slot < MAIN_INV; ++slot) {
                            ItemStack temp = mc.field_71439_g.field_71071_by.func_70301_a(slot);
                            if (temp == null || !stack.func_77969_a(temp) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)temp)) continue;
                            k = slot;
                            break;
                        }
                        if (isCreative && k == -1 && ((k = mc.field_71439_g.field_71071_by.func_70447_i()) < 0 || k >= MAIN_INV)) {
                            k = mc.field_71439_g.field_71071_by.field_70461_c;
                        }
                        if (k >= 0 && k < MAIN_INV) {
                            mc.field_71439_g.field_71071_by.field_70461_c = k;
                            Battlegear.packetHandler.sendPacketToServer(new PickBlockPacket(stack, k).generatePacket());
                        }
                    }
                }
            }
        }
    }

    private static ItemStack getItemFromPointedAt(MovingObjectPosition target, EntityPlayer player) {
        if (target != null) {
            if (target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                int x = target.field_72311_b;
                int y = target.field_72312_c;
                int z = target.field_72309_d;
                World world = player.func_130014_f_();
                Block block = world.func_147439_a(x, y, z);
                if (block.isAir((IBlockAccess)world, x, y, z)) {
                    return null;
                }
                return block.getPickBlock(target, world, x, y, z, player);
            }
            if (target.field_72313_a != MovingObjectPosition.MovingObjectType.ENTITY || target.field_72308_g == null || !player.field_71075_bZ.field_75098_d) {
                return null;
            }
            return target.field_72308_g.getPickedResult(target);
        }
        return null;
    }

    public float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    @SubscribeEvent
    public void preStitch(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            int i;
            ClientProxy.backgroundIcon = new IIcon[]{event.map.func_94245_a("battlegear2:slots/mainhand"), event.map.func_94245_a("battlegear2:slots/offhand")};
            ClientProxy.bowIcons = new IIcon[3];
            for (i = 0; i < ClientProxy.bowIcons.length; ++i) {
                ClientProxy.bowIcons[i] = event.map.func_94245_a("battlegear2:bow_pulling_" + i);
            }
            ClientProxy.bowIronIcons = new IIcon[3];
            for (i = 0; i < ClientProxy.bowIronIcons.length; ++i) {
                ClientProxy.bowIronIcons[i] = event.map.func_94245_a("battlegear2:bow.iron_pulling_" + i);
            }
            ClientProxy.bowDiamondIcons = new IIcon[3];
            for (i = 0; i < ClientProxy.bowDiamondIcons.length; ++i) {
                ClientProxy.bowDiamondIcons[i] = event.map.func_94245_a("battlegear2:bow.diamond_pulling_" + i);
            }
        }
    }

    @SubscribeEvent
    public void onUpdateFOV(FOVUpdateEvent event) {
        float fov = event.fov;
        if (event.entity.func_71039_bw() && (event.entity.func_71011_bu().func_77973_b() == BattlegearConfig.mobBowIron || event.entity.func_71011_bu().func_77973_b() == BattlegearConfig.modBowDiamond)) {
            int duration = event.entity.func_71057_bx();
            float multiplier = (float)duration / 10.0f;
            multiplier = multiplier > 1.0f ? 1.0f : (multiplier *= multiplier);
            fov *= 1.0f - multiplier * 0.3f;
        }
        event.newfov = fov;
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.itemStack.func_77973_b() instanceof IPenetrateWeapon || event.itemStack.func_77973_b() instanceof IHitTimeModifier || event.itemStack.func_77973_b() instanceof IExtendedReachWeapon) {
            for (String txt : event.toolTip) {
                if (!txt.startsWith(EnumChatFormatting.BLUE.toString()) || !txt.contains(StatCollector.func_74838_a((String)("attribute.name." + ItemWeapon.armourPenetrate.func_111108_a()))) && !txt.contains(StatCollector.func_74838_a((String)("attribute.name." + ItemWeapon.attackSpeed.func_111108_a()))) && !txt.contains(StatCollector.func_74838_a((String)("attribute.name." + ItemWeapon.extendedReach.func_111108_a())))) continue;
                event.toolTip.set(event.toolTip.indexOf(txt), EnumChatFormatting.DARK_GREEN + EnumChatFormatting.func_110646_a((String)txt));
            }
        }
        if (event.itemStack.func_77973_b() instanceof IBackStabbable) {
            event.toolTip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"attribute.name.weapon.backstab"));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void postInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (Battlegear.battlegearEnabled && event.gui instanceof InventoryEffectRenderer && (!ClientProxy.tconstructEnabled || FMLClientHandler.instance().getClientPlayerEntity().field_71075_bZ.field_75098_d)) {
            BattlegearClientEvents.onOpenGui(event.buttonList, BattlegearClientEvents.guessGuiLeft((InventoryEffectRenderer)event.gui) - 30, BattlegearClientEvents.guessGuiTop(event.gui));
        }
    }

    public static int guessGuiLeft(InventoryEffectRenderer guiContainer) {
        int offset;
        int n = offset = Loader.isModLoaded((String)"NotEnoughItems") || FMLClientHandler.instance().getClientPlayerEntity().func_70651_bq().isEmpty() ? 0 : 60;
        if (guiContainer instanceof GuiContainerCreative) {
            return offset + (guiContainer.field_146294_l - 195) / 2;
        }
        return offset + (guiContainer.field_146294_l - 176) / 2;
    }

    public static int guessGuiTop(GuiScreen gui) {
        if (gui instanceof GuiContainerCreative) {
            return (gui.field_146295_m - 136) / 2;
        }
        return (gui.field_146295_m - 166) / 2;
    }

    public static void onOpenGui(List<GuiButton> buttons, int guiLeft, int guiTop) {
        if (BattlegearConfig.enableGuiButtons) {
            int count = 0;
            for (GuiPlaceableButton tab : tabsList) {
                GuiPlaceableButton button = tab.copy();
                button.place(count, guiLeft, guiTop);
                button.field_146127_k = buttons.size() + 2;
                ++count;
                buttons.add(button);
            }
        }
    }
}

