/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.heraldry;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class PatternStore {
    public static final IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
    public static final PatternStore DEFAULT = new PatternStore(8, 4);
    private final int IMAGES_X;
    private final int IMAGES_Y;
    public List<int[][][][]> patterns = new ArrayList<int[][][][]>();

    public PatternStore(int xSections, int ySections) {
        this.IMAGES_X = xSections;
        this.IMAGES_Y = ySections;
    }

    public int buildPatternAndStore(ResourceLocation image) {
        try {
            if (this.patterns.add(this.buildPatternFrom(image))) {
                return this.patterns.size() - 1;
            }
            return -1;
        }
        catch (IOException io) {
            return -1;
        }
    }

    public int[][][][] buildPatternFrom(ResourceLocation image) throws IOException {
        return this.buildPatternFrom(rm.func_110536_a(image).func_110527_b());
    }

    public int[][][][] buildPatternFrom(InputStream resourceStream) throws IOException {
        return this.buildPatternFrom(ImageIO.read(resourceStream));
    }

    public int[][][][] buildPatternFrom(BufferedImage image) {
        int[][][][] rgbs = new int[this.IMAGES_X * this.IMAGES_Y][3][image.getWidth() / this.IMAGES_X][image.getHeight() / this.IMAGES_Y];
        int imageRes = image.getWidth() / this.IMAGES_X;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int blue;
                int green;
                int imageNo = x / imageRes + this.IMAGES_X * (y / imageRes);
                int rgb = image.getRGB(x, y);
                int red = rgb >> 16 & 0xFF;
                int total = red + (green = rgb >> 8 & 0xFF) + (blue = rgb & 0xFF);
                if (total == 0) {
                    rgbs[imageNo][0][x % imageRes][y % imageRes] = 255;
                    rgbs[imageNo][1][x % imageRes][y % imageRes] = 0;
                    rgbs[imageNo][2][x % imageRes][y % imageRes] = 0;
                    continue;
                }
                rgbs[imageNo][0][x % imageRes][y % imageRes] = 255 * red / total;
                rgbs[imageNo][1][x % imageRes][y % imageRes] = 255 * green / total;
                rgbs[imageNo][2][x % imageRes][y % imageRes] = 255 * blue / total;
            }
        }
        return rgbs;
    }

    public int getBlendedSmallPixel(int index, byte imageNo, int x, int y, int col1, int col2, int col3) {
        return PatternStore.getBlendedSmallPixel(this.patterns.get(index)[imageNo][0][x][y], this.patterns.get(index)[imageNo][1][x][y], this.patterns.get(index)[imageNo][2][x][y], col1, col2, col3);
    }

    public static int getBlendedSmallPixel(int[][][][] rgbs, byte imageNo, int x, int y, int col1, int col2, int col3) {
        return PatternStore.getBlendedSmallPixel(rgbs[imageNo][0][x][y], rgbs[imageNo][1][x][y], rgbs[imageNo][2][x][y], col1, col2, col3);
    }

    public static int getBlendedSmallPixel(int a, int b, int c, int col1, int col2, int col3) {
        int red = (col1 >> 16 & 0xFF) * a / 255 + (col2 >> 16 & 0xFF) * b / 255 + (col3 >> 16 & 0xFF) * c / 255;
        int green = (col1 >> 8 & 0xFF) * a / 255 + (col2 >> 8 & 0xFF) * b / 255 + (col3 >> 8 & 0xFF) * c / 255;
        int blue = (col1 & 0xFF) * a / 255 + (col2 & 0xFF) * b / 255 + (col3 & 0xFF) * c / 255;
        return 0xFF000000 | red << 16 & 0xFF0000 | green << 8 & 0xFF00 | blue & 0xFF;
    }
}

