/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util;

import com.github.bartimaeusnek.bartworks.util.Pair;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeFinderForParallel {
    public static int handleParallelRecipe(GT_Recipe aRecipe, FluidStack[] aFluidInputs, ItemStack[] aItemStacks, int aMaxParallel) {
        int tOldSize;
        int tItem;
        int tFluid;
        if (aFluidInputs == null) {
            aFluidInputs = new FluidStack[]{};
        }
        if (aItemStacks == null) {
            aItemStacks = new ItemStack[]{};
        }
        HashMap<Integer, Integer> tCompressedFluidInput = RecipeFinderForParallel.compressFluid(aFluidInputs);
        HashMap<Integer, Integer> tCompressedItemInput = RecipeFinderForParallel.compressItem(aItemStacks);
        HashMap<Integer, Integer> tCompressedFluidRecipe = RecipeFinderForParallel.compressFluid(aRecipe.mFluidInputs);
        HashMap<Integer, Integer> tCompressedItemRecipe = RecipeFinderForParallel.compressItem(aRecipe.mInputs);
        int tCurrentPara = aMaxParallel;
        Object object = tCompressedFluidRecipe.keySet().iterator();
        while (object.hasNext()) {
            tFluid = object.next();
            if (!tCompressedFluidInput.containsKey(tFluid) || tCompressedFluidRecipe.get(tFluid) == 0) continue;
            tCurrentPara = Math.min(tCurrentPara, tCompressedFluidInput.get(tFluid) / tCompressedFluidRecipe.get(tFluid));
        }
        object = tCompressedItemRecipe.keySet().iterator();
        while (object.hasNext()) {
            tItem = object.next();
            if (tItem >> 16 == Short.MAX_VALUE) {
                int tCountWildcard = 0;
                for (int tInputItem : tCompressedItemInput.keySet()) {
                    if ((tInputItem & 0xFFFF) != (tItem & 0xFFFF)) continue;
                    tCountWildcard += tCompressedItemInput.get(tInputItem).intValue();
                }
                tCurrentPara = Math.min(tCurrentPara, tCountWildcard / tCompressedItemRecipe.get(tItem));
                continue;
            }
            if (!tCompressedItemInput.containsKey(tItem) || tCompressedItemRecipe.get(tItem) == 0) continue;
            tCurrentPara = Math.min(tCurrentPara, tCompressedItemInput.get(tItem) / tCompressedItemRecipe.get(tItem));
        }
        object = tCompressedFluidRecipe.keySet().iterator();
        while (object.hasNext()) {
            tFluid = object.next();
            tOldSize = tCompressedFluidRecipe.get(tFluid);
            tCompressedFluidRecipe.put(tFluid, tOldSize * tCurrentPara);
        }
        object = tCompressedItemRecipe.keySet().iterator();
        while (object.hasNext()) {
            tItem = object.next();
            tOldSize = tCompressedItemRecipe.get(tItem);
            tCompressedItemRecipe.put(tItem, tOldSize * tCurrentPara);
        }
        for (FluidStack fluidStack : aFluidInputs) {
            if (fluidStack == null || !tCompressedFluidRecipe.containsKey(fluidStack.getFluidID())) continue;
            if (fluidStack.amount >= tCompressedFluidRecipe.get(fluidStack.getFluidID())) {
                fluidStack.amount -= tCompressedFluidRecipe.get(fluidStack.getFluidID()).intValue();
                tCompressedFluidRecipe.remove(fluidStack.getFluidID());
                continue;
            }
            tCompressedFluidRecipe.put(fluidStack.getFluidID(), tCompressedFluidRecipe.get(fluidStack.getFluidID()) - fluidStack.amount);
            fluidStack.amount = 0;
        }
        for (FluidStack fluidStack : aItemStacks) {
            if (fluidStack == null || !tCompressedItemRecipe.containsKey(GT_Utility.stackToInt((ItemStack)fluidStack))) continue;
            if (fluidStack.field_77994_a >= tCompressedItemRecipe.get(GT_Utility.stackToInt((ItemStack)fluidStack))) {
                fluidStack.field_77994_a -= tCompressedItemRecipe.get(GT_Utility.stackToInt((ItemStack)fluidStack)).intValue();
                tCompressedItemRecipe.remove(GT_Utility.stackToInt((ItemStack)fluidStack));
                continue;
            }
            tCompressedItemRecipe.put(GT_Utility.stackToInt((ItemStack)fluidStack), tCompressedItemRecipe.get(GT_Utility.stackToInt((ItemStack)fluidStack)) - fluidStack.field_77994_a);
            fluidStack.field_77994_a = 0;
        }
        object = tCompressedItemRecipe.keySet().iterator();
        block7: while (object.hasNext()) {
            tItem = (Integer)object.next();
            if (tItem >> 16 != Short.MAX_VALUE) continue;
            for (ItemStack tInputItem : aItemStacks) {
                int InputID = GT_Utility.stackToInt((ItemStack)tInputItem);
                if ((InputID & 0xFFFF) != (tItem & 0xFFFF)) continue;
                if (tInputItem.field_77994_a >= tCompressedItemRecipe.get(tItem)) {
                    tInputItem.field_77994_a -= tCompressedItemRecipe.get(tItem).intValue();
                    tCompressedItemRecipe.remove(tItem);
                    continue block7;
                }
                tCompressedItemRecipe.put(tItem, tCompressedItemRecipe.get(tItem) - tInputItem.field_77994_a);
                tInputItem.field_77994_a = 0;
            }
        }
        return tCurrentPara;
    }

    public static Pair<ArrayList<FluidStack>, ArrayList<ItemStack>> getMultiOutput(GT_Recipe aRecipe, int aPall) {
        ArrayList<FluidStack> tFluidList = new ArrayList<FluidStack>();
        ArrayList<ItemStack> tItemList = new ArrayList<ItemStack>();
        if (aRecipe == null) {
            return new Pair<ArrayList<FluidStack>, ArrayList<ItemStack>>(tFluidList, tItemList);
        }
        if (aRecipe.mFluidOutputs != null && aRecipe.mFluidOutputs.length > 0) {
            for (FluidStack fluidStack : aRecipe.mFluidOutputs) {
                if (fluidStack == null || fluidStack.amount <= 0) continue;
                tFluidList.add(new FluidStack(fluidStack.getFluid(), fluidStack.amount * aPall));
            }
        }
        if (aRecipe.mOutputs != null && aRecipe.mOutputs.length > 0) {
            for (FluidStack fluidStack : aRecipe.mOutputs) {
                int tAmount;
                if (fluidStack == null || fluidStack.field_77994_a <= 0) continue;
                for (tAmount = fluidStack.field_77994_a * aPall; tAmount > fluidStack.func_77976_d(); tAmount -= fluidStack.func_77976_d()) {
                    tItemList.add(GT_Utility.copyAmount((long)fluidStack.func_77976_d(), (Object[])new Object[]{fluidStack}));
                }
                tItemList.add(GT_Utility.copyAmount((long)tAmount, (Object[])new Object[]{fluidStack}));
            }
        }
        return new Pair<ArrayList<FluidStack>, ArrayList<ItemStack>>(tFluidList, tItemList);
    }

    public static HashMap<Integer, Integer> compressItem(ItemStack[] aItemStacks) {
        HashMap<Integer, Integer> tCompressed = new HashMap<Integer, Integer>();
        for (ItemStack tItem : aItemStacks) {
            if (tItem == null) continue;
            int tItemID = GT_Utility.stackToInt((ItemStack)tItem);
            int tItemSize = tItem.field_77994_a;
            tCompressed.merge(tItemID, tItemSize, Integer::sum);
        }
        return tCompressed;
    }

    public static HashMap<Integer, Integer> compressFluid(FluidStack[] aFluidStack) {
        HashMap<Integer, Integer> tCompressed = new HashMap<Integer, Integer>();
        for (FluidStack tFluid : aFluidStack) {
            if (tFluid == null) continue;
            int tFluidID = tFluid.getFluidID();
            int tFluidSize = tFluid.amount;
            tCompressed.merge(tFluidID, tFluidSize, Integer::sum);
        }
        return tCompressed;
    }
}

