/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material;

import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.oredict.OreDictHandler;
import com.github.bartimaeusnek.bartworks.util.BW_ColorUtil;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MurmurHash3;
import com.github.bartimaeusnek.bartworks.util.NonNullWrappedHashMap;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.crossmod.thaumcraft.util.ThaumcraftHandler;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.enums.TextureSet;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.util.GT_OreDictUnificator;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class Werkstoff
implements IColorModulationContainer,
ISubTagContainer {
    public static final LinkedHashSet<Werkstoff> werkstoffHashSet = new LinkedHashSet();
    public static final LinkedHashMap<Short, Werkstoff> werkstoffHashMap = new LinkedHashMap();
    public static final LinkedHashMap<String, Werkstoff> werkstoffNameHashMap = new LinkedHashMap();
    private static final HashSet<Short> idHashSet = new HashSet();
    private static final Stats DEFAULT_NULL_STATS = new Stats();
    private static final GenerationFeatures DEFAULT_NULL_GENERATION_FEATURES = new GenerationFeatures().disable();
    public static Werkstoff default_null_Werkstoff;
    private final HashSet<String> ADDITIONAL_OREDICT = new HashSet();
    private final List<ISubTagContainer> mOreByProducts = new ArrayList<ISubTagContainer>();
    private final LinkedHashSet<Pair<ISubTagContainer, Integer>> CONTENTS = new LinkedHashSet();
    private final HashSet<SubTag> SUBTAGS = new HashSet();
    private byte[] rgb = new byte[3];
    private final String defaultName;
    private String toolTip;
    private Stats stats;
    private final Types type;
    private final GenerationFeatures generationFeatures;
    private final short mID;
    private final TextureSet texSet;
    private Materials bridgeMaterial;

    public Materials getBridgeMaterial() {
        return this.bridgeMaterial;
    }

    public void setBridgeMaterial(Materials bridgeMaterial) {
        this.bridgeMaterial = bridgeMaterial;
    }

    public static void init() {
        default_null_Werkstoff = new Werkstoff(new short[3], "_NULL", "Default null Werkstoff", DEFAULT_NULL_STATS, Types.UNDEFINED, DEFAULT_NULL_GENERATION_FEATURES, -1, TextureSet.SET_NONE, new Pair[0]);
    }

    public Werkstoff(Materials materials, GenerationFeatures generationFeatures, Types type, int mID) {
        this(materials.mRGBa, materials.mDefaultLocalName, materials.getToolTip(), type == null ? (materials.mElement != null ? Types.ELEMENT : Types.UNDEFINED) : type, generationFeatures, mID, materials.mIconSet, (List<ISubTagContainer>)materials.mOreByProducts, new Pair<Materials, Integer>(materials, 1));
        if (mID <= 31766 || mID > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.stats.mass = materials.getMass();
        this.stats.protons = materials.getProtons();
        this.stats.meltingPoint = materials.mMeltingPoint;
        this.stats.neutrons = materials.getNeutrons();
        this.stats.speedOverride = materials.mToolSpeed;
        this.stats.durOverride = materials.mDurability;
        this.stats.qualityOverride = materials.mToolQuality;
        this.stats.setGas(materials.mHasGas);
        this.stats.setRadioactive(materials.isRadioactive());
        this.stats.setBlastFurnace(materials.mBlastFurnaceRequired);
        this.stats.setMeltingVoltage(120);
        if (type == Types.COMPOUND) {
            this.stats.setElektrolysis(true);
            this.generationFeatures.addChemicalRecipes();
        } else if (type == Types.MIXTURE) {
            this.stats.setCentrifuge(true);
            this.generationFeatures.addMixerRecipes();
        }
    }

    public Werkstoff(short[] rgba, String defaultName, Types type, int meltingpoint, GenerationFeatures generationFeatures, int mID, TextureSet texSet, Pair<ISubTagContainer, Integer> ... contents) {
        this(rgba, defaultName, Types.getDefaultStatForType(type).setMeltingPoint(meltingpoint), type, generationFeatures, mID, texSet, contents);
    }

    public Werkstoff(short[] rgba, String defaultName, Types type, GenerationFeatures generationFeatures, int mID, TextureSet texSet, Pair<ISubTagContainer, Integer> ... contents) {
        this(rgba, defaultName, Types.getDefaultStatForType(type), type, generationFeatures, mID, texSet, contents);
    }

    public Werkstoff(short[] rgba, String defaultName, Types type, int meltingpoint, GenerationFeatures generationFeatures, int mID, TextureSet texSet, List<ISubTagContainer> oreByProduct, Pair<ISubTagContainer, Integer> ... contents) {
        this(rgba, defaultName, Types.getDefaultStatForType(type).setMeltingPoint(meltingpoint), type, generationFeatures, mID, texSet, oreByProduct, contents);
    }

    public Werkstoff(short[] rgba, String defaultName, Types type, GenerationFeatures generationFeatures, int mID, TextureSet texSet, List<ISubTagContainer> oreByProduct, Pair<ISubTagContainer, Integer> ... contents) {
        this(rgba, defaultName, Types.getDefaultStatForType(type), type, generationFeatures, mID, texSet, oreByProduct, contents);
    }

    public Werkstoff(short[] rgba, String toolTip, String defaultName, Types type, GenerationFeatures generationFeatures, int mID, TextureSet texSet, List<ISubTagContainer> oreByProduct, Pair<ISubTagContainer, Integer> ... contents) {
        this(rgba, toolTip, defaultName, Types.getDefaultStatForType(type), type, generationFeatures, mID, texSet, oreByProduct, contents);
    }

    public Werkstoff(short[] rgba, String defaultName, Stats stats, Types type, GenerationFeatures generationFeatures, int mID, TextureSet texSet, List<ISubTagContainer> oreByProduct, Pair<ISubTagContainer, Integer> ... contents) {
        this(rgba, defaultName, "", stats, type, generationFeatures, mID, texSet, contents);
        this.mOreByProducts.clear();
        this.mOreByProducts.addAll(oreByProduct);
    }

    public Werkstoff(short[] rgba, String defaultName, Stats stats, Types type, GenerationFeatures generationFeatures, int mID, TextureSet texSet, Pair<ISubTagContainer, Integer> ... contents) {
        this(rgba, defaultName, "", stats, type, generationFeatures, mID, texSet, contents);
    }

    public Werkstoff(short[] rgba, String defaultName, String toolTip, Stats stats, Types type, GenerationFeatures generationFeatures, int mID, TextureSet texSet, List<ISubTagContainer> oreByProduct, Pair<ISubTagContainer, Integer> ... contents) {
        this(rgba, defaultName, toolTip, stats, type, generationFeatures, mID, texSet, contents);
        this.mOreByProducts.clear();
        this.mOreByProducts.addAll(oreByProduct);
    }

    public Werkstoff(short[] rgba, String defaultName, String toolTip, Stats stats, Types type, GenerationFeatures generationFeatures, int mID, TextureSet texSet, Pair<ISubTagContainer, Integer> ... contents) {
        Optional firstContent;
        if (idHashSet.contains((short)mID)) {
            throw new UnsupportedOperationException("ID (" + mID + ") is already in use!");
        }
        idHashSet.add((short)mID);
        if (type == null) {
            type = Types.UNDEFINED;
        }
        this.defaultName = defaultName;
        this.stats = stats;
        this.type = type;
        this.mID = (short)mID;
        this.generationFeatures = generationFeatures;
        this.setRgb(BW_ColorUtil.correctCorlorArray(rgba));
        this.CONTENTS.addAll(Arrays.asList(contents));
        this.toolTip = "";
        if (toolTip.isEmpty()) {
            for (Pair<ISubTagContainer, Integer> p : contents) {
                if (contents.length > 1) {
                    if (p.getKey() instanceof Materials) {
                        this.toolTip = ((Materials)p.getKey()).mMaterialList.size() > 1 && p.getValue() > 1 ? this.toolTip + "(" + ((Materials)p.getKey()).mChemicalFormula + ")" + BW_Util.subscriptNumber(p.getValue()) : this.toolTip + ((Materials)p.getKey()).mChemicalFormula + (p.getValue() > 1 ? BW_Util.subscriptNumber(p.getValue()) : "");
                    }
                    if (!(p.getKey() instanceof Werkstoff)) continue;
                    if (((Werkstoff)p.getKey()).CONTENTS.size() > 1 && p.getValue() > 1) {
                        this.toolTip = this.toolTip + "(" + ((Werkstoff)p.getKey()).toolTip + ")" + BW_Util.subscriptNumber(p.getValue());
                        continue;
                    }
                    this.toolTip = this.toolTip + ((Werkstoff)p.getKey()).toolTip + (p.getValue() > 1 ? BW_Util.subscriptNumber(p.getValue()) : "");
                    continue;
                }
                if (p.getKey() instanceof Materials) {
                    this.toolTip = this.toolTip + ((Materials)p.getKey()).mChemicalFormula + (p.getValue() > 1 ? BW_Util.subscriptNumber(p.getValue()) : "");
                    continue;
                }
                if (!(p.getKey() instanceof Werkstoff)) continue;
                this.toolTip = this.toolTip + ((Werkstoff)p.getKey()).toolTip + (p.getValue() > 1 ? BW_Util.subscriptNumber(p.getValue()) : "");
            }
        } else {
            this.toolTip = toolTip;
        }
        if (this.stats.protons == 0L) {
            long tmpprotons = 0L;
            for (Pair<ISubTagContainer, Integer> p : contents) {
                if (p.getKey() instanceof Materials) {
                    tmpprotons += ((Materials)p.getKey()).getProtons() * (long)p.getValue().intValue();
                    continue;
                }
                if (!(p.getKey() instanceof Werkstoff)) continue;
                tmpprotons += ((Werkstoff)p.getKey()).getStats().protons * (long)p.getValue().intValue();
            }
            this.stats = stats.setProtons(tmpprotons);
        }
        if (this.stats.mass == 0L) {
            long tmpmass = 0L;
            int count = 0;
            for (Pair<ISubTagContainer, Integer> p : contents) {
                if (p.getKey() instanceof Materials) {
                    tmpmass += ((Materials)p.getKey()).getMass() * (long)p.getValue().intValue();
                    count += p.getValue().intValue();
                    continue;
                }
                if (!(p.getKey() instanceof Werkstoff)) continue;
                tmpmass += ((Werkstoff)p.getKey()).getStats().mass * (long)p.getValue().intValue();
                count += p.getValue().intValue();
            }
            if (count > 0) {
                this.stats = stats.setMass(tmpmass / (long)count);
            }
        }
        if (this.stats.meltingPoint == 0) {
            this.stats.meltingPoint = 1123;
        }
        if (this.stats.meltingVoltage == 0) {
            this.stats.meltingVoltage = 120;
        }
        this.texSet = texSet;
        switch (this.mOreByProducts.size()) {
            case 0: {
                this.mOreByProducts.add(this);
                this.mOreByProducts.add(this);
                this.mOreByProducts.add(this);
                break;
            }
            case 1: {
                this.mOreByProducts.add(this);
                this.mOreByProducts.add(this);
                break;
            }
            case 2: {
                this.mOreByProducts.add(this);
            }
        }
        if (this.CONTENTS.size() == 1 && (firstContent = this.CONTENTS.stream().findFirst()).isPresent()) {
            ISubTagContainer firstContentSubTagContainer = (ISubTagContainer)((Pair)firstContent.get()).getKey();
            if ((Integer)((Pair)firstContent.get()).getValue() == 1 && firstContentSubTagContainer instanceof Materials) {
                this.getGenerationFeatures().setExtension();
            }
        }
        werkstoffHashSet.add(this);
        werkstoffHashMap.put(this.mID, this);
        werkstoffNameHashMap.put(this.defaultName, this);
    }

    public Werkstoff addAdditionalOreDict(String s) {
        this.ADDITIONAL_OREDICT.add(s);
        return this;
    }

    public HashSet<String> getADDITIONAL_OREDICT() {
        return this.ADDITIONAL_OREDICT;
    }

    public void setTCAspects(Pair<Object, Integer> ... pAspectsArr) {
        Stats.access$802(this.stats, pAspectsArr);
    }

    public Pair<Object, Integer>[] getTCAspects(int ratio) {
        if (this.stats.mTC_Aspects == null) {
            HashSet tc_aspectStacks = new HashSet();
            HashSet<Pair<Object, Integer>> set = new HashSet<Pair<Object, Integer>>();
            for (Pair pair : this.getContents().getValue()) {
                if (pair.getKey() instanceof Materials) {
                    tc_aspectStacks.addAll(((Materials)pair.getKey()).mAspects);
                }
                if (!(pair.getKey() instanceof Werkstoff)) continue;
                set.addAll(Arrays.asList(((Werkstoff)pair.getKey()).getTCAspects()));
            }
            tc_aspectStacks.forEach(tc_aspectStack -> set.add(new Pair<Object, Integer>(tc_aspectStack.mAspect.mAspect, (int)tc_aspectStack.mAmount)));
            Stats.access$802(this.stats, set.toArray(new Pair[0]));
        }
        Pair[] ret = (Pair[])this.stats.mTC_Aspects.clone();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ret[i].copyWithNewValue((Integer)ret[i].getValue() * ratio);
        }
        return ret;
    }

    public List<TC_Aspects.TC_AspectStack> getGTWrappedTCAspects() {
        ArrayList<TC_Aspects.TC_AspectStack> ret = new ArrayList<TC_Aspects.TC_AspectStack>();
        Arrays.stream(this.getTCAspects()).forEach(objectIntegerPair -> {
            try {
                new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)((String)ThaumcraftHandler.AspectAdder.getName.invoke(objectIntegerPair.getKey(), new Object[0])).toUpperCase(Locale.US)), (long)((Integer)objectIntegerPair.getValue()).intValue()).addToAspectList(ret);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        });
        return ret;
    }

    public Pair<Object, Integer>[] getTCAspects() {
        return this.getTCAspects(1);
    }

    public Types getType() {
        return this.type;
    }

    public boolean containsStuff(ISubTagContainer stuff) {
        for (Pair pair : this.CONTENTS) {
            if (!((ISubTagContainer)pair.getKey()).equals(stuff)) continue;
            return true;
        }
        return false;
    }

    public Pair<Integer, LinkedHashSet<Pair<ISubTagContainer, Integer>>> getContents() {
        int ret = 0;
        switch (this.type) {
            case COMPOUND: 
            case MIXTURE: 
            case BIOLOGICAL: {
                for (int i = 0; i < this.CONTENTS.toArray().length; ++i) {
                    ret += ((Integer)((Pair)this.CONTENTS.toArray()[i]).getValue()).intValue();
                }
                break;
            }
            default: {
                ret = 1;
            }
        }
        return new Pair<Integer, LinkedHashSet<Pair<ISubTagContainer, Integer>>>(ret, this.CONTENTS);
    }

    public int getNoOfByProducts() {
        return this.mOreByProducts.size();
    }

    public ISubTagContainer getOreByProductRaw(int aNumber) {
        if (this.mOreByProducts.size() == 0) {
            return null;
        }
        if (aNumber < 0) {
            aNumber = this.mOreByProducts.size() + aNumber;
        }
        while (aNumber >= this.mOreByProducts.size()) {
            --aNumber;
        }
        ISubTagContainer o = this.mOreByProducts.get(aNumber);
        if (o == null || o.equals(default_null_Werkstoff) || o.equals(Materials._NULL)) {
            return this;
        }
        return o;
    }

    public ItemStack getOreByProduct(int aNumber, OrePrefixes prefixes) {
        if (this.mOreByProducts.size() == 0) {
            return null;
        }
        if (aNumber < 0) {
            aNumber = this.mOreByProducts.size() + aNumber;
        }
        while (aNumber >= this.mOreByProducts.size()) {
            --aNumber;
        }
        ISubTagContainer o = this.mOreByProducts.get(aNumber);
        if (o == null || o.equals(default_null_Werkstoff) || o.equals(Materials._NULL)) {
            return this.get(prefixes);
        }
        if (o instanceof Werkstoff) {
            return WerkstoffLoader.getCorrespondingItemStack(prefixes, (Werkstoff)o);
        }
        if (o instanceof Materials) {
            return GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)o, (long)1L);
        }
        return null;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getVarName() {
        return this.defaultName.replaceAll(" ", "");
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public Stats getStats() {
        return this.stats;
    }

    public short getmID() {
        return this.mID;
    }

    public short getMixCircuit() {
        return this.getGenerationFeatures().mixCircuit;
    }

    public GenerationFeatures getGenerationFeatures() {
        return this.generationFeatures;
    }

    public TextureSet getTexSet() {
        return this.texSet;
    }

    public void setRgb(short[] rgb) {
        this.rgb = new byte[]{(byte)(rgb[0] - 128), (byte)(rgb[1] - 128), (byte)(rgb[2] - 128)};
    }

    public short[] getRGBA() {
        return new short[]{(short)(this.rgb[0] + 128), (short)(this.rgb[1] + 128), (short)(this.rgb[2] + 128), 0};
    }

    public boolean contains(SubTag subTag) {
        if (!(subTag.equals(WerkstoffLoader.NOBLE_GAS) || subTag.equals(WerkstoffLoader.ANAEROBE_GAS) || subTag.equals(WerkstoffLoader.NO_BLAST))) {
            for (Pair pair : this.CONTENTS) {
                if (!((ISubTagContainer)pair.getKey()).contains(subTag)) continue;
                return true;
            }
        }
        return this.SUBTAGS.contains(subTag);
    }

    public ISubTagContainer add(SubTag ... subTags) {
        this.SUBTAGS.addAll(Arrays.asList(subTags));
        return this;
    }

    public boolean remove(SubTag subTag) {
        return this.SUBTAGS.remove(subTag);
    }

    public void getAndAddToCollection(OrePrefixes prefixes, int amount, Collection<ItemStack> stacks) {
        stacks.add(this.get(prefixes, amount));
    }

    public ItemStack get(OrePrefixes prefixes) {
        return WerkstoffLoader.getCorrespondingItemStack(prefixes, this);
    }

    public FluidStack getFluidOrGas(int fluidAmount) {
        return new FluidStack((Fluid)Objects.requireNonNull(WerkstoffLoader.fluids.get((Object)this)), fluidAmount);
    }

    public FluidStack getMolten(int fluidAmount) {
        return new FluidStack((Fluid)Objects.requireNonNull(WerkstoffLoader.molten.get((Object)this)), fluidAmount);
    }

    public ItemStack get(OrePrefixes prefixes, int amount) {
        return WerkstoffLoader.getCorrespondingItemStack(prefixes, this, amount);
    }

    public byte getToolQuality() {
        return this.stats.getQualityOverride() > 0 ? this.stats.getQualityOverride() : (byte)(15.0f * ((float)this.getStats().getProtons() / 188.0f + (float)this.getStats().getMeltingPoint() / 10801.0f) / (float)this.getContents().getKey().intValue());
    }

    public float getToolSpeed() {
        return this.stats.getSpeedOverride() > 0.0f ? this.stats.getSpeedOverride() : Math.max(1.0f, 2.0f * ((float)(-this.getStats().getMass()) + 0.1f * (float)this.getStats().getMeltingPoint() + (float)this.getStats().getProtons()) * 0.1f / (float)this.getContents().getKey().intValue() * 0.1f * (float)this.getToolQuality());
    }

    public int getDurability() {
        return this.stats.getDurOverride() > 0 ? this.stats.getDurOverride() : (int)(this.stats.durMod * (0.01f * (float)this.getStats().getMeltingPoint() * (float)this.getStats().getMass() / (float)this.getContents().getKey().intValue()));
    }

    public boolean hasItemType(OrePrefixes prefixes) {
        int unpacked = GenerationFeatures.getPrefixDataRaw(prefixes);
        return (this.getGenerationFeatures().toGenerate & (long)unpacked) != 0L && (this.getGenerationFeatures().blacklist & unpacked) == 0;
    }

    public boolean hasGenerationFeature(OrePrefixes prefixes) {
        int unpacked = GenerationFeatures.getPrefixDataRaw(prefixes);
        return (this.getGenerationFeatures().toGenerate & (long)unpacked) != 0L;
    }

    public boolean doesOreDictedItemExists(OrePrefixes prefixes) {
        return OreDictHandler.getItemStack(this.getDefaultName(), prefixes, 1) != null;
    }

    public static class Stats {
        public static final int NULL_KELVIN = 0;
        int boilingPoint;
        private byte qualityOverride;
        private int durOverride;
        private float speedOverride;
        private int meltingPoint;
        private int meltingVoltage;
        private long protons;
        private long neutrons;
        private long electrons;
        private long mass;
        float durMod = 1.0f;
        private Pair<Object, Integer>[] mTC_Aspects;
        byte quality = (byte)-128;
        byte enchantmentlvl = (byte)3;

        public int getBoilingPoint() {
            return this.boilingPoint;
        }

        public Stats setBoilingPoint(int boilingPoint) {
            this.boilingPoint = boilingPoint;
            return this;
        }

        public long getMass() {
            return this.mass;
        }

        public long getProtons() {
            return this.protons;
        }

        public int getMeltingPoint() {
            return this.meltingPoint;
        }

        public Stats setMeltingPoint(int meltingPoint) {
            this.meltingPoint = meltingPoint;
            return this;
        }

        public int getDurOverride() {
            return this.durOverride;
        }

        public Stats setDurOverride(int durOverride) {
            this.durOverride = durOverride;
            return this;
        }

        public float getSpeedOverride() {
            return this.speedOverride;
        }

        public Stats setSpeedOverride(float speedOverride) {
            this.speedOverride = speedOverride;
            return this;
        }

        public byte getQualityOverride() {
            return this.qualityOverride;
        }

        public Stats setQualityOverride(byte qualityOverride) {
            this.qualityOverride = qualityOverride;
            return this;
        }

        public float getDurMod() {
            return this.durMod;
        }

        public void setDurMod(float durMod) {
            this.durMod = durMod;
        }

        public Stats setmTC_AspectsArray(Pair<Object, Integer>[] mTC_Aspects) {
            this.mTC_Aspects = mTC_Aspects;
            return this;
        }

        @SafeVarargs
        public final Stats setmTC_AspectsVarArg(Pair<Object, Integer> ... mTC_Aspects) {
            this.mTC_Aspects = mTC_Aspects;
            return this;
        }

        Pair<Object, Integer>[] getmTC_Aspects() {
            return this.mTC_Aspects;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Stats)) {
                return false;
            }
            Stats that = (Stats)o;
            if (this.boilingPoint != that.boilingPoint) {
                return false;
            }
            if (this.meltingPoint != that.meltingPoint) {
                return false;
            }
            if (this.mass != that.mass) {
                return false;
            }
            if (this.protons != that.protons) {
                return false;
            }
            if (this.neutrons != that.neutrons) {
                return false;
            }
            if (this.electrons != that.electrons) {
                return false;
            }
            return this.quality == that.quality;
        }

        public int hashCode() {
            return MurmurHash3.murmurhash3_x86_32(ByteBuffer.allocate(49).put(this.quality).putInt(this.boilingPoint).putInt(this.meltingPoint).putLong(this.protons).putLong(this.neutrons).putLong(this.electrons).putLong(this.mass).array(), 0, 49, 31);
        }

        public Stats setMass(long mass) {
            this.mass = mass;
            return this;
        }

        public Stats setProtons(long protons) {
            this.protons = protons;
            return this;
        }

        public boolean isSublimation() {
            return (this.quality & 1) != 0;
        }

        public Stats setSublimation(boolean sublimation) {
            this.quality = sublimation ? (byte)(this.quality | 1) : (byte)(this.quality & 0x7E);
            return this;
        }

        public boolean isToxic() {
            return (this.quality & 2) != 0;
        }

        public Stats setToxic(boolean toxic) {
            this.quality = toxic ? (byte)(this.quality | 2) : (byte)(this.quality & 0x7D);
            return this;
        }

        public byte getEnchantmentlvl() {
            return this.enchantmentlvl;
        }

        public Stats setEnchantmentlvl(byte enchantmentlvl) {
            this.enchantmentlvl = enchantmentlvl;
            return this;
        }

        public boolean isRadioactive() {
            return (this.quality & 4) != 0;
        }

        public Stats setRadioactive(boolean radioactive) {
            this.quality = radioactive ? (byte)(this.quality | 4) : (byte)(this.quality & 0x7B);
            return this;
        }

        public boolean isBlastFurnace() {
            return (this.quality & 8) != 0;
        }

        public Stats setBlastFurnace(boolean blastFurnace) {
            this.quality = blastFurnace ? (byte)(this.quality | 8) : (byte)(this.quality & 0x77);
            return this;
        }

        public Stats setMeltingVoltage(int meltingVoltage) {
            this.meltingVoltage = meltingVoltage;
            return this;
        }

        public int getMeltingVoltage() {
            return this.meltingVoltage;
        }

        public boolean isElektrolysis() {
            return (this.quality & 0x10) != 0;
        }

        public Stats setElektrolysis(boolean elektrolysis) {
            this.quality = elektrolysis ? (byte)(this.quality | 0x10) : (byte)(this.quality & 0x6F);
            return this;
        }

        public boolean isCentrifuge() {
            return (this.quality & 0x20) != 0;
        }

        public Stats setCentrifuge(boolean centrifuge) {
            this.quality = centrifuge ? (byte)(this.quality | 0x20) : (byte)(this.quality & 0x5F);
            return this;
        }

        public boolean isGas() {
            return (this.quality & 0x40) != 0;
        }

        public Stats setGas(boolean gas) {
            this.quality = gas ? (byte)(this.quality | 0x40) : (byte)(this.quality & 0x3F);
            return this;
        }

        static /* synthetic */ Pair[] access$802(Stats x0, Pair[] x1) {
            x0.mTC_Aspects = x1;
            return x1;
        }
    }

    public static class GenerationFeatures {
        public static final GenerationFeatures DISABLED = new GenerationFeatures().disable();
        long toGenerate = 9L;
        private boolean isExtension;
        private static final NonNullWrappedHashMap<OrePrefixes, Integer> prefixLogic = new NonNullWrappedHashMap(Integer.valueOf(0));
        public byte blacklist;
        public boolean enforceUnification;
        public byte extraRecipes;
        public short mixCircuit = (short)-1;

        public static void initPrefixLogic() {
            Arrays.stream(OrePrefixes.values()).forEach(e -> prefixLogic.put((OrePrefixes)e, 0));
            prefixLogic.put(OrePrefixes.dust, 1);
            prefixLogic.put(OrePrefixes.dustTiny, 1);
            prefixLogic.put(OrePrefixes.dustSmall, 1);
            prefixLogic.put(OrePrefixes.ingot, 2);
            prefixLogic.put(OrePrefixes.ingotHot, 2);
            prefixLogic.put(OrePrefixes.nugget, 2);
            prefixLogic.put(OrePrefixes.gem, 4);
            prefixLogic.put(OrePrefixes.gemFlawed, 4);
            prefixLogic.put(OrePrefixes.gemExquisite, 4);
            prefixLogic.put(OrePrefixes.gemChipped, 4);
            prefixLogic.put(OrePrefixes.gemFlawless, 4);
            prefixLogic.put(OrePrefixes.lens, 4);
            prefixLogic.put(OrePrefixes.block, 6);
            prefixLogic.put(OrePrefixes.ore, 8);
            prefixLogic.put(OrePrefixes.dustImpure, 8);
            prefixLogic.put(OrePrefixes.dustPure, 8);
            prefixLogic.put(OrePrefixes.crushed, 8);
            prefixLogic.put(OrePrefixes.crushedPurified, 8);
            prefixLogic.put(OrePrefixes.crushedCentrifuged, 8);
            prefixLogic.put(OrePrefixes.cell, 16);
            prefixLogic.put(OrePrefixes.capsule, 16);
            prefixLogic.put(WerkstoffLoader.capsuleMolten, 64);
            prefixLogic.put(WerkstoffLoader.cellMolten, 64);
            prefixLogic.put(OrePrefixes.plate, 128);
            prefixLogic.put(OrePrefixes.stick, 128);
            prefixLogic.put(OrePrefixes.stickLong, 128);
            prefixLogic.put(OrePrefixes.toolHeadHammer, 128);
            prefixLogic.put(OrePrefixes.toolHeadWrench, 128);
            prefixLogic.put(OrePrefixes.toolHeadSaw, 128);
            prefixLogic.put(OrePrefixes.turbineBlade, 128);
            prefixLogic.put(OrePrefixes.screw, 256);
            prefixLogic.put(OrePrefixes.gearGt, 256);
            prefixLogic.put(OrePrefixes.gearGtSmall, 256);
            prefixLogic.put(OrePrefixes.bolt, 256);
            prefixLogic.put(OrePrefixes.ring, 256);
            prefixLogic.put(OrePrefixes.spring, 256);
            prefixLogic.put(OrePrefixes.springSmall, 256);
            prefixLogic.put(OrePrefixes.rotor, 256);
            prefixLogic.put(OrePrefixes.wireFine, 256);
            prefixLogic.put(OrePrefixes.plateDouble, 512);
            prefixLogic.put(OrePrefixes.plateTriple, 512);
            prefixLogic.put(OrePrefixes.plateQuadruple, 512);
            prefixLogic.put(OrePrefixes.plateQuintuple, 512);
            prefixLogic.put(OrePrefixes.plateDense, 512);
            prefixLogic.put(OrePrefixes.ingotDouble, 512);
            prefixLogic.put(OrePrefixes.ingotTriple, 512);
            prefixLogic.put(OrePrefixes.ingotQuadruple, 512);
            prefixLogic.put(OrePrefixes.ingotQuintuple, 512);
            prefixLogic.put(WerkstoffLoader.blockCasing, 896);
            prefixLogic.put(WerkstoffLoader.blockCasingAdvanced, 896);
        }

        public void setExtension() {
            this.isExtension = !this.isExtension;
        }

        public static int getPrefixDataRaw(OrePrefixes prefixes) {
            if (prefixes == null) {
                throw new IllegalArgumentException("OrePrefixes is NULL!");
            }
            return prefixLogic.get(prefixes);
        }

        public boolean isExtension() {
            return this.isExtension;
        }

        public GenerationFeatures setBlacklist(OrePrefixes p) {
            this.blacklist = (byte)(this.blacklist | GenerationFeatures.getPrefixDataRaw(p));
            return this;
        }

        @Deprecated
        public boolean hasDusts() {
            return (this.toGenerate & 1L) != 0L;
        }

        @Deprecated
        public boolean hasGems() {
            return (this.toGenerate & 4L) != 0L;
        }

        @Deprecated
        public boolean hasOres() {
            return (this.toGenerate & 8L) != 0L;
        }

        public GenerationFeatures enforceUnification() {
            this.enforceUnification = true;
            return this;
        }

        @Deprecated
        public GenerationFeatures removeGems() {
            if (this.hasGems()) {
                this.toGenerate ^= 4L;
            }
            return this;
        }

        @Deprecated
        public GenerationFeatures removeDusts() {
            if (this.hasDusts()) {
                this.toGenerate ^= 1L;
            }
            return this;
        }

        @Deprecated
        public GenerationFeatures removeOres() {
            if (this.hasOres()) {
                this.toGenerate ^= 8L;
            }
            return this;
        }

        public GenerationFeatures addChemicalRecipes() {
            this.extraRecipes = (byte)(this.extraRecipes | 1);
            return this;
        }

        public boolean hasChemicalRecipes() {
            return (this.extraRecipes & 1) != 0;
        }

        public GenerationFeatures addMixerRecipes() {
            this.extraRecipes = (byte)(this.extraRecipes | 0xA);
            return this;
        }

        public GenerationFeatures addMixerRecipes(short aCircuit) {
            this.extraRecipes = (byte)(this.extraRecipes | 0xA);
            if (aCircuit >= 1 && aCircuit <= 24) {
                this.mixCircuit = aCircuit;
            }
            return this;
        }

        public boolean hasMixerRecipes() {
            return (this.extraRecipes & 0xA) != 0;
        }

        public GenerationFeatures addSifterRecipes() {
            this.extraRecipes = (byte)(this.extraRecipes | 0x64);
            return this;
        }

        public boolean hasSifterRecipes() {
            return (this.extraRecipes & 0x64) != 0;
        }

        public GenerationFeatures onlyDust() {
            this.toGenerate = 1L;
            return this;
        }

        public GenerationFeatures addMetalItems() {
            this.toGenerate = this.addSimpleMetalWorkingItems().toGenerate | 2L;
            return this;
        }

        public GenerationFeatures disable() {
            this.toGenerate = 0L;
            return this;
        }

        public GenerationFeatures addCells() {
            this.toGenerate |= 0x10L;
            return this;
        }

        @Deprecated
        public boolean hasCells() {
            return (this.toGenerate & 0x10L) != 0L;
        }

        @Deprecated
        public boolean hasMolten() {
            return (this.toGenerate & 0x40L) != 0L;
        }

        public GenerationFeatures addMolten() {
            this.toGenerate |= 0x40L;
            return this;
        }

        public GenerationFeatures addGems() {
            this.toGenerate = this.addSimpleMetalWorkingItems().toGenerate | 4L;
            return this;
        }

        public GenerationFeatures addSimpleMetalWorkingItems() {
            this.toGenerate |= 0x80L;
            return this;
        }

        public GenerationFeatures addCasings() {
            this.toGenerate |= 0x382L;
            return this;
        }

        @Deprecated
        public boolean hasSimpleMetalWorkingItems() {
            return (this.toGenerate & 0x80L) != 0L;
        }

        public GenerationFeatures addCraftingMetalWorkingItems() {
            this.toGenerate |= 0x100L;
            return this;
        }

        public GenerationFeatures addMultipleIngotMetalWorkingItems() {
            this.toGenerate |= 0x200L;
            return this;
        }

        public GenerationFeatures addPrefix(OrePrefixes prefixes) {
            this.toGenerate |= (long)GenerationFeatures.getPrefixDataRaw(prefixes);
            return this;
        }

        public GenerationFeatures removePrefix(OrePrefixes prefixes) {
            this.toGenerate ^= (long)GenerationFeatures.getPrefixDataRaw(prefixes);
            return this;
        }
    }

    public static enum Types {
        MATERIAL,
        COMPOUND,
        MIXTURE,
        BIOLOGICAL,
        ELEMENT,
        ISOTOPE,
        UNDEFINED;


        public static Stats getDefaultStatForType(Types T) {
            switch (T) {
                case COMPOUND: 
                case BIOLOGICAL: {
                    return new Stats().setElektrolysis(true);
                }
                case MIXTURE: {
                    return new Stats().setCentrifuge(true);
                }
            }
            return new Stats();
        }
    }
}

