/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.GT_Enhancement;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Items;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.CachedReflectionUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.items.GT_Generic_Block;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.reflect.FieldUtils;

public class PlatinumSludgeOverHaul {
    private static final Materials[] BLACKLIST = new Materials[]{Materials.HSSS, Materials.EnderiumBase, Materials.Osmiridium, Materials.get((String)"Uraniumtriplatinid"), Materials.get((String)"Tetranaquadahdiindiumhexaplatiumosminid"), Materials.get((String)"Longasssuperconductornameforuvwire")};
    private static final OrePrefixes[] OPBLACKLIST = new OrePrefixes[]{OrePrefixes.crushedCentrifuged, OrePrefixes.crushed, OrePrefixes.crushedPurified, OrePrefixes.dustPure, OrePrefixes.dustImpure, OrePrefixes.dustRefined, OrePrefixes.dust, OrePrefixes.dustTiny, OrePrefixes.dustSmall};

    private PlatinumSludgeOverHaul() {
    }

    private static void runHelperrecipes() {
        GT_Values.RA.addMixerRecipe(Materials.SulfuricAcid.getCells(3), Materials.Water.getCells(1), GT_Utility.getIntegratedCircuit((int)1), null, null, null, Materials.DilutedSulfuricAcid.getCells(4), 30, 30);
        GT_Values.RA.addMixerRecipe(Materials.Water.getCells(1), GT_Utility.getIntegratedCircuit((int)1), null, null, Materials.SulfuricAcid.getFluid(3000L), Materials.DilutedSulfuricAcid.getFluid(4000L), Materials.Empty.getCells(1), 30, 30);
        GT_Values.RA.addMixerRecipe(Materials.SulfuricAcid.getCells(3), GT_Utility.getIntegratedCircuit((int)1), null, null, Materials.Water.getFluid(1000L), Materials.DilutedSulfuricAcid.getFluid(4000L), Materials.Empty.getCells(3), 30, 30);
        GT_Values.RA.addChemicalRecipe(Materials.CarbonMonoxide.getCells(1), Materials.SodiumHydroxide.getDust(1), null, null, WerkstoffLoader.Sodiumformate.get(OrePrefixes.cell), null, 15);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.Sodiumformate.get(OrePrefixes.cell, 2), GT_Utility.getIntegratedCircuit((int)1), Materials.SulfuricAcid.getFluid(1000L), null, WerkstoffLoader.FormicAcid.get(OrePrefixes.cell, 2), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 1), 15);
        GT_Values.RA.addChemicalRecipe(Materials.SulfuricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)1), WerkstoffLoader.Sodiumformate.getFluidOrGas(2000), WerkstoffLoader.FormicAcid.getFluidOrGas(2000), Materials.Empty.getCells(1), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 1), 15);
        GT_Values.RA.addMixerRecipe(Materials.DilutedSulfuricAcid.getCells(1), Materials.NitricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)1), null, null, null, WerkstoffLoader.AquaRegia.get(OrePrefixes.cell, 2), 30, 30);
        GT_Values.RA.addMixerRecipe(Materials.DilutedSulfuricAcid.getCells(1), Materials.NitricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)2), null, null, WerkstoffLoader.AquaRegia.getFluidOrGas(2000), Materials.Empty.getCells(2), 30, 30);
        GT_Values.RA.addMixerRecipe(Materials.NitricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)3), null, null, Materials.DilutedSulfuricAcid.getFluid(1000L), WerkstoffLoader.AquaRegia.getFluidOrGas(2000), Materials.Empty.getCells(1), 30, 30);
        GT_Values.RA.addMixerRecipe(Materials.DilutedSulfuricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)4), null, null, Materials.NitricAcid.getFluid(1000L), WerkstoffLoader.AquaRegia.getFluidOrGas(2000), Materials.Empty.getCells(1), 30, 30);
        GT_Values.RA.addChemicalRecipe(Materials.Ammonia.getCells(1), GT_Utility.getIntegratedCircuit((int)1), Materials.HydrochloricAcid.getFluid(1000L), null, WerkstoffLoader.AmmoniumChloride.get(OrePrefixes.cell, 1), null, 15);
        GT_Values.RA.addChemicalRecipe(Materials.HydrochloricAcid.getCells(1), GT_Utility.getIntegratedCircuit((int)1), Materials.Ammonia.getGas(1000L), WerkstoffLoader.AmmoniumChloride.getFluidOrGas(1000), Materials.Empty.getCells(1), null, 15);
        for (Werkstoff w : Werkstoff.werkstoffHashSet) {
            if (!w.containsStuff((ISubTagContainer)Materials.Sulfur) || !w.containsStuff((ISubTagContainer)Materials.Copper) && !w.containsStuff((ISubTagContainer)Materials.Nickel)) continue;
            GT_Values.RA.addChemicalRecipe(w.get(OrePrefixes.crushedPurified), GT_Utility.getIntegratedCircuit((int)1), WerkstoffLoader.AquaRegia.getFluidOrGas(150), WerkstoffLoader.PTConcentrate.getFluidOrGas(150), null, 250);
            GT_Values.RA.addChemicalRecipe(w.get(OrePrefixes.crushedPurified, 9), GT_Utility.getIntegratedCircuit((int)9), WerkstoffLoader.AquaRegia.getFluidOrGas(1350), WerkstoffLoader.PTConcentrate.getFluidOrGas(1350), null, 2250);
            GT_Values.RA.addChemicalRecipe(w.get(OrePrefixes.crushedPurified, 9), WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 9), WerkstoffLoader.AquaRegia.getFluidOrGas(10350), WerkstoffLoader.PTConcentrate.getFluidOrGas(10350), WerkstoffLoader.PTResidue.get(OrePrefixes.dust), 2250);
        }
        for (Materials m : Materials.values()) {
            if (!PlatinumSludgeOverHaul.materialsContains(m, (ISubTagContainer)Materials.Sulfur) || !PlatinumSludgeOverHaul.materialsContains(m, (ISubTagContainer)Materials.Copper) && !PlatinumSludgeOverHaul.materialsContains(m, (ISubTagContainer)Materials.Nickel)) continue;
            GT_Values.RA.addChemicalRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)m, (long)1L), GT_Utility.getIntegratedCircuit((int)1), WerkstoffLoader.AquaRegia.getFluidOrGas(150), WerkstoffLoader.PTConcentrate.getFluidOrGas(150), null, 250);
            GT_Values.RA.addChemicalRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)m, (long)9L), GT_Utility.getIntegratedCircuit((int)9), WerkstoffLoader.AquaRegia.getFluidOrGas(1350), WerkstoffLoader.PTConcentrate.getFluidOrGas(1350), null, 2250);
            GT_Values.RA.addChemicalRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)m, (long)9L), WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 9), WerkstoffLoader.AquaRegia.getFluidOrGas(10350), WerkstoffLoader.PTConcentrate.getFluidOrGas(10350), WerkstoffLoader.PTResidue.get(OrePrefixes.dust), 2250);
        }
        GT_Values.RA.addBlastRecipe(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 3), GT_Utility.getIntegratedCircuit((int)1), null, null, Materials.Platinum.getNuggets(2), null, 600, 120, (int)Materials.Platinum.mMeltingPoint);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1), WerkstoffLoader.AquaRegia.getFluidOrGas(1000), WerkstoffLoader.PTConcentrate.getFluidOrGas(1000), WerkstoffLoader.PTResidue.get(OrePrefixes.dustTiny), 250);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 9), GT_Utility.getIntegratedCircuit((int)9), WerkstoffLoader.AquaRegia.getFluidOrGas(9000), WerkstoffLoader.PTConcentrate.getFluidOrGas(9000), WerkstoffLoader.PTResidue.get(OrePrefixes.dust), 2250);
        GT_Values.RA.addCentrifugeRecipe(WerkstoffLoader.PTConcentrate.get(OrePrefixes.cell, 2), null, WerkstoffLoader.AmmoniumChloride.getFluidOrGas(200), WerkstoffLoader.PDAmmonia.getFluidOrGas(200), WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dustTiny, 16), WerkstoffLoader.PTRawPowder.get(OrePrefixes.dustTiny, 2), Materials.NitrogenDioxide.getCells(1), Materials.DilutedSulfuricAcid.getCells(1), null, null, null, 1200, 30);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)1)}, new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(2000), WerkstoffLoader.AmmoniumChloride.getFluidOrGas(200)}, new FluidStack[]{WerkstoffLoader.PDAmmonia.getFluidOrGas(200), Materials.NitrogenDioxide.getGas(1000L), Materials.DilutedSulfuricAcid.getFluid(1000L)}, new ItemStack[]{WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dustTiny, 16), WerkstoffLoader.PTRawPowder.get(OrePrefixes.dustTiny, 2)}, 1200, 30);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)2)}, new FluidStack[]{WerkstoffLoader.PTConcentrate.getFluidOrGas(18000), WerkstoffLoader.AmmoniumChloride.getFluidOrGas(1800)}, new FluidStack[]{WerkstoffLoader.PDAmmonia.getFluidOrGas(1800), Materials.NitrogenDioxide.getGas(9000L), Materials.DilutedSulfuricAcid.getFluid(9000L)}, new ItemStack[]{WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dust, 16), WerkstoffLoader.PTRawPowder.get(OrePrefixes.dust, 2)}, 1400, 240);
        GT_Values.RA.addSifterRecipe(WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dust), new ItemStack[]{WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust)}, new int[]{1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1500}, 600, 30);
        GT_Values.RA.addBlastRecipe(WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1), null, Materials.Chlorine.getGas(87L), WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust), null, 200, 120, 900);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.PTRawPowder.get(OrePrefixes.dust, 2), Materials.Calcium.getDust(1), null, null, Materials.Platinum.getDust(2), WerkstoffLoader.CalciumChloride.get(OrePrefixes.dust), 30);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1), Materials.Ammonia.getGas(1000L), WerkstoffLoader.PDAmmonia.getFluidOrGas(1000), null, 250);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1), WerkstoffLoader.PDAmmonia.getFluidOrGas(1000), null, WerkstoffLoader.PDSalt.get(OrePrefixes.dustTiny, 16), WerkstoffLoader.PDRawPowder.get(OrePrefixes.dustTiny, 2), 250);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust, 9), GT_Utility.getIntegratedCircuit((int)9), WerkstoffLoader.PDAmmonia.getFluidOrGas(9000), null, WerkstoffLoader.PDSalt.get(OrePrefixes.dust, 16), WerkstoffLoader.PDRawPowder.get(OrePrefixes.dust, 2), 2250);
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)2), null, WerkstoffLoader.PDAmmonia.getFluidOrGas(1000), null, WerkstoffLoader.PDSalt.get(OrePrefixes.dust), 250);
        GT_Values.RA.addSifterRecipe(WerkstoffLoader.PDSalt.get(OrePrefixes.dust), new ItemStack[]{WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust)}, new int[]{1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1500}, 600, 30);
        GT_Values.RA.addChemicalRecipeForBasicMachineOnly(WerkstoffLoader.PDRawPowder.get(OrePrefixes.dust, 2), Materials.Empty.getCells(1), WerkstoffLoader.FormicAcid.getFluidOrGas(4000), Materials.Ammonia.getGas(2000L), Materials.Palladium.getDust(2), Materials.Ethylene.getCells(1), 250, 30);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{WerkstoffLoader.PDRawPowder.get(OrePrefixes.dust, 2)}, new FluidStack[]{WerkstoffLoader.FormicAcid.getFluidOrGas(4000)}, new FluidStack[]{Materials.Ammonia.getGas(2000L), Materials.Ethylene.getGas(1000L), Materials.Water.getFluid(1000L)}, new ItemStack[]{Materials.Palladium.getDust(2)}, 250, 30);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 1), Materials.Hydrogen.getCells(2), null, Materials.SulfuricAcid.getFluid(1000L), Materials.Sodium.getDust(2), Materials.Empty.getCells(2), 30);
        GT_Values.RA.addBlastRecipe(WerkstoffLoader.PTResidue.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)11), WerkstoffLoader.PotassiumDisulfate.getMolten(360), WerkstoffLoader.RHSulfate.getFluidOrGas(360), WerkstoffLoader.LeachResidue.get(OrePrefixes.dust), null, 200, 120, 775);
        GT_Values.RA.addBlastRecipe(WerkstoffLoader.LeachResidue.get(OrePrefixes.dust, 10), Materials.Saltpeter.getDust(10), Materials.SaltWater.getFluid(1000L), GT_ModHandler.getSteam((long)1000L), WerkstoffLoader.SodiumRuthenate.get(OrePrefixes.dust, 3), WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust, 6), 200, 120, 775);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.SodiumRuthenate.get(OrePrefixes.dust, 6), Materials.Chlorine.getCells(3), null, WerkstoffLoader.RutheniumTetroxideSollution.getFluidOrGas(9000), Materials.Empty.getCells(3), 300);
        GT_Values.RA.addFluidHeaterRecipe(GT_Utility.getIntegratedCircuit((int)1), WerkstoffLoader.RutheniumTetroxideSollution.getFluidOrGas(800), WerkstoffLoader.HotRutheniumTetroxideSollution.getFluidOrGas(800), 300, 480);
        GT_Values.RA.addCrackingRecipe(17, WerkstoffLoader.RutheniumTetroxideSollution.getFluidOrGas(1000), GT_ModHandler.getSteam((long)1000L), WerkstoffLoader.HotRutheniumTetroxideSollution.getFluidOrGas(2000), 150, 480);
        GT_Values.RA.addDistillationTowerRecipe(WerkstoffLoader.HotRutheniumTetroxideSollution.getFluidOrGas(9000), new FluidStack[]{Materials.Water.getFluid(1800L), WerkstoffLoader.RutheniumTetroxide.getFluidOrGas(7200)}, Materials.Salt.getDust(6), 1500, 480);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.RutheniumTetroxide.get(OrePrefixes.dust, 1), Materials.HydrochloricAcid.getCells(6), null, Materials.Water.getFluid(2000L), WerkstoffLoader.Ruthenium.get(OrePrefixes.dust), Materials.Chlorine.getCells(6), 300);
        GT_Values.RA.addBlastRecipe(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust, 4), GT_Utility.getIntegratedCircuit((int)11), Materials.HydrochloricAcid.getFluid(1000L), WerkstoffLoader.AcidicOsmiumSolution.getFluidOrGas(2000), WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust, 2), null, 200, 120, 775);
        GT_Values.RA.addDistillationTowerRecipe(WerkstoffLoader.AcidicOsmiumSolution.getFluidOrGas(1000), new FluidStack[]{WerkstoffLoader.OsmiumSolution.getFluidOrGas(100), Materials.Water.getFluid(900L)}, null, 150, BW_Util.getMachineVoltageFromTier(5));
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.OsmiumSolution.get(OrePrefixes.cell), Materials.HydrochloricAcid.getCells(6), null, Materials.Water.getFluid(2000L), Materials.Osmium.getDust(1), Materials.Chlorine.getCells(7), 300);
        GT_Values.RA.addBlastRecipe(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1), null, null, WerkstoffLoader.PGSDResidue.get(OrePrefixes.dust), WerkstoffLoader.IridiumDioxide.get(OrePrefixes.dust), 200, 120, 775);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.IridiumDioxide.get(OrePrefixes.dust), Materials.HydrochloricAcid.getCells(1), null, WerkstoffLoader.AcidicIridiumSolution.getFluidOrGas(1000), Materials.Empty.getCells(1), null, 300);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.AcidicIridiumSolution.get(OrePrefixes.cell), WerkstoffLoader.AmmoniumChloride.get(OrePrefixes.cell, 3), null, Materials.Ammonia.getGas(3000L), Materials.Empty.getCells(4), WerkstoffLoader.IridiumChloride.get(OrePrefixes.dust), 300);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.IridiumChloride.get(OrePrefixes.dust), Materials.Calcium.getDust(3), null, WerkstoffLoader.CalciumChloride.getFluidOrGas(3000), WerkstoffLoader.PGSDResidue2.get(OrePrefixes.dust), Materials.Iridium.getDust(1), 300, 1920);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.RHSulfate.get(OrePrefixes.cell, 11), GT_Utility.getIntegratedCircuit((int)1), Materials.Water.getFluid(10000L), Materials.Potassium.getMolten(2000L), WerkstoffLoader.RHSulfateSolution.get(OrePrefixes.cell, 11), WerkstoffLoader.LeachResidue.get(OrePrefixes.dustTiny, 10), 300, 30);
        GT_Values.RA.addChemicalRecipe(Materials.Zinc.getDust(1), null, WerkstoffLoader.RHSulfateSolution.getFluidOrGas(1000), null, WerkstoffLoader.ZincSulfate.get(OrePrefixes.dust, 6), WerkstoffLoader.CrudeRhMetall.get(OrePrefixes.dust), 300);
        GT_Values.RA.addBlastRecipe(WerkstoffLoader.CrudeRhMetall.get(OrePrefixes.dust), Materials.Salt.getDust(1), Materials.Chlorine.getGas(1000L), null, WerkstoffLoader.RHSalt.get(OrePrefixes.dust, 3), null, 300, 120, 600);
        GT_Values.RA.addMixerRecipe(WerkstoffLoader.RHSalt.get(OrePrefixes.dust, 10), null, null, null, Materials.Water.getFluid(2000L), WerkstoffLoader.RHSaltSolution.getFluidOrGas(2000), null, 300, 30);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.SodiumNitrate.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1), WerkstoffLoader.RHSaltSolution.getFluidOrGas(1000), null, WerkstoffLoader.RHNitrate.get(OrePrefixes.dust), Materials.Salt.getDust(1), 300);
        GT_Values.RA.addSifterRecipe(WerkstoffLoader.RHNitrate.get(OrePrefixes.dust), new ItemStack[]{WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust)}, new int[]{1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1500}, 600, 30);
        GT_Values.RA.addMixerRecipe(WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), null, null, null, Materials.Water.getFluid(1000L), WerkstoffLoader.RHFilterCakeSolution.getFluidOrGas(1000), null, 300, 30);
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)2), null, WerkstoffLoader.RHFilterCakeSolution.getFluidOrGas(1000), null, WerkstoffLoader.ReRh.get(OrePrefixes.dust), null, 300);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.ReRh.get(OrePrefixes.dust), Materials.Empty.getCells(1), Materials.HydrochloricAcid.getFluid(1000L), Materials.Chlorine.getGas(1000L), WerkstoffLoader.Rhodium.get(OrePrefixes.dust), Materials.Ammonia.getCells(1), 300);
    }

    private static boolean materialsContains(Materials one, ISubTagContainer other) {
        if (one == null || one.mMaterialList == null || one.mMaterialList.isEmpty()) {
            return false;
        }
        for (MaterialStack stack : one.mMaterialList) {
            if (!stack.mMaterial.equals(other)) continue;
            return true;
        }
        return false;
    }

    public static void replacePureElements() {
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            Map.Entry realEntry = entry;
            if (!GT_Utility.isStackValid(realEntry.getKey()) || !BW_Util.checkStackAndPrefix((ItemStack)realEntry.getKey())) continue;
            ItemData association = GT_OreDictUnificator.getAssociation((ItemStack)((ItemStack)realEntry.getKey()));
            if ((association.mPrefix.equals((Object)OrePrefixes.dust) || association.mPrefix.equals((Object)OrePrefixes.dustTiny)) && association.mMaterial.mMaterial.equals(Materials.Platinum) || !GT_Utility.isStackValid(realEntry.getValue()) || !BW_Util.checkStackAndPrefix((ItemStack)realEntry.getValue())) continue;
            ItemData ass = GT_OreDictUnificator.getAssociation((ItemStack)((ItemStack)realEntry.getValue()));
            if (!ass.mMaterial.mMaterial.equals(Materials.Platinum)) continue;
            if (!PlatinumSludgeOverHaul.isInBlackList((ItemStack)realEntry.getKey())) {
                realEntry.setValue(WerkstoffLoader.PTMetallicPowder.get(ass.mPrefix == OrePrefixes.nugget ? OrePrefixes.dustTiny : OrePrefixes.dust, ((ItemStack)realEntry.getValue()).field_77994_a * 2));
                continue;
            }
            if (!ass.mMaterial.mMaterial.equals(Materials.Palladium) || PlatinumSludgeOverHaul.isInBlackList((ItemStack)realEntry.getKey())) continue;
            realEntry.setValue(WerkstoffLoader.PDMetallicPowder.get(ass.mPrefix == OrePrefixes.nugget ? OrePrefixes.dustTiny : OrePrefixes.dust, ((ItemStack)realEntry.getValue()).field_77994_a * 2));
        }
        CraftingManager.func_77594_a().func_77592_b().forEach(PlatinumSludgeOverHaul::setnewMaterialInRecipe);
        try {
            ((List)FieldUtils.getDeclaredField(GT_ModHandler.class, (String)"sBufferRecipeList", (boolean)true).get(null)).forEach(PlatinumSludgeOverHaul::setnewMaterialInRecipe);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        block3: for (GT_Recipe.GT_Recipe_Map gT_Recipe_Map : GT_Recipe.GT_Recipe_Map.sMappings) {
            if (gT_Recipe_Map == GT_Recipe.GT_Recipe_Map.sFusionRecipes || gT_Recipe_Map == GT_Recipe.GT_Recipe_Map.sUnboxinatorRecipes || gT_Recipe_Map == GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes) continue;
            HashSet<GT_Recipe> toDel = new HashSet<GT_Recipe>();
            block4: for (GT_Recipe recipe : gT_Recipe_Map.mRecipeList) {
                int i;
                if (recipe.mFakeRecipe) continue block3;
                for (i = 0; i < recipe.mFluidOutputs.length; ++i) {
                    if (gT_Recipe_Map.equals(GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes)) continue block3;
                    if (gT_Recipe_Map.equals(GT_Recipe.GT_Recipe_Map.sMultiblockChemicalRecipes) || gT_Recipe_Map.equals(GT_Recipe.GT_Recipe_Map.sChemicalRecipes)) {
                        if (GT_Utility.areFluidsEqual((FluidStack)WerkstoffLoader.Ruthenium.getMolten(1), (FluidStack)recipe.mFluidOutputs[i])) {
                            toDel.add(recipe);
                            continue;
                        }
                        if (GT_Utility.areFluidsEqual((FluidStack)WerkstoffLoader.Rhodium.getMolten(1), (FluidStack)recipe.mFluidOutputs[i])) {
                            toDel.add(recipe);
                            continue;
                        }
                        if (GT_Utility.areFluidsEqual((FluidStack)Materials.Iridium.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) {
                            recipe.mFluidOutputs[i] = WerkstoffLoader.AcidicIridiumSolution.getFluidOrGas(1000);
                            continue;
                        }
                        if (GT_Utility.areFluidsEqual((FluidStack)Materials.Platinum.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) {
                            recipe.mFluidOutputs[i] = WerkstoffLoader.PTConcentrate.getFluidOrGas(1000);
                            continue;
                        }
                        if (!GT_Utility.areFluidsEqual((FluidStack)Materials.Osmium.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) continue;
                        recipe.mFluidOutputs[i] = WerkstoffLoader.AcidicOsmiumSolution.getFluidOrGas(1000);
                        continue;
                    }
                    if (GT_Utility.areFluidsEqual((FluidStack)WerkstoffLoader.Ruthenium.getMolten(1), (FluidStack)recipe.mFluidOutputs[i])) {
                        toDel.add(recipe);
                        continue;
                    }
                    if (GT_Utility.areFluidsEqual((FluidStack)WerkstoffLoader.Rhodium.getMolten(1), (FluidStack)recipe.mFluidOutputs[i])) {
                        toDel.add(recipe);
                        continue;
                    }
                    if (GT_Utility.areFluidsEqual((FluidStack)Materials.Iridium.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) {
                        toDel.add(recipe);
                        continue;
                    }
                    if (GT_Utility.areFluidsEqual((FluidStack)Materials.Platinum.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) {
                        toDel.add(recipe);
                        continue;
                    }
                    if (!GT_Utility.areFluidsEqual((FluidStack)Materials.Osmium.getMolten(1L), (FluidStack)recipe.mFluidOutputs[i])) continue;
                    toDel.add(recipe);
                }
                for (i = 0; i < recipe.mOutputs.length; ++i) {
                    int amount;
                    int j;
                    if (!GT_Utility.isStackValid((Object)recipe.mOutputs[i])) continue;
                    if ((BW_Util.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.dust), recipe.mOutputs[i]) || BW_Util.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.dustImpure), recipe.mOutputs[i]) || BW_Util.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.dustPure), recipe.mOutputs[i])) && !BW_Util.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.ingot), recipe.mInputs[0])) {
                        for (j = 0; j < recipe.mInputs.length; ++j) {
                            if (PlatinumSludgeOverHaul.isInBlackList(recipe.mInputs[j])) continue block4;
                        }
                        amount = recipe.mOutputs[i].field_77994_a * 2;
                        recipe.mOutputs[i] = WerkstoffLoader.LeachResidue.get(OrePrefixes.dust, amount);
                    }
                    if ((BW_Util.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.dust), recipe.mOutputs[i]) || BW_Util.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.dustImpure), recipe.mOutputs[i]) || BW_Util.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.dustPure), recipe.mOutputs[i])) && !BW_Util.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.ingot), recipe.mInputs[0])) {
                        for (j = 0; j < recipe.mInputs.length; ++j) {
                            if (PlatinumSludgeOverHaul.isInBlackList(recipe.mInputs[j])) continue block4;
                        }
                        amount = recipe.mOutputs[i].field_77994_a * 2;
                        recipe.mOutputs[i] = WerkstoffLoader.CrudeRhMetall.get(OrePrefixes.dust, amount);
                    }
                    if (!BW_Util.checkStackAndPrefix(recipe.mOutputs[i])) continue;
                    if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Platinum)) {
                        for (j = 0; j < recipe.mInputs.length; ++j) {
                            if (PlatinumSludgeOverHaul.isInBlackList(recipe.mInputs[j])) continue block4;
                        }
                        if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dust) || GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustImpure) || GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustPure)) {
                            amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust), amount * 2);
                            continue;
                        }
                        if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustSmall)) {
                            amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dustSmall), amount * 2);
                            continue;
                        }
                        if (!GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustTiny)) continue;
                        amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dustTiny), amount * 2);
                        continue;
                    }
                    if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Palladium)) {
                        for (j = 0; j < recipe.mInputs.length; ++j) {
                            if (PlatinumSludgeOverHaul.isInBlackList(recipe.mInputs[j])) continue block4;
                        }
                        if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dust) || GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustImpure) || GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustPure)) {
                            amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), amount * 2);
                            continue;
                        }
                        if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustSmall)) {
                            amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dustSmall), amount * 2);
                            continue;
                        }
                        if (!GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustTiny)) continue;
                        amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dustTiny), amount * 2);
                        continue;
                    }
                    if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Osmium)) {
                        for (j = 0; j < recipe.mInputs.length; ++j) {
                            if (PlatinumSludgeOverHaul.isInBlackList(recipe.mInputs[j])) continue block4;
                        }
                        if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dust) || GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustImpure) || GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustPure)) {
                            amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust), amount);
                            continue;
                        }
                        if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustSmall)) {
                            amount = recipe.mOutputs[i].field_77994_a;
                            recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dustSmall), amount);
                            continue;
                        }
                        if (!GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustTiny)) continue;
                        amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dustTiny), amount);
                        continue;
                    }
                    if (!GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Iridium)) continue;
                    for (j = 0; j < recipe.mInputs.length; ++j) {
                        if (PlatinumSludgeOverHaul.isInBlackList(recipe.mInputs[j])) continue block4;
                    }
                    if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dust) || GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustImpure) || GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustPure)) {
                        amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust), amount);
                        continue;
                    }
                    if (GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustSmall)) {
                        amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dustSmall), amount);
                        continue;
                    }
                    if (!GT_OreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix.equals((Object)OrePrefixes.dustTiny)) continue;
                    amount = recipe.mOutputs[i].field_77994_a;
                    recipe.mOutputs[i] = BW_Util.setStackSize(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dustTiny), amount);
                }
            }
            gT_Recipe_Map.mRecipeList.removeAll(toDel);
        }
        PlatinumSludgeOverHaul.replaceHVCircuitMaterials();
        PlatinumSludgeOverHaul.runHelperrecipes();
    }

    private static void replaceHVCircuitMaterials() {
        GT_Values.RA.addMixerRecipe(Materials.Redstone.getDust(1), Materials.Electrum.getDust(1), GT_Utility.getIntegratedCircuit((int)1), null, null, null, Materials.Nikolite.getDust(8), 1800, 120);
        for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes.mRecipeList) {
            if (recipe.mEUt > 512 || !BW_Util.checkStackAndPrefix(recipe.mOutputs[0])) continue;
            for (int i = 0; i < recipe.mInputs.length; ++i) {
                ItemStack stack = recipe.mInputs[i];
                ItemData ass = GT_OreDictUnificator.getAssociation((ItemStack)stack);
                if (!BW_Util.checkStackAndPrefix(stack) || !ass.mMaterial.mMaterial.equals(Materials.Platinum)) continue;
                recipe.mInputs[i] = GT_OreDictUnificator.get((OrePrefixes)ass.mPrefix, (Object)Materials.BlueAlloy, (long)stack.field_77994_a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setnewMaterialInRecipe(Object obj) {
        Object input;
        Field in;
        Field out;
        ItemStack otpt;
        IRecipe recipe;
        block39: {
            String inputName = "output";
            String inputItemName = "input";
            if (!(obj instanceof ShapedOreRecipe) && !(obj instanceof ShapelessOreRecipe)) {
                if (obj instanceof ShapedRecipes || obj instanceof ShapelessRecipes) {
                    inputName = "recipeOutput";
                    inputItemName = "recipeItems";
                } else if (LoaderReference.miscutils) {
                    try {
                        if (Class.forName("gtPlusPlus.api.objects.minecraft.ShapedRecipe").isAssignableFrom(obj.getClass())) {
                            obj = CachedReflectionUtils.getField(obj.getClass(), "mRecipe").get(obj);
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            recipe = (IRecipe)obj;
            otpt = recipe.func_77571_b();
            out = CachedReflectionUtils.getDeclaredField(recipe.getClass(), inputName);
            if (out == null) {
                out = CachedReflectionUtils.getField(recipe.getClass(), inputName);
            }
            if ((in = CachedReflectionUtils.getDeclaredField(recipe.getClass(), inputItemName)) == null) {
                in = CachedReflectionUtils.getField(recipe.getClass(), inputItemName);
            }
            if (in == null) {
                return;
            }
            try {
                boolean doForceAccess;
                if (!Modifier.isFinal(in.getModifiers())) break block39;
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                boolean bl = doForceAccess = !modifiersField.isAccessible();
                if (doForceAccess) {
                    modifiersField.setAccessible(true);
                }
                try {
                    modifiersField.setInt(in, in.getModifiers() & 0xFFFFFFEF);
                }
                finally {
                    if (doForceAccess) {
                        modifiersField.setAccessible(false);
                    }
                }
            }
            catch (NoSuchFieldException modifiersField) {
            }
            catch (IllegalAccessException modifiersField) {
                // empty catch block
            }
        }
        try {
            input = in.get(obj);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        if (out != null && GT_Utility.areStacksEqual((ItemStack)otpt, (ItemStack)Materials.Platinum.getDust(1), (boolean)true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Platinum)) {
                return;
            }
            try {
                out.set(recipe, WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, otpt.field_77994_a * 2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (out != null && GT_Utility.areStacksEqual((ItemStack)otpt, (ItemStack)Materials.Palladium.getDust(1), (boolean)true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Palladium)) {
                return;
            }
            try {
                out.set(recipe, WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust, otpt.field_77994_a * 2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (out != null && GT_Utility.areStacksEqual((ItemStack)otpt, (ItemStack)Materials.Iridium.getDust(1), (boolean)true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Iridium)) {
                return;
            }
            try {
                out.set(recipe, WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust, otpt.field_77994_a));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (out != null && GT_Utility.areStacksEqual((ItemStack)otpt, (ItemStack)Materials.Osmium.getDust(1), (boolean)true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Osmium)) {
                return;
            }
            try {
                out.set(recipe, WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust, otpt.field_77994_a));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkRecipe(Object input, Materials mat) {
        if (input instanceof List || input instanceof Object[]) {
            void var8_14;
            HashSet<Object> lists = new HashSet<Object>();
            HashSet<Object> stacks = new HashSet<Object>();
            List ip = input instanceof List ? (List)input : new ArrayList();
            Object[] ip2 = input instanceof Object[] ? (Object[])input : new Object[]{};
            for (Object e : ip) {
                if (e instanceof List) {
                    lists.add(e);
                    continue;
                }
                if (!(e instanceof ItemStack)) continue;
                stacks.add(e);
            }
            Object[] objectArray = ip2;
            int n = objectArray.length;
            boolean bl = false;
            while (var8_14 < n) {
                Object o = objectArray[var8_14];
                if (o instanceof List) {
                    lists.add(o);
                } else if (o instanceof ItemStack) {
                    stacks.add(o);
                }
                ++var8_14;
            }
            for (Object e : lists) {
                if (((List)e).isEmpty()) continue;
                stacks.add(((List)e).get(0));
            }
            for (Object e : stacks) {
                if (!(e instanceof ItemStack) || !GT_Utility.areStacksEqual((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crateGtDust, (Object)mat, (long)1L), (ItemStack)((ItemStack)e))) continue;
                return true;
            }
            boolean allSame = false;
            for (Object e : stacks) {
                if (!(e instanceof ItemStack)) {
                    allSame = false;
                    break;
                }
                allSame = BW_Util.checkStackAndPrefix((ItemStack)e) && GT_OreDictUnificator.getAssociation((ItemStack)((ItemStack)e)).mMaterial.mMaterial.equals(mat);
                if (allSame) continue;
                break;
            }
            return allSame;
        }
        return false;
    }

    private static boolean isInBlackList(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (stack.func_77973_b() instanceof BW_MetaGenerated_Items) {
            return true;
        }
        if (GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId.equals("bartworks")) {
            return true;
        }
        if (GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId.equals("bartworkscrossmod")) {
            return true;
        }
        if (GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId.equals("dreamcraft") && !stack.func_77977_a().contains("dust") && !stack.func_77977_a().contains("Dust")) {
            return true;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof GT_Generic_Block && !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof GT_Block_Ores_Abstract)) {
            return true;
        }
        if (Arrays.stream(ItemList.values()).filter(ItemList::hasBeenSet).anyMatch(e -> !BW_Util.checkStackAndPrefix(stack) && GT_Utility.areStacksEqual((ItemStack)e.get(1L, new Object[0]), (ItemStack)stack, (boolean)true))) {
            return true;
        }
        if (stack.func_77973_b() instanceof GT_Generic_Item) {
            if (!BW_Util.checkStackAndPrefix(stack)) {
                return false;
            }
            return !Arrays.asList(OPBLACKLIST).contains(GT_OreDictUnificator.getAssociation((ItemStack)stack).mPrefix) || Arrays.asList(BLACKLIST).contains(GT_OreDictUnificator.getAssociation((ItemStack)stack).mMaterial.mMaterial);
        }
        if (LoaderReference.miscutils) {
            try {
                if (Class.forName("gtPlusPlus.core.item.base.BaseItemComponent").isAssignableFrom(stack.func_77973_b().getClass()) && !stack.func_77977_a().contains("dust") && !stack.func_77977_a().contains("Dust")) {
                    return true;
                }
                if (Class.forName("gtPlusPlus.core.block.base.BlockBaseModular").isAssignableFrom(Block.func_149634_a((Item)stack.func_77973_b()).getClass())) {
                    return true;
                }
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
            }
        }
        if (!BW_Util.checkStackAndPrefix(stack)) {
            return false;
        }
        return Arrays.asList(BLACKLIST).contains(GT_OreDictUnificator.getAssociation((ItemStack)stack).mMaterial.mMaterial);
    }
}

