/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MegaUtils;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DistillationTower;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_MegaDistillTower
extends GT_MetaTileEntity_DistillationTower {
    private static final IStructureDefinition<GT_TileEntity_MegaDistillTower> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("base", StructureUtility.transpose((String[][])new String[][]{{"bbbbbbb~bbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb"}})).addShape("layer", StructureUtility.transpose((String[][])new String[][]{{"lllllllllllllll", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lllllllllllllll"}, {"lllllllllllllll", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "lllllllllllllll"}, {"lllllllllllllll", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "lllllllllllllll"}, {"lllllllllllllll", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "lllllllllllllll"}, {"lllllllllllllll", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "l-------------l", "lllllllllllllll"}})).addElement(Character.valueOf('b'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)49, (int)1), StructureUtility.onElementPass(GT_MetaTileEntity_DistillationTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).addElement(Character.valueOf('l'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_DistillationTower::addLayerOutputHatch, (int)49, (int)2), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)49, (int)1), StructureUtility.onElementPass(GT_MetaTileEntity_DistillationTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).addElement(Character.valueOf('c'), (IStructureElement)new IStructureElement<GT_TileEntity_MegaDistillTower>(){

        public boolean check(GT_TileEntity_MegaDistillTower t, World world, int x, int y, int z) {
            IGregTechTileEntity entity;
            if (world.func_147437_c(x, y, z)) {
                if (t.mTopState < 1) {
                    t.mTopState = 0;
                    return true;
                }
                return false;
            }
            if (t.mTopState == 0) {
                return false;
            }
            t.mTopState = 1;
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof IGregTechTileEntity && t.addLayerOutputHatch(entity = (IGregTechTileEntity)tileEntity, 49)) {
                t.onTopLayerFound(false);
                return true;
            }
            if (world.func_147439_a(x, y, z) == GregTech_API.sBlockCasings4 && world.func_72805_g(x, y, z) == 1) {
                t.onTopLayerFound(true);
                return true;
            }
            return false;
        }

        public boolean spawnHint(GT_TileEntity_MegaDistillTower t, World world, int x, int y, int z, ItemStack trigger) {
            if (trigger.field_77994_a == 1) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)GregTech_API.sBlockCasings4, (int)1);
            }
            return true;
        }

        public boolean placeBlock(GT_TileEntity_MegaDistillTower t, World world, int x, int y, int z, ItemStack trigger) {
            if (trigger.field_77994_a == 1) {
                world.func_147465_d(x, y, z, GregTech_API.sBlockCasings4, 1, 3);
                return true;
            }
            world.func_147468_f(x, y, z);
            return false;
        }
    }).build();
    private int mTopState = -1;

    public GT_TileEntity_MegaDistillTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private GT_TileEntity_MegaDistillTower(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaDistillTower(this.mName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Distillery").addInfo("Controller block for the Distillation Tower").addInfo("Fluids are only put out at the correct height").addInfo("The correct height equals the slot number in the NEI recipe").addSeparator().beginVariableStructureBlock(15, 15, 16, 56, 15, 15, true).addController("Front bottom").addOtherStructurePart("Clean Stainless Steel Machine Casing", "15 x h - 5 (minimum)").addEnergyHatch("Any casing").addMaintenanceHatch("Any casing").addInputHatch("Any bottom layer casing").addOutputBus("Any bottom layer casing").addOutputHatch("2-11x Output Hatches (One per Output Layer except bottom layer)").addStructureInfo("An \"Output Layer\" consists of 5 layers!").addStructureHint("This Mega Multiblock is too big to have its structure hologram displayed fully.").toolTipFinisher(BW_Tooltip_Reference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get());
        return tt;
    }

    public IStructureDefinition<GT_MetaTileEntity_DistillationTower> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputHatchesByLayer.forEach(List::clear);
        this.mHeight = 1;
        this.mTopLayerFound = false;
        this.mTopState = -1;
        if (!this.checkPiece("base", 7, 0, 0)) {
            return false;
        }
        while (this.mHeight < 12 && this.checkPiece("layer", 7, this.mHeight * 5, 0) && !this.mTopLayerFound) {
            if (((List)this.mOutputHatchesByLayer.get(this.mHeight - 1)).isEmpty()) {
                return false;
            }
            this.mTopState = -1;
            ++this.mHeight;
        }
        return this.mCasing >= 75 * this.mHeight + 10 && this.mHeight >= 2 && this.mTopLayerFound && this.mMaintenanceHatches.size() == 1;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
    }

    public boolean checkRecipe(ItemStack aStack) {
        ArrayList tFluidList = this.getStoredFluids();
        block0: for (int i = 0; i < tFluidList.size() - 1; ++i) {
            for (int j = i + 1; j < tFluidList.size(); ++j) {
                if (!GT_Utility.areFluidsEqual((FluidStack)((FluidStack)tFluidList.get(i)), (FluidStack)((FluidStack)tFluidList.get(j)))) continue;
                if (((FluidStack)tFluidList.get((int)i)).amount < ((FluidStack)tFluidList.get((int)j)).amount) {
                    tFluidList.remove(i--);
                    continue block0;
                }
                tFluidList.remove(j--);
            }
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(0, Math.min(GT_Utility.getTier((long)tVoltage), GT_Values.V.length - 1));
        long nominalV = BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[0]);
        if (tFluids.length > 0) {
            for (FluidStack tFluid : tFluids) {
                ArrayList<Object> outputFluids = new ArrayList();
                ArrayList<Object> outputItems = new ArrayList();
                int processed = 0;
                boolean found_Recipe = false;
                GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sDistillationRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], new FluidStack[]{tFluid}, new ItemStack[0]);
                if (tRecipe != null) {
                    int tCurrentPara;
                    found_Recipe = true;
                    long tMaxPara = Math.min((long)ConfigHandler.megaMachinesMax, nominalV / (long)tRecipe.mEUt);
                    processed = tCurrentPara = RecipeFinderForParallel.handleParallelRecipe(tRecipe, new FluidStack[]{tFluid}, null, (int)tMaxPara);
                    Pair<ArrayList<FluidStack>, ArrayList<ItemStack>> Outputs = RecipeFinderForParallel.getMultiOutput(tRecipe, tCurrentPara);
                    outputFluids = Outputs.getKey();
                    outputItems = Outputs.getValue();
                }
                if (!found_Recipe) continue;
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                long actualEUT = (long)tRecipe.mEUt * (long)processed;
                if (actualEUT > Integer.MAX_VALUE) {
                    int divider = 0;
                    while (actualEUT > Integer.MAX_VALUE) {
                        actualEUT /= 2L;
                        divider = (byte)(divider + 1);
                    }
                    BW_Util.calculateOverclockedNessMulti((int)(actualEUT / (long)(divider * 2)), tRecipe.mDuration * (divider * 2), 1, nominalV, (GT_MetaTileEntity_MultiBlockBase)this);
                } else {
                    BW_Util.calculateOverclockedNessMulti((int)actualEUT, tRecipe.mDuration, 1, nominalV, (GT_MetaTileEntity_MultiBlockBase)this);
                }
                if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                    return false;
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputFluids = outputFluids.toArray(new FluidStack[0]);
                this.mOutputItems = !outputItems.isEmpty() ? outputItems.toArray(new ItemStack[0]) : null;
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    public boolean drainEnergyInput(long aEU) {
        return MegaUtils.drainEnergyMegaVanilla((GT_MetaTileEntity_MultiBlockBase)this, aEU);
    }
}

