/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.galacticgreg;

import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.crossmod.galacticgreg.VoidMinerUtility;
import com.google.common.collect.ImmutableList;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_TileEntity_VoidMiner_Base
extends GT_MetaTileEntity_DrillerBase {
    private VoidMinerUtility.DropMap dropMap = null;
    private VoidMinerUtility.DropMap extraDropMap = null;
    private float totalWeight;
    private int multiplier = 1;
    protected final byte TIER_MULTIPLIER;
    private boolean mBlacklist = false;

    @Deprecated
    public static void addBlockToDimensionList(int dimId, Block block, int meta, float weight) {
        VoidMinerUtility.addBlockToDimensionList(dimId, block, meta, weight);
    }

    public GT_TileEntity_VoidMiner_Base(int aID, String aName, String aNameRegional, int tier) {
        super(aID, aName, aNameRegional);
        this.TIER_MULTIPLIER = (byte)Math.max(tier, 1);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mBlacklist", this.mBlacklist);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mBlacklist = aNBT.func_74767_n("mBlacklist");
    }

    public GT_TileEntity_VoidMiner_Base(String aName, int tier) {
        super(aName);
        this.TIER_MULTIPLIER = (byte)tier;
    }

    protected int getMinTier() {
        return this.TIER_MULTIPLIER + 5;
    }

    protected boolean checkHatches() {
        return true;
    }

    protected void setElectricityStats() {
        try {
            this.mEUt = this.isPickingPipes ? 60 : Math.toIntExact(GT_Values.V[this.getMinTier()]);
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
            this.mEUt = 0x7FFFFFF8;
        }
        this.mOutputItems = new ItemStack[0];
        this.mProgresstime = 0;
        this.mMaxProgresstime = 10;
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        this.mEUt = this.mEUt > 0 ? -this.mEUt : this.mEUt;
    }

    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.dropMap == null || this.totalWeight == 0.0f) {
            this.calculateDropMap();
        }
        if (this.totalWeight != 0.0f) {
            this.handleFluidConsumption();
            this.handleOutputs();
            return true;
        }
        this.stopMachine(ShutDownReasonRegistry.NONE);
        return false;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Miner").addInfo("Controller Block for the Void Miner " + GT_Values.VN[this.getMinTier()]).addInfo("Consumes " + GT_Values.V[this.getMinTier()] + "EU/t").addInfo("Can be supplied with 2L/s of Neon(x4), Krypton(x8), Xenon(x16) or Oganesson(x64) for higher outputs.").addInfo("Will output " + 2 * this.TIER_MULTIPLIER + " Ores per Second depending on the Dimension it is build in").addInfo("Put the Ore into the input bus to set the Whitelist/Blacklist").addInfo("Use a screwdriver to toggle Whitelist/Blacklist").addInfo("Blacklist or non Whitelist Ore will be VOIDED").addSeparator().beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch(GT_Values.VN[this.getMinTier()] + "+, Any base casing").addMaintenanceHatch("Any base casing").addInputBus("Mining Pipes or Ores, optional, any base casing").addInputHatch("Optional noble gas, any base casing").addOutputBus("Any base casing").toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS);
        return tt;
    }

    protected List<IHatchElement<? super GT_MetaTileEntity_DrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)GT_HatchElement.InputHatch, (Object)GT_HatchElement.InputBus, (Object)GT_HatchElement.OutputBus, (Object)GT_HatchElement.Maintenance, (Object)GT_HatchElement.Energy);
    }

    private ItemStack nextOre() {
        Map.Entry<GT_Utility.ItemId, Float> entry2;
        float currentWeight = 0.0f;
        block0: while (true) {
            float randomNumber = XSTR.XSTR_INSTANCE.nextFloat() * this.totalWeight;
            for (Map.Entry<GT_Utility.ItemId, Float> entry2 : this.dropMap.getInternalMap().entrySet()) {
                if (!(randomNumber < (currentWeight += entry2.getValue().floatValue()))) continue;
                return entry2.getKey().getItemStack();
            }
            Iterator<Map.Entry<GT_Utility.ItemId, Float>> iterator = this.extraDropMap.getInternalMap().entrySet().iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!(randomNumber < (currentWeight += (entry2 = iterator.next()).getValue().floatValue())));
            break;
        }
        return entry2.getKey().getItemStack();
    }

    private FluidStack getNobleGasInputAndSetMultiplier() {
        for (FluidStack s : this.getStoredFluids()) {
            for (int i = 0; i < VoidMinerUtility.NOBLE_GASSES.length; ++i) {
                FluidStack ng = VoidMinerUtility.NOBLE_GASSES[i];
                if (!ng.isFluidEqual(s)) continue;
                this.multiplier = this.TIER_MULTIPLIER * VoidMinerUtility.NOBEL_GASSES_MULTIPLIER[i];
                return s;
            }
        }
        return null;
    }

    private boolean consumeNobleGas(FluidStack gasToConsume) {
        for (FluidStack s : this.getStoredFluids()) {
            if (!s.isFluidEqual(gasToConsume) || s.amount < 1) continue;
            --s.amount;
            this.updateSlots();
            return true;
        }
        return false;
    }

    private void handleFluidConsumption() {
        FluidStack storedNobleGas = this.getNobleGasInputAndSetMultiplier();
        if (storedNobleGas == null || !this.consumeNobleGas(storedNobleGas)) {
            this.multiplier = this.TIER_MULTIPLIER;
        }
    }

    private void handleExtraDrops(int id) {
        if (VoidMinerUtility.extraDropsDimMap.containsKey(id)) {
            this.extraDropMap = VoidMinerUtility.extraDropsDimMap.get(id);
        }
    }

    private void handleModDimDef(int id) {
        if (VoidMinerUtility.dropMapsByDimId.containsKey(id)) {
            this.dropMap = VoidMinerUtility.dropMapsByDimId.get(id);
        } else {
            String chunkProviderName = ((ChunkProviderServer)this.getBaseMetaTileEntity().getWorld().func_72863_F()).field_73246_d.getClass().getName();
            if (VoidMinerUtility.dropMapsByChunkProviderName.containsKey(chunkProviderName)) {
                this.dropMap = VoidMinerUtility.dropMapsByChunkProviderName.get(chunkProviderName);
            }
        }
    }

    private void calculateDropMap() {
        this.dropMap = new VoidMinerUtility.DropMap();
        this.extraDropMap = new VoidMinerUtility.DropMap();
        int id = this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g;
        this.handleModDimDef(id);
        this.handleExtraDrops(id);
        this.totalWeight = this.dropMap.getTotalWeight() + this.extraDropMap.getTotalWeight();
    }

    private void handleOutputs() {
        List inputOres = this.getStoredInputs().stream().filter(GT_Utility::isOre).collect(Collectors.toList());
        ItemStack output = this.nextOre();
        output.field_77994_a = this.multiplier;
        if (inputOres.size() == 0 || this.mBlacklist && inputOres.stream().noneMatch(is -> GT_Utility.areStacksEqual((ItemStack)is, (ItemStack)output)) || !this.mBlacklist && inputOres.stream().anyMatch(is -> GT_Utility.areStacksEqual((ItemStack)is, (ItemStack)output))) {
            this.addOutput(output);
        }
        this.updateSlots();
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mBlacklist = !this.mBlacklist;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Mode: " + (this.mBlacklist ? "Blacklist" : "Whitelist")));
    }
}

