/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util;

import com.github.bartimaeusnek.bartworks.API.recipe.BartWorksRecipeMaps;
import com.github.bartimaeusnek.bartworks.common.loaders.BioItemList;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.BioCulture;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_Recipe;
import javax.annotation.Nonnegative;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BWRecipes {
    public static final BWRecipes instance = new BWRecipes();

    public static long calcDecayTicks(int x) {
        long ret = x == 43 ? 5000L : (x == 61 ? 4500L : (x <= 100 ? MathUtils.ceilLong((8000.0 * Math.tanh((double)(-x) / 20.0) + 8000.0) * 1000.0) : MathUtils.ceilLong(8000.0 * Math.tanh((double)(-x) / 65.0) + 8000.0)));
        return ret;
    }

    public boolean addRadHatch(ItemStack item, int radioLevel, int amount, short[] rgba) {
        return BartWorksRecipeMaps.radioHatchRecipes.addRecipe(new GT_Recipe(false, new ItemStack[]{item}, null, null, new int[]{rgba[0], rgba[1], rgba[2]}, null, null, amount, radioLevel, (int)BWRecipes.calcDecayTicks(radioLevel))) != null;
    }

    public boolean addBioLabRecipe(ItemStack[] aInputs, ItemStack aOutput, ItemStack aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        return BartWorksRecipeMaps.bioLabRecipes.addRecipe(new GT_Recipe(true, aInputs, new ItemStack[]{aOutput}, (Object)aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue)) != null;
    }

    public boolean addBioLabRecipeIncubation(ItemStack aInput, BioCulture aOutput, int[] aChances, FluidStack[] aFluidInputs, int aDuration, int aEUt, int aSpecialValue) {
        return BartWorksRecipeMaps.bioLabRecipes.addRecipe(new GT_Recipe(true, new ItemStack[]{BioItemList.getPetriDish(null), aInput}, new ItemStack[]{BioItemList.getPetriDish(aOutput)}, null, aChances, aFluidInputs, new FluidStack[]{GT_Values.NF}, aDuration, aEUt, aSpecialValue)) != null;
    }

    public boolean addBioLabRecipeIncubation(ItemStack aInput, BioCulture aOutput, int[] aChances, FluidStack aFluidInputs, int aDuration, int aEUt, int aSpecialValue) {
        return BartWorksRecipeMaps.bioLabRecipes.addRecipe(new GT_Recipe(true, new ItemStack[]{BioItemList.getPetriDish(null), aInput}, new ItemStack[]{BioItemList.getPetriDish(aOutput)}, null, aChances, new FluidStack[]{aFluidInputs}, new FluidStack[]{GT_Values.NF}, aDuration, aEUt, aSpecialValue)) != null;
    }

    public boolean addBacterialVatRecipe(ItemStack[] aInputs, BioCulture aCulture, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, @Nonnegative int aDuration, @Nonnegative int aEUt, @Nonnegative int aSv, @Nonnegative int glasTier, int aSpecialValue, boolean exactSv) {
        int aSievert = 0;
        if (aSv >= 83 || aSv == 61 || aSv == 43) {
            aSievert += aSv;
        }
        aSievert <<= 1;
        aSievert |= exactSv ? 1 : 0;
        aSievert <<= 2;
        aSievert |= BW_Util.specialToByte(aSpecialValue);
        aSievert <<= 4;
        return BartWorksRecipeMaps.bacterialVatRecipes.addRecipe(new GT_Recipe(false, aInputs, null, (Object)BioItemList.getPetriDish(aCulture), new int[0], aFluidInputs, aFluidOutputs, aDuration, aEUt, aSievert |= glasTier)) != null;
    }

    @Deprecated
    public boolean addBacterialVatRecipe(ItemStack[] aInputs, BioCulture aCulture, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, Materials material, @Nonnegative int glasTier, int aSpecialValue, boolean exactSv) {
        byte gTier = (byte)glasTier;
        int aSievert = 0;
        if (material.getProtons() >= 83L || material.getProtons() == 61L || material.getProtons() == 43L) {
            aSievert += BW_Util.calculateSv(material);
        }
        aSievert <<= 1;
        aSievert |= exactSv ? 1 : 0;
        aSievert <<= 2;
        aSievert |= BW_Util.specialToByte(aSpecialValue);
        aSievert <<= 4;
        return BartWorksRecipeMaps.bacterialVatRecipes.addRecipe(new GT_Recipe(false, aInputs, null, (Object)BioItemList.getPetriDish(aCulture), new int[0], aFluidInputs, aFluidOutputs, aDuration, aEUt, aSievert |= gTier)) != null;
    }

    public boolean addBacterialVatRecipe(ItemStack[] aInputs, BioCulture culture, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, byte glasTier) {
        int aSievert = 0;
        return BartWorksRecipeMaps.bacterialVatRecipes.addRecipe(new GT_Recipe(false, aInputs, null, (Object)BioItemList.getPetriDish(culture), new int[0], aFluidInputs, aFluidOutputs, aDuration, aEUt, aSievert |= glasTier)) != null;
    }

    public boolean addBacterialVatRecipe(ItemStack[] aInputs, FluidStack[] aFluidInputs, BioCulture culture, FluidStack[] aFluidOutputs, int aDuration, int aEUt) {
        return BartWorksRecipeMaps.bacterialVatRecipes.addRecipe(new GT_Recipe(false, aInputs, null, (Object)BioItemList.getPetriDish(culture), new int[0], aFluidInputs, aFluidOutputs, aDuration, aEUt, 0)) != null;
    }
}

