/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import com.github.bartimaeusnek.bartworks.util.Pair;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class DustLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (werkstoff.hasItemType(OrePrefixes.dust)) {
            ArrayList<FluidStack> flOutputs = new ArrayList<FluidStack>();
            ArrayList<ItemStack> stOutputs = new ArrayList<ItemStack>();
            HashMap<ISubTagContainer, Pair<Integer, Integer>> tracker = new HashMap<ISubTagContainer, Pair<Integer, Integer>>();
            int cells = 0;
            if (werkstoff.getGenerationFeatures().hasMixerRecipes() || werkstoff.getStats().isElektrolysis() || werkstoff.getStats().isCentrifuge() || werkstoff.getGenerationFeatures().hasChemicalRecipes()) {
                for (Pair container : werkstoff.getContents().getValue().toArray(new Pair[0])) {
                    FluidStack tmpFl;
                    ISubTagContainer key = (ISubTagContainer)container.getKey();
                    int value = (Integer)container.getValue();
                    if (key instanceof Materials) {
                        Materials materialKey = (Materials)key;
                        if ((materialKey.getGas(0L) != null || materialKey.getFluid(0L) != null || materialKey.mIconSet == TextureSet.SET_FLUID) && materialKey.getDust(0) == null) {
                            tmpFl = materialKey.getGas(1000L * (long)value);
                            if (tmpFl == null || tmpFl.getFluid() == null) {
                                tmpFl = materialKey.getFluid(1000L * (long)value);
                            }
                            flOutputs.add(tmpFl);
                            if (flOutputs.size() <= 1) continue;
                            if (!tracker.containsKey(key)) {
                                stOutputs.add(materialKey.getCells(value));
                                tracker.put(key, new Pair<Integer, Integer>(value, stOutputs.size() - 1));
                            } else {
                                stOutputs.add(materialKey.getCells((Integer)((Pair)tracker.get(key)).getKey() + value));
                                stOutputs.remove((Integer)((Pair)tracker.get(key)).getValue() + 1);
                            }
                            cells += value;
                            continue;
                        }
                        if (materialKey.getDust(value) == null) {
                            if (materialKey.getCells(value) == null || materialKey.getMolten(0L) == null && materialKey.getSolid(0L) == null) continue;
                            tmpFl = materialKey.getMolten(1000L * (long)value);
                            if (tmpFl == null || tmpFl.getFluid() == null) {
                                tmpFl = materialKey.getSolid(1000L * (long)value);
                            }
                            flOutputs.add(tmpFl);
                            if (flOutputs.size() > 1) {
                                if (!tracker.containsKey(key)) {
                                    stOutputs.add(materialKey.getCells(value));
                                    tracker.put(key, new Pair<Integer, Integer>(value, stOutputs.size() - 1));
                                } else {
                                    stOutputs.add(materialKey.getCells((Integer)((Pair)tracker.get(key)).getKey() + value));
                                    stOutputs.remove((Integer)((Pair)tracker.get(key)).getValue() + 1);
                                }
                                cells += value;
                            }
                        }
                        if (!tracker.containsKey(key)) {
                            stOutputs.add(materialKey.getDust(value));
                            tracker.put(key, new Pair<Integer, Integer>(value, stOutputs.size() - 1));
                            continue;
                        }
                        stOutputs.add(materialKey.getDust((Integer)((Pair)tracker.get(key)).getKey() + value));
                        stOutputs.remove((Integer)((Pair)tracker.get(key)).getValue() + 1);
                        continue;
                    }
                    if (!(key instanceof Werkstoff)) continue;
                    Werkstoff werkstoffKey = (Werkstoff)key;
                    if (werkstoffKey.getStats().isGas() || werkstoffKey.hasItemType(OrePrefixes.cell)) {
                        tmpFl = werkstoffKey.getFluidOrGas(1000 * value);
                        if (tmpFl == null || tmpFl.getFluid() == null) {
                            tmpFl = werkstoffKey.getFluidOrGas(1000 * value);
                        }
                        flOutputs.add(tmpFl);
                        if (flOutputs.size() <= 1) continue;
                        if (!tracker.containsKey(key)) {
                            stOutputs.add(werkstoffKey.get(OrePrefixes.cell, value));
                            tracker.put(key, new Pair<Integer, Integer>(value, stOutputs.size() - 1));
                        } else {
                            stOutputs.add(werkstoffKey.get(OrePrefixes.cell, (Integer)((Pair)tracker.get(key)).getKey() + value));
                            stOutputs.remove((Integer)((Pair)tracker.get(key)).getValue() + 1);
                        }
                        cells += value;
                        continue;
                    }
                    if (!werkstoffKey.hasItemType(OrePrefixes.dust)) continue;
                    if (!tracker.containsKey(key)) {
                        stOutputs.add(werkstoffKey.get(OrePrefixes.dust, value));
                        tracker.put(key, new Pair<Integer, Integer>(value, stOutputs.size() - 1));
                        continue;
                    }
                    stOutputs.add(werkstoffKey.get(OrePrefixes.dust, (Integer)((Pair)tracker.get(key)).getKey() + value));
                    stOutputs.remove((Integer)((Pair)tracker.get(key)).getValue() + 1);
                }
                ItemStack input = werkstoff.get(OrePrefixes.dust);
                input.field_77994_a = werkstoff.getContents().getKey();
                if (werkstoff.getStats().isElektrolysis()) {
                    GT_Recipe tRecipe = new GT_Recipe(true, new ItemStack[]{input, cells > 0 ? Materials.Empty.getCells(cells) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0);
                    RecipeMaps.electrolyzerRecipes.add(tRecipe);
                    RecipeMaps.electrolyzerNonCellRecipes.add(tRecipe);
                }
                if (werkstoff.getStats().isCentrifuge()) {
                    RecipeMaps.centrifugeRecipes.add(new GT_Recipe(true, new ItemStack[]{input, cells > 0 ? Materials.Empty.getCells(cells) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoff.getStats().getMass() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 5, 0));
                    GT_Recipe tRecipe = new GT_Recipe(false, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0);
                    RecipeMaps.centrifugeNonCellRecipes.add(tRecipe);
                }
                if (werkstoff.getGenerationFeatures().hasChemicalRecipes()) {
                    if (cells > 0) {
                        stOutputs.add(Materials.Empty.getCells(cells));
                    }
                    GT_Values.RA.stdBuilder().itemInputs(stOutputs.toArray(new ItemStack[0])).itemOutputs(new ItemStack[]{input}).fluidInputs(flOutputs.toArray(new FluidStack[0])).duration((int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() / (long)werkstoff.getContents().getValue().size()))).eut(Math.min(4, werkstoff.getContents().getValue().size()) * 30).addTo(GT_RecipeConstants.UniversalChemical);
                }
                if (werkstoff.getGenerationFeatures().hasMixerRecipes()) {
                    short circuitID;
                    ItemStack circuit;
                    if (cells > 0) {
                        stOutputs.add(Materials.Empty.getCells(cells));
                    }
                    ItemStack itemStack = circuit = (circuitID = werkstoff.getMixCircuit()) == -1 ? null : GT_Utility.getIntegratedCircuit((int)circuitID);
                    if (circuit != null) {
                        stOutputs.add(circuit);
                    }
                    RecipeMaps.mixerRecipes.add(new GT_Recipe(true, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().getMass() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 5, 0));
                    GT_Recipe tRecipe = new GT_Recipe(false, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0);
                    RecipeMaps.mixerNonCellRecipes.add(tRecipe);
                }
            }
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (Object[])new Object[]{"TTT", "TTT", "TTT", Character.valueOf('T'), werkstoff.get(OrePrefixes.dustTiny)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (Object[])new Object[]{"TT ", "TT ", Character.valueOf('T'), WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustSmall, werkstoff)});
            GT_ModHandler.addCraftingRecipe((ItemStack)WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustSmall, werkstoff, 4), (Object[])new Object[]{" T ", Character.valueOf('T'), werkstoff.get(OrePrefixes.dust)});
            GT_ModHandler.addCraftingRecipe((ItemStack)WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustTiny, werkstoff, 9), (Object[])new Object[]{"T  ", Character.valueOf('T'), werkstoff.get(OrePrefixes.dust)});
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dustTiny, 9), ItemList.Schematic_Dust.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust)}).duration(100).eut(4).addTo((IRecipeMap)RecipeMaps.packagerRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dustSmall, 4), ItemList.Schematic_Dust.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust)}).duration(100).eut(4).addTo((IRecipeMap)RecipeMaps.packagerRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dustTiny, 9), ItemList.Schematic_3by3.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust)}).duration(100).eut(4).addTo((IRecipeMap)RecipeMaps.packagerRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dustSmall, 4), ItemList.Schematic_2by2.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust)}).duration(100).eut(4).addTo((IRecipeMap)RecipeMaps.packagerRecipes);
            if (werkstoff.hasItemType(OrePrefixes.ingot) && !werkstoff.getStats().isBlastFurnace()) {
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (ItemStack)werkstoff.get(OrePrefixes.ingot));
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.dustTiny), (ItemStack)werkstoff.get(OrePrefixes.nugget));
            } else if (werkstoff.hasItemType(OrePrefixes.ingot) && werkstoff.getStats().isBlastFurnace() && werkstoff.getStats().getMeltingPoint() != 0) {
                if (werkstoff.contains(WerkstoffLoader.ANAEROBE_SMELTING)) {
                    GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)11)}).itemOutputs(new ItemStack[]{werkstoff.getStats().getMeltingPoint() < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot)}).fluidInputs(new FluidStack[]{Materials.Nitrogen.getGas(1000L)}).duration(Math.max(werkstoff.getStats().getMass() / 40L, 1L) * (long)werkstoff.getStats().getMeltingPoint()).eut(werkstoff.getStats().getMeltingVoltage()).metadata(GT_RecipeConstants.COIL_HEAT, (Object)werkstoff.getStats().getMeltingPoint()).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
                } else if (werkstoff.contains(WerkstoffLoader.NOBLE_GAS_SMELTING)) {
                    GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)11)}).itemOutputs(new ItemStack[]{werkstoff.getStats().getMeltingPoint() < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot)}).fluidInputs(new FluidStack[]{Materials.Argon.getGas(1000L)}).duration(Math.max(werkstoff.getStats().getMass() / 40L, 1L) * (long)werkstoff.getStats().getMeltingPoint()).eut(werkstoff.getStats().getMeltingVoltage()).metadata(GT_RecipeConstants.COIL_HEAT, (Object)werkstoff.getStats().getMeltingPoint()).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
                } else {
                    GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{werkstoff.getStats().getMeltingPoint() < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot)}).duration(Math.max(werkstoff.getStats().getMass() / 40L, 1L) * (long)werkstoff.getStats().getMeltingPoint()).eut(werkstoff.getStats().getMeltingVoltage()).metadata(GT_RecipeConstants.COIL_HEAT, (Object)werkstoff.getStats().getMeltingPoint()).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
                    if (werkstoff.getStats().getMeltingPoint() <= 1000) {
                        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot)}).duration((int)Math.max(werkstoff.getStats().getMass() / 40L, 1L) * werkstoff.getStats().getMeltingPoint()).eut(0).metadata(GT_RecipeConstants.ADDITIVE_AMOUNT, (Object)9).addTo((IRecipeMap)RecipeMaps.primitiveBlastRecipes);
                    }
                }
            }
            if (werkstoff.getStats().isBlastFurnace() && werkstoff.getStats().getMeltingPoint() > 1750) {
                GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingotHot)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot)}).duration((int)Math.max(werkstoff.getStats().getMass() * 3L, 1L)).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.vacuumFreezerRecipes);
            }
            if (werkstoff.hasItemType(OrePrefixes.ingot)) {
                GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust)}).duration(400).eut(2).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
                GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.nugget)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dustTiny)}).duration(400).eut(2).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
            }
            if (werkstoff.hasItemType(OrePrefixes.ingot) || werkstoff.hasItemType(OrePrefixes.gem)) {
                GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.block)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust, 9)}).duration(400).eut(2).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
            }
        }
    }
}

