/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.classic;

import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class BW_TileEntity_InfinityTank
extends TileEntity
implements IFluidTank,
IFluidHandler {
    final ArrayList<FluidStack> INTERNALTANKS = new ArrayList();
    int selectedTank;

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource != null ? resource.amount : 0, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        boolean ret = false;
        for (FluidStack stack : this.INTERNALTANKS) {
            ret = GT_Utility.areFluidsEqual((FluidStack)stack, (FluidStack)new FluidStack(fluid, 0));
            if (!ret) continue;
            this.selectedTank = this.INTERNALTANKS.indexOf(stack);
            break;
        }
        return ret;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    public FluidStack getFluid() {
        if ((this.INTERNALTANKS.get(this.selectedTank) == null || this.INTERNALTANKS.get((int)this.selectedTank).amount == 0) && this.selectedTank > 0) {
            this.selectedTank = this.INTERNALTANKS.size() - 1;
        }
        return this.INTERNALTANKS.get(this.selectedTank);
    }

    public int getFluidAmount() {
        return this.INTERNALTANKS.get(this.selectedTank) != null ? this.INTERNALTANKS.get((int)this.selectedTank).amount : 0;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList lInternalTank = new NBTTagList();
        for (FluidStack internaltank : this.INTERNALTANKS) {
            if (internaltank == null) continue;
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74778_a("FluidName", internaltank.getFluid().getName());
            entry.func_74768_a("Ammount", internaltank.amount);
            entry.func_74782_a("FluidTag", (NBTBase)internaltank.tag);
            lInternalTank.func_74742_a((NBTBase)entry);
        }
        compound.func_74782_a("InternalTank", (NBTBase)lInternalTank);
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public FluidTankInfo getInfo() {
        return null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.field_145850_b.field_72995_K || resource == null || resource.amount == 0) {
            return 0;
        }
        if (!doFill) {
            return resource.amount;
        }
        int id = 0;
        if (this.canDrain(null, resource.getFluid())) {
            for (FluidStack stack : this.INTERNALTANKS) {
                if (!GT_Utility.areFluidsEqual((FluidStack)stack, (FluidStack)resource)) continue;
                id = this.INTERNALTANKS.indexOf(stack);
                this.INTERNALTANKS.get((int)id).amount += resource.amount;
                this.selectedTank = id;
            }
        } else {
            this.INTERNALTANKS.add(resource);
            this.selectedTank = id = this.INTERNALTANKS.size() - 1;
        }
        return this.INTERNALTANKS.get((int)id).amount;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack outputstack = this.INTERNALTANKS.get(this.selectedTank);
        if (this.field_145850_b.field_72995_K || maxDrain == 0 || this.getFluid() == null || outputstack == null) {
            return null;
        }
        int actualdrain = maxDrain;
        if (actualdrain > outputstack.amount) {
            actualdrain = outputstack.amount;
        }
        FluidStack ret = new FluidStack(outputstack.getFluid(), actualdrain);
        if (ret.amount == 0) {
            ret = null;
        }
        if (doDrain) {
            outputstack.amount -= actualdrain;
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(outputstack, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, actualdrain));
        }
        return ret;
    }
}

