/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.API;

import com.github.bartimaeusnek.bartworks.util.BioCulture;
import com.github.bartimaeusnek.bartworks.util.BioDNA;
import com.github.bartimaeusnek.bartworks.util.BioData;
import com.github.bartimaeusnek.bartworks.util.BioPlasmid;
import gregtech.api.enums.FluidState;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.TierEU;
import gregtech.api.fluid.GT_FluidFactory;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_Utility;
import java.awt.Color;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class BioObjectAdder {
    public static BioCulture createAndRegisterBioCulture(Color color, String name, BioPlasmid plasmid, BioDNA dna, EnumRarity rarity, boolean breedable) {
        if (BioCulture.BIO_CULTURE_ARRAY_LIST.size() > 1) {
            return BioCulture.createAndRegisterBioCulture(color, name, plasmid, dna, rarity, breedable);
        }
        new Exception("Too Early to register a BioCulture! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioCulture createAndRegisterBioCulture(Color color, String name, BioPlasmid plasmid, BioDNA dna, boolean breedable) {
        if (BioCulture.BIO_CULTURE_ARRAY_LIST.size() > 1) {
            return BioCulture.createAndRegisterBioCulture(color, name, plasmid, dna, breedable);
        }
        new Exception("Too Early to register a BioCulture! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioData createAndRegisterBioData(String aName, EnumRarity rarity, int chance, int tier) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioData.createAndRegisterBioData(aName, rarity, chance, tier);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioDNA createAndRegisterBioDNA(String aName, EnumRarity rarity) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioDNA.createAndRegisterBioDNA(aName, rarity);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioPlasmid createAndRegisterBioPlasmid(String aName, EnumRarity rarity) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioPlasmid.createAndRegisterBioPlasmid(aName, rarity);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioDNA createAndRegisterBioDNA(String aName, EnumRarity rarity, int chance, int tier) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioDNA.createAndRegisterBioDNA(aName, rarity, chance, tier);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioPlasmid createAndRegisterBioPlasmid(String aName, EnumRarity rarity, int chance, int tier) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioPlasmid.createAndRegisterBioPlasmid(aName, rarity, chance, tier);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static int getBacteriaTierFromVoltageTier(int voltageTier) {
        return Math.max(voltageTier - 6, 0);
    }

    public static void regenerateBioFluids() {
        FluidStack dnaFluid = Mods.Gendustry.isModLoaded() ? FluidRegistry.getFluidStack((String)"liquiddna", (int)100) : Materials.Biomass.getFluid(100L);
        for (BioCulture B : BioCulture.BIO_CULTURE_ARRAY_LIST) {
            if (!B.getFluidNotSet()) continue;
            B.setFluid(GT_FluidFactory.builder((String)(B.getName().replace(" ", "").toLowerCase() + "fluid")).withTextureName("molten.autogenerated").withColorRGBA(new short[]{(short)B.getColor().getRed(), (short)B.getColor().getBlue(), (short)B.getColor().getGreen()}).withStateAndTemperature(FluidState.LIQUID, 300).buildAndRegister().asFluid());
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)10)}).fluidInputs(new FluidStack[]{new FluidStack(B.getFluid(), 1000)}).fluidOutputs(new FluidStack[]{dnaFluid}).duration(500).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
        }
    }
}

