/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.net;

import com.github.bartimaeusnek.bartworks.common.items.Circuit_Programmer;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GT_Packet_New;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CircuitProgrammerPacket
extends GT_Packet_New {
    private int dimID;
    private int playerID;
    private byte chipCfg;
    private boolean hasChip;

    public CircuitProgrammerPacket() {
        super(true);
    }

    public CircuitProgrammerPacket(int dimID, int playerID, boolean hasChip, byte chipCfg) {
        super(false);
        this.dimID = dimID;
        this.playerID = playerID;
        this.hasChip = hasChip;
        this.chipCfg = chipCfg;
    }

    public byte getPacketID() {
        return 1;
    }

    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.dimID).writeInt(this.playerID).writeByte(this.hasChip ? (int)this.chipCfg : -1);
    }

    public GT_Packet_New decode(ByteArrayDataInput byteArrayDataInput) {
        return new CircuitProgrammerPacket(byteArrayDataInput.readInt(), byteArrayDataInput.readInt(), byteArrayDataInput.readByte() > -1, byteArrayDataInput.readByte());
    }

    public void process(IBlockAccess iBlockAccess) {
        Item item;
        ItemStack stack;
        WorldServer w = DimensionManager.getWorld((int)this.dimID);
        if (w != null && w.func_73045_a(this.playerID) instanceof EntityPlayer && (stack = ((EntityPlayer)w.func_73045_a(this.playerID)).func_70694_bm()) != null && stack.field_77994_a > 0 && (item = stack.func_77973_b()) instanceof Circuit_Programmer) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_74757_a("HasChip", this.hasChip);
            if (this.hasChip) {
                nbt.func_74774_a("ChipConfig", this.chipCfg);
            }
            stack.func_77982_d(nbt);
            ((EntityPlayer)w.func_73045_a((int)this.playerID)).field_71071_by.func_70299_a(((EntityPlayer)w.func_73045_a((int)this.playerID)).field_71071_by.field_70461_c, stack);
        }
    }
}

