/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import com.github.bartimaeusnek.bartworks.util.Pair;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CellLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (!werkstoff.hasItemType(OrePrefixes.cell)) {
            return;
        }
        if ((werkstoff.getStats().isElektrolysis() || werkstoff.getStats().isCentrifuge()) && !werkstoff.hasItemType(OrePrefixes.dust)) {
            ArrayList<FluidStack> flOutputs = new ArrayList<FluidStack>();
            ArrayList<ItemStack> stOutputs = new ArrayList<ItemStack>();
            Element[] tracker = new HashMap();
            int cells = 0;
            for (Pair container : werkstoff.getContents().getValue().toArray(new Pair[0])) {
                FluidStack tmpFl;
                if (container.getKey() instanceof Materials) {
                    if ((((Materials)container.getKey()).hasCorrespondingGas() || ((Materials)container.getKey()).hasCorrespondingFluid() || ((Materials)container.getKey()).mIconSet == TextureSet.SET_FLUID) && ((Materials)container.getKey()).getDust(0) == null) {
                        tmpFl = ((Materials)container.getKey()).getGas(1000L * (long)((Integer)container.getValue()).intValue());
                        if (tmpFl == null || tmpFl.getFluid() == null) {
                            tmpFl = ((Materials)container.getKey()).getFluid(1000L * (long)((Integer)container.getValue()).intValue());
                        }
                        flOutputs.add(tmpFl);
                        if (flOutputs.size() <= 1) continue;
                        if (!tracker.containsKey(container.getKey())) {
                            stOutputs.add(((Materials)container.getKey()).getCells(((Integer)container.getValue()).intValue()));
                            tracker.put((ISubTagContainer)container.getKey(), new Pair<Integer, Integer>((Integer)container.getValue(), stOutputs.size() - 1));
                        } else {
                            stOutputs.add(((Materials)container.getKey()).getCells((Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                            stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                        }
                        cells += ((Integer)container.getValue()).intValue();
                        continue;
                    }
                    if (((Materials)container.getKey()).getDust(((Integer)container.getValue()).intValue()) == null) continue;
                    if (!tracker.containsKey(container.getKey())) {
                        stOutputs.add(((Materials)container.getKey()).getDust(((Integer)container.getValue()).intValue()));
                        tracker.put((ISubTagContainer)container.getKey(), new Pair<Integer, Integer>((Integer)container.getValue(), stOutputs.size() - 1));
                        continue;
                    }
                    stOutputs.add(((Materials)container.getKey()).getDust((Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                    stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                    continue;
                }
                if (!(container.getKey() instanceof Werkstoff)) continue;
                if (((Werkstoff)container.getKey()).getStats().isGas() || ((Werkstoff)container.getKey()).hasItemType(OrePrefixes.cell)) {
                    tmpFl = ((Werkstoff)container.getKey()).getFluidOrGas(1000 * (Integer)container.getValue());
                    if (tmpFl == null || tmpFl.getFluid() == null) {
                        tmpFl = ((Werkstoff)container.getKey()).getFluidOrGas(1000 * (Integer)container.getValue());
                    }
                    flOutputs.add(tmpFl);
                    if (flOutputs.size() <= 1) continue;
                    if (!tracker.containsKey(container.getKey())) {
                        stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.cell, (Integer)container.getValue()));
                        tracker.put((ISubTagContainer)container.getKey(), new Pair<Integer, Integer>((Integer)container.getValue(), stOutputs.size() - 1));
                    } else {
                        stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.cell, (Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                        stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                    }
                    cells += ((Integer)container.getValue()).intValue();
                    continue;
                }
                if (!((Werkstoff)container.getKey()).hasItemType(OrePrefixes.dust)) continue;
                if (!tracker.containsKey(container.getKey())) {
                    stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.dust, (Integer)container.getValue()));
                    tracker.put((ISubTagContainer)container.getKey(), new Pair<Integer, Integer>((Integer)container.getValue(), stOutputs.size() - 1));
                    continue;
                }
                stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.dust, (Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
            }
            ItemStack input = werkstoff.get(OrePrefixes.cell);
            input.field_77994_a = 1;
            int cellEmpty = cells - 1;
            stOutputs.add(Materials.Empty.getCells(-cellEmpty));
            if (werkstoff.getStats().isElektrolysis()) {
                RecipeMaps.electrolyzerRecipes.add(new GT_Recipe(true, new ItemStack[]{input, cellEmpty > 0 ? Materials.Empty.getCells(cellEmpty) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() * (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0));
            }
            if (werkstoff.getStats().isCentrifuge()) {
                RecipeMaps.centrifugeRecipes.add(new GT_Recipe(true, new ItemStack[]{input, cellEmpty > 0 ? Materials.Empty.getCells(cellEmpty) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoff.getStats().getMass() * (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 5, 0));
            }
        }
        GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)werkstoff)), 1000), werkstoff.get(OrePrefixes.cell), Materials.Empty.getCells(1)));
        FluidContainerRegistry.registerFluidContainer((Fluid)werkstoff.getFluidOrGas(1).getFluid(), (ItemStack)werkstoff.get(OrePrefixes.cell), (ItemStack)Materials.Empty.getCells(1));
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.Empty.getCells(1)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.cell)}).fluidInputs(new FluidStack[]{new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)werkstoff)), 1000)}).duration(16).eut(2).addTo((IRecipeMap)RecipeMaps.fluidCannerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.cell)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1)}).fluidOutputs(new FluidStack[]{new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)werkstoff)), 1000)}).duration(16).eut(2).addTo((IRecipeMap)RecipeMaps.fluidCannerRecipes);
        if (Mods.Forestry.isModLoaded()) {
            FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)werkstoff)), 1000), werkstoff.get(OrePrefixes.capsule), GT_ModHandler.getModItem((String)Mods.Forestry.ID, (String)"waxCapsule", (long)1L), true);
            GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)emptyData);
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)emptyData);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.capsule)}).fluidOutputs(new FluidStack[]{new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)werkstoff)), 1000)}).duration(16).eut(2).addTo((IRecipeMap)RecipeMaps.fluidCannerRecipes);
        }
        if (werkstoff.hasItemType(OrePrefixes.dust)) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust)}).fluidOutputs(new FluidStack[]{werkstoff.getFluidOrGas(1000)}).duration(werkstoff.getStats().getMass()).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust)}).fluidInputs(new FluidStack[]{werkstoff.getFluidOrGas(1000)}).duration((int)werkstoff.getStats().getMass()).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
        }
        if (Werkstoff.Types.ELEMENT.equals((Object)werkstoff.getType())) {
            Materials werkstoffBridgeMaterial = null;
            boolean ElementSet = false;
            for (Element e : Element.values()) {
                if (!e.toString().equals(werkstoff.getToolTip())) continue;
                werkstoffBridgeMaterial = werkstoff.getBridgeMaterial() != null ? werkstoff.getBridgeMaterial() : new Materials(-1, werkstoff.getTexSet(), 0.0f, 0, 0, false, werkstoff.getDefaultName(), werkstoff.getDefaultName());
                werkstoffBridgeMaterial.mElement = e;
                e.mLinkedMaterials.add(werkstoffBridgeMaterial);
                ElementSet = true;
                werkstoff.setBridgeMaterial(werkstoffBridgeMaterial);
                break;
            }
            if (!ElementSet) {
                return;
            }
            GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.cell, werkstoffBridgeMaterial, (ItemStack)werkstoff.get(OrePrefixes.cell), (boolean)false);
            ItemStack scannerOutput = ItemList.Tool_DataOrb.get(1L, new Object[0]);
            Behaviour_DataOrb.setDataTitle((ItemStack)scannerOutput, (String)"Elemental-Scan");
            Behaviour_DataOrb.setDataName((ItemStack)scannerOutput, (String)werkstoff.getToolTip());
            RecipeMaps.scannerFakeRecipes.addFakeRecipe(false, new GT_Recipe(false, new ItemStack[]{werkstoff.get(OrePrefixes.cell)}, new ItemStack[]{scannerOutput}, (Object)ItemList.Tool_DataOrb.get(1L, new Object[0]), null, null, null, (int)(werkstoffBridgeMaterial.getMass() * 8192L), 30, 0));
        }
    }
}

