/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.API;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Mods;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import org.apache.commons.lang3.tuple.Pair;

public class BorosilicateGlass {
    private static Block block;
    private static Block block2;
    private static List<Pair<Block, Integer>> representatives;
    private static SetMultimap<Byte, Pair<Block, Integer>> allLevels;
    private static final Table<Block, Integer, Byte> allLevelsReverse;

    private static boolean isValidTier(int tier) {
        return tier > 0 && tier <= 127;
    }

    private static Block getGlassBlock() {
        if (block == null) {
            block = GameRegistry.findBlock((String)Mods.BartWorks.ID, (String)"BW_GlasBlocks");
        }
        return block;
    }

    private static Block getGlassBlock2() {
        if (block2 == null) {
            block2 = GameRegistry.findBlock((String)Mods.BartWorks.ID, (String)"BW_GlasBlocks2");
        }
        return block2;
    }

    private static void doRegister(byte level, Block block, int meta, SetMultimap<Byte, Pair<Block, Integer>> allLevels) {
        allLevels.put((Object)level, (Object)Pair.of((Object)block, (Object)meta));
        allLevelsReverse.put((Object)block, (Object)meta, (Object)level);
    }

    private static SetMultimap<Byte, Pair<Block, Integer>> getAllLevels() {
        if (allLevels == null) {
            LinkedHashMultimap ret = LinkedHashMultimap.create();
            Block block = BorosilicateGlass.getGlassBlock();
            BorosilicateGlass.doRegister((byte)3, block, 0, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            BorosilicateGlass.doRegister((byte)4, block, 1, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            BorosilicateGlass.doRegister((byte)5, block, 12, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            BorosilicateGlass.doRegister((byte)5, block, 2, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            BorosilicateGlass.doRegister((byte)6, block, 3, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            BorosilicateGlass.doRegister((byte)7, block, 4, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            BorosilicateGlass.doRegister((byte)8, block, 5, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            for (int i = 6; i < 12; ++i) {
                BorosilicateGlass.doRegister((byte)3, block, i, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            }
            BorosilicateGlass.doRegister((byte)9, block, 13, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            BorosilicateGlass.doRegister((byte)10, block, 14, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            BorosilicateGlass.doRegister((byte)11, block, 15, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            block = BorosilicateGlass.getGlassBlock2();
            BorosilicateGlass.doRegister((byte)12, block, 0, (SetMultimap<Byte, Pair<Block, Integer>>)ret);
            allLevels = ret;
        }
        return allLevels;
    }

    private static List<Pair<Block, Integer>> getRepresentatives() {
        if (representatives == null) {
            SetMultimap<Byte, Pair<Block, Integer>> allLevels = BorosilicateGlass.getAllLevels();
            ArrayList<Pair<Block, Integer>> ret = new ArrayList<Pair<Block, Integer>>();
            for (Byte level : new PriorityQueue(allLevels.keySet())) {
                ret.add((Pair<Block, Integer>)((Pair)allLevels.get((Object)level).iterator().next()));
            }
            representatives = ret;
        }
        return representatives;
    }

    private static byte checkWithinBound(byte val, byte lo, byte hi) {
        return val > hi || val < lo ? (byte)-1 : val;
    }

    public static void registerGlass(Block block, int meta, byte tier) {
        if (Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            throw new IllegalStateException("register too late!");
        }
        if (!Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new IllegalStateException("register too early!");
        }
        if (!BorosilicateGlass.isValidTier(tier)) {
            throw new IllegalArgumentException("not a valid tier: " + tier);
        }
        BorosilicateGlass.doRegister(tier, block, meta, BorosilicateGlass.getAllLevels());
    }

    public static boolean hasGlassInTier(int tier) {
        return BorosilicateGlass.getAllLevels().containsKey((Object)((byte)tier));
    }

    public static <T> IStructureElement<T> ofBoroGlass(int tier) {
        if (!BorosilicateGlass.hasGlassInTier(tier)) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.lazy(t -> {
            Pair<Block, Integer> pair = BorosilicateGlass.getRepresentatives().get(tier - 3);
            return StructureUtility.ofBlockAdder((t1, block1, meta) -> BorosilicateGlass.getTier(block1, meta) == tier, (Block)((Block)pair.getKey()), (int)((Integer)pair.getValue()));
        });
    }

    public static <T> IStructureElement<T> ofBoroGlassAnyTier() {
        return StructureUtility.lazy(t -> StructureUtility.ofBlockAnyMeta((Block)BorosilicateGlass.getGlassBlock()));
    }

    public static <T> IStructureElement<T> ofBoroGlass(byte initialValue, BiConsumer<T, Byte> setter, Function<T, Byte> getter) {
        return StructureUtility.lazy(t -> StructureUtility.ofBlocksTiered(BorosilicateGlass::getTier, BorosilicateGlass.getRepresentatives(), (Object)initialValue, (BiConsumer)setter, (Function)getter));
    }

    public static <T> IStructureElement<T> ofBoroGlass(byte initialValue, byte minTier, byte maxTier, BiConsumer<T, Byte> setter, Function<T, Byte> getter) {
        if (minTier > maxTier || minTier < 0) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.lazy(t -> StructureUtility.ofBlocksTiered((block1, meta) -> BorosilicateGlass.checkWithinBound(BorosilicateGlass.getTier(block1, meta), minTier, maxTier), BorosilicateGlass.getRepresentatives().stream().skip(Math.max(minTier - 3, 0)).limit(maxTier - minTier + 1).collect(Collectors.toList()), (Object)initialValue, (BiConsumer)setter, (Function)getter));
    }

    public static byte getTier(Block block, int meta) {
        Byte ret = (Byte)allLevelsReverse.get((Object)block, (Object)meta);
        return ret == null ? (byte)-1 : (byte)ret;
    }

    static {
        allLevelsReverse = HashBasedTable.create();
    }
}

