/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tectech.tileentites.tiered;

import com.github.technus.tectech.mechanics.pipe.IConnectsToEnergyTunnel;
import com.github.technus.tectech.thing.metaTileEntity.pipe.GT_MetaTileEntity_Pipe_Energy;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public interface LowPowerLaser
extends IMetaTileEntity,
IConnectsToEnergyTunnel {
    public boolean isSender();

    public boolean isReceiver();

    public boolean isTunnel();

    default public boolean isConnectedCorrectly(ForgeDirection side) {
        return false;
    }

    default public void setEUVar(long aEnergy) {
    }

    default public long getAMPERES() {
        return -1L;
    }

    default public long maxEUInput() {
        return -1L;
    }

    default public long maxEUOutput() {
        return -1L;
    }

    default public long maxEUStore() {
        return -1L;
    }

    default public long getTotalPower() {
        return this.getAMPERES() * Math.max(this.maxEUOutput(), this.maxEUInput()) - this.getAMPERES() / 20L;
    }

    default public void moveAroundLowPower(IGregTechTileEntity aBaseMetaTileEntity) {
        byte color = this.getBaseMetaTileEntity().getColorization();
        if (color >= 0) {
            ForgeDirection front = aBaseMetaTileEntity.getFrontFacing();
            ForgeDirection opposite = front.getOpposite();
            for (int dist = 1; dist < 250; dist = (int)((short)(dist + 1))) {
                IGregTechTileEntity tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSideAndDistance(front, dist);
                if (tGTTileEntity == null || tGTTileEntity.getColorization() != color) {
                    return;
                }
                IMetaTileEntity aMetaTileEntity = tGTTileEntity.getMetaTileEntity();
                if (aMetaTileEntity == null) {
                    return;
                }
                if (aMetaTileEntity instanceof LowPowerLaser && ((LowPowerLaser)aMetaTileEntity).isReceiver() && opposite == tGTTileEntity.getFrontFacing()) {
                    if (this.maxEUOutput() > ((LowPowerLaser)aMetaTileEntity).maxEUInput() || this.getAMPERES() > ((LowPowerLaser)aMetaTileEntity).getAMPERES()) {
                        aMetaTileEntity.doExplosion(this.maxEUOutput());
                        this.setEUVar(aBaseMetaTileEntity.getStoredEU() - this.maxEUOutput());
                        return;
                    }
                    if (this.maxEUOutput() == ((LowPowerLaser)aMetaTileEntity).maxEUInput()) {
                        long diff = Math.min(this.getAMPERES() * 20L * this.maxEUOutput(), Math.min(((LowPowerLaser)aMetaTileEntity).maxEUStore() - aMetaTileEntity.getBaseMetaTileEntity().getStoredEU(), aBaseMetaTileEntity.getStoredEU()));
                        this.setEUVar(aBaseMetaTileEntity.getStoredEU() - diff);
                        ((LowPowerLaser)aMetaTileEntity).setEUVar(aMetaTileEntity.getBaseMetaTileEntity().getStoredEU() + diff);
                    }
                    return;
                }
                if (!(aMetaTileEntity instanceof LowPowerLaser && ((LowPowerLaser)aMetaTileEntity).isTunnel() || aMetaTileEntity instanceof GT_MetaTileEntity_Pipe_Energy)) {
                    return;
                }
                if (aMetaTileEntity instanceof GT_MetaTileEntity_Pipe_Energy) {
                    if (((GT_MetaTileEntity_Pipe_Energy)aMetaTileEntity).connectionCount < 2) {
                        return;
                    }
                    ((GT_MetaTileEntity_Pipe_Energy)aMetaTileEntity).markUsed();
                    continue;
                }
                if (!(aMetaTileEntity instanceof LowPowerLaser) || !((LowPowerLaser)aMetaTileEntity).isTunnel() || ((LowPowerLaser)aMetaTileEntity).isConnectedCorrectly(front)) continue;
                return;
            }
        }
    }
}

