/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.client.renderer.BW_EICPistonVisualizer;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.common.net.EICPacket;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.Coords;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.net.GT_Packet;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_ElectricImplosionCompressor
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_ElectricImplosionCompressor> {
    public static GT_Recipe.GT_Recipe_Map eicMap;
    private static final boolean pistonEnabled;
    private Boolean piston = true;
    private static final SoundResource sound;
    private final ArrayList<ChunkCoordinates> chunkCoordinates = new ArrayList(5);
    private static final int CASING_INDEX = 16;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_ElectricImplosionCompressor> STRUCTURE_DEFINITION;

    public GT_TileEntity_ElectricImplosionCompressor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_ElectricImplosionCompressor(String aName) {
        super(aName);
    }

    public IStructureDefinition<GT_TileEntity_ElectricImplosionCompressor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Implosion Compressor").addInfo("Explosions are fun").addInfo("Controller block for the Electric Implosion Compressor").addInfo("Uses electricity instead of Explosives").addSeparator().beginStructureBlock(3, 9, 3, false).addController("Front 3rd layer center").addCasingInfo("Solid Steel Machine Casing", 8).addStructureInfo("Casings can be replaced with Explosion Warning Signs").addOtherStructurePart("Transformer-Winding Blocks", "Outer layer 2,3,7,8").addOtherStructurePart("Nickel-Zinc-Ferrite Blocks", "Inner layer 2,3,7,8").addOtherStructurePart("Neutronium Blocks", "Layer 4,5,6").addMaintenanceHatch("Any bottom casing", new int[]{1}).addInputBus("Any bottom casing", new int[]{1}).addInputHatch("Any bottom casing", new int[]{1}).addOutputBus("Any bottom casing", new int[]{1}).addEnergyHatch("Bottom and top middle", new int[]{2}).toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    public boolean checkRecipe(ItemStack aStack) {
        GT_Recipe tRecipe;
        if (((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0)).getEUVar() <= 0L || ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(1)).getEUVar() <= 0L) {
            return false;
        }
        ItemStack[] tItemInputs = this.getCompactedInputs();
        FluidStack[] tFluidInputs = this.getCompactedFluids();
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        if ((tItemInputs.length > 0 || tFluidInputs.length > 0) && (tRecipe = eicMap.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluidInputs, tItemInputs)) != null && tRecipe.isRecipeInputEqual(true, tFluidInputs, tItemInputs)) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mOutputItems = (ItemStack[])tRecipe.mOutputs.clone();
            this.mOutputFluids = (FluidStack[])tRecipe.mFluidOutputs.clone();
            this.updateSlots();
            return true;
        }
        return false;
    }

    private void updateChunkCoordinates() {
        this.chunkCoordinates.clear();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                int[] abc = new int[]{x, -2, z + 1};
                int[] xyz = new int[]{0, 0, 0};
                this.getExtendedFacing().getWorldOffset(abc, xyz);
                xyz[0] = xyz[0] + this.getBaseMetaTileEntity().getXCoord();
                xyz[1] = xyz[1] + this.getBaseMetaTileEntity().getYCoord();
                xyz[2] = xyz[2] + this.getBaseMetaTileEntity().getZCoord();
                this.chunkCoordinates.add(new ChunkCoordinates(xyz[0], xyz[1], xyz[2]));
            }
        }
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.updateChunkCoordinates();
    }

    public boolean drainEnergyInput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        GT_MetaTileEntity_Hatch_Energy h1 = (GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0);
        GT_MetaTileEntity_Hatch_Energy h2 = (GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(1);
        if (!GT_TileEntity_ElectricImplosionCompressor.isValidMetaTileEntity((MetaTileEntity)h1) || !GT_TileEntity_ElectricImplosionCompressor.isValidMetaTileEntity((MetaTileEntity)h2)) {
            return false;
        }
        return h1.getBaseMetaTileEntity().decreaseStoredEnergyUnits(aEU / 2L, false) && h2.getBaseMetaTileEntity().decreaseStoredEnergyUnits(aEU / 2L, false);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (pistonEnabled && aBaseMetaTileEntity.isActive() && aTick % 20L == 0L) {
            if (aBaseMetaTileEntity.isClientSide()) {
                this.animatePiston(aBaseMetaTileEntity);
            } else if (aBaseMetaTileEntity.hasMufflerUpgrade()) {
                MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(aBaseMetaTileEntity.getWorld(), (GT_Packet)new EICPacket(new Coords(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord()), true), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getZCoord());
            }
        }
    }

    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        super.setExtendedFacing(newExtendedFacing);
        this.updateChunkCoordinates();
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public void stopMachine() {
        this.resetPiston();
        super.stopMachine();
    }

    private void resetPiston() {
        if (!pistonEnabled) {
            return;
        }
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (!this.piston.booleanValue()) {
            this.chunkCoordinates.forEach(c -> aBaseMetaTileEntity.getWorld().func_147465_d(c.field_71574_a, c.field_71572_b, c.field_71573_c, GregTech_API.sBlockMetal5, 2, 3));
            this.piston = this.piston == false;
        }
    }

    private void activatePiston() {
        if (!pistonEnabled) {
            return;
        }
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (this.piston.booleanValue()) {
            this.chunkCoordinates.forEach(c -> aBaseMetaTileEntity.getWorld().func_147468_f(c.field_71574_a, c.field_71572_b, c.field_71573_c));
            this.piston = this.piston == false;
        }
    }

    private void animatePiston(IGregTechTileEntity aBaseMetaTileEntity) {
        if (!aBaseMetaTileEntity.getWorld().field_72995_K) {
            return;
        }
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            GT_Utility.doSoundAtClient((SoundResource)sound, (int)10, (float)1.0f, (float)1.0f, (double)this.chunkCoordinates.get((int)0).field_71574_a, (double)this.chunkCoordinates.get((int)0).field_71572_b, (double)this.chunkCoordinates.get((int)0).field_71573_c);
        }
        this.spawnVisualPistonBlocks(aBaseMetaTileEntity.getWorld(), this.chunkCoordinates.get((int)2).field_71574_a, this.chunkCoordinates.get((int)2).field_71572_b, this.chunkCoordinates.get((int)2).field_71573_c, 10);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVisualPistonBlocks(World world, int x, int y, int z, int age) {
        BW_EICPistonVisualizer pistonVisualizer = new BW_EICPistonVisualizer(world, x, y, z, age);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)pistonVisualizer);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("piston", this.piston.booleanValue());
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("piston")) {
            this.piston = aNBT.func_74767_n("piston");
        }
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        boolean isOK = this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 6, 0);
        boolean bl = isOK = isOK && this.mMaintenanceHatches.size() == 1 && this.mEnergyHatches.size() == 2;
        if (isOK) {
            this.activatePiston();
            return true;
        }
        this.resetPiston();
        return false;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_ElectricImplosionCompressor(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16)};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 1, 6, 0);
    }

    static {
        pistonEnabled = !ConfigHandler.disablePistonInEIC;
        sound = SoundResource.RANDOM_EXPLODE;
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"ccc", "cec", "ccc"}, {"ttt", "tft", "ttt"}, {"ttt", "tft", "ttt"}, {"nnn", "nnn", "nnn"}, {"nNn", "NNN", "nNn"}, {"nnn", "nnn", "nnn"}, {"t~t", "tft", "ttt"}, {"ttt", "tft", "ttt"}, {"CCC", "CeC", "CCC"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)4)})).addElement('t', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)1)).addElement('f', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)0)).addElement('n', StructureUtility.ofBlock((Block)GregTech_API.sBlockMetal5, (int)2)).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)16, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)16, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)16, (int)1), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)4)})).addElement('e', (IStructureElement)GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)16, (int)2)).addElement('N', (IStructureElement)new IStructureElement<GT_TileEntity_ElectricImplosionCompressor>(){

            public boolean check(GT_TileEntity_ElectricImplosionCompressor te, World world, int x, int y, int z) {
                if (!te.piston.booleanValue() && !world.func_147437_c(x, y, z)) {
                    return false;
                }
                return te.piston == false || world.func_147439_a(x, y, z) == GregTech_API.sBlockMetal5 && world.func_72805_g(x, y, z) == 2;
            }

            public boolean spawnHint(GT_TileEntity_ElectricImplosionCompressor te, World world, int x, int y, int z, ItemStack itemStack) {
                if (te.piston.booleanValue()) {
                    StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)GregTech_API.sBlockMetal5, (int)2);
                }
                return true;
            }

            public boolean placeBlock(GT_TileEntity_ElectricImplosionCompressor te, World world, int x, int y, int z, ItemStack itemStack) {
                if (te.piston.booleanValue()) {
                    world.func_147465_d(x, y, z, GregTech_API.sBlockMetal5, 2, 3);
                } else {
                    world.func_147468_f(x, y, z);
                }
                return true;
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(GT_TileEntity_ElectricImplosionCompressor t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.createEmpty();
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(GT_TileEntity_ElectricImplosionCompressor t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return StructureUtility.isAir().survivalPlaceBlock((Object)t, world, x, y, z, trigger, env);
            }
        }).build();
    }
}

