/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.net;

import com.github.bartimaeusnek.bartworks.common.net.CircuitProgrammerPacket;
import com.github.bartimaeusnek.bartworks.common.net.EICPacket;
import com.github.bartimaeusnek.bartworks.common.net.EIGPacket;
import com.github.bartimaeusnek.bartworks.common.net.MetaBlockPacket;
import com.github.bartimaeusnek.bartworks.common.net.OreDictCachePacket;
import com.github.bartimaeusnek.bartworks.common.net.RendererPacket;
import com.github.bartimaeusnek.bartworks.common.net.ServerJoinedPackage;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.server.FMLServerHandler;
import gregtech.api.enums.GT_Values;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.IGT_NetworkHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@ChannelHandler.Sharable
public class BW_Network
extends MessageToMessageCodec<FMLProxyPacket, GT_Packet>
implements IGT_NetworkHandler {
    private final EnumMap<Side, FMLEmbeddedChannel> mChannel = NetworkRegistry.INSTANCE.newChannel("BartWorks", new ChannelHandler[]{this, new HandlerShared()});
    private final GT_Packet[] mSubChannels = new GT_Packet[]{new RendererPacket(), new CircuitProgrammerPacket(), new MetaBlockPacket(), new OreDictCachePacket(), new ServerJoinedPackage(), new EICPacket(), new EIGPacket()};

    protected void encode(ChannelHandlerContext aContext, GT_Packet aPacket, List<Object> aOutput) throws Exception {
        aOutput.add(new FMLProxyPacket(Unpooled.buffer().writeByte((int)aPacket.getPacketID()).writeBytes(aPacket.encode()).copy(), (String)aContext.channel().attr(NetworkRegistry.FML_CHANNEL).get()));
    }

    protected void decode(ChannelHandlerContext aContext, FMLProxyPacket aPacket, List<Object> aOutput) throws Exception {
        ByteArrayDataInput aData = ByteStreams.newDataInput((byte[])aPacket.payload().array());
        aOutput.add(this.mSubChannels[aData.readByte()].decode(aData));
    }

    public void sendToPlayer(@Nonnull GT_Packet aPacket, @Nonnull EntityPlayerMP aPlayer) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPlayer);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    public void sendToAllPlayersinWorld(@Nonnull GT_Packet aPacket, World world) {
        for (String name : FMLServerHandler.instance().getServer().func_71213_z()) {
            this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)world.func_72924_a(name));
            this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
        }
    }

    public void sendToAllAround(@Nonnull GT_Packet aPacket, NetworkRegistry.TargetPoint aPosition) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPosition);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    public void sendToServer(@Nonnull GT_Packet aPacket) {
        this.mChannel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.mChannel.get(Side.CLIENT).writeAndFlush((Object)aPacket);
    }

    public void sendPacketToAllPlayersInRange(World aWorld, @Nonnull GT_Packet aPacket, int aX, int aZ) {
        if (!aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (!(tObject instanceof EntityPlayerMP)) break;
                EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                Chunk tChunk = aWorld.func_72938_d(aX, aZ);
                if (!tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) continue;
                this.sendToPlayer(aPacket, tPlayer);
            }
        }
    }

    @ChannelHandler.Sharable
    static final class HandlerShared
    extends SimpleChannelInboundHandler<GT_Packet> {
        HandlerShared() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, GT_Packet aPacket) throws Exception {
            EntityPlayer aPlayer = GT_Values.GT.getThePlayer();
            aPacket.process(aPlayer == null ? null : GT_Values.GT.getThePlayer().field_70170_p);
        }
    }
}

