/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement;

import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.crossmod.tectech.helper.CoilAdder;
import com.github.bartimaeusnek.crossmod.tectech.helper.IHasCoils;
import com.github.technus.tectech.mechanics.constructable.IConstructable;
import com.github.technus.tectech.mechanics.structure.IStructureDefinition;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import com.github.technus.tectech.mechanics.structure.StructureDefinition;
import com.github.technus.tectech.mechanics.structure.StructureUtility;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TT_OilCrackingUnit
extends GT_MetaTileEntity_MultiblockBase_EM
implements IHasCoils,
IConstructable {
    private short coilMeta = (short)-1;
    private byte blocks = 0;
    private static final byte TEXTURE_INDEX = 49;
    private static final IStructureDefinition<TT_OilCrackingUnit> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ABABA", "ABGBA", "ABABA"}, {"AB~BA", "E---F", "ABABA"}, {"ABCBA", "ABABA", "ABABA"}})).addElement(Character.valueOf('A'), StructureUtility.onElementPass(x -> {
        x.blocks = (byte)(x.blocks + 1);
    }, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))).addElement(Character.valueOf('B'), CoilAdder.getINSTANCE()).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicMaintenanceToMachineList, (int)49, (int)1)).addElement(Character.valueOf('E'), (IStructureElement)StructureUtility.ofHatchAdder(TT_OilCrackingUnit::addInputFluidHatch, (int)49, (int)2)).addElement(Character.valueOf('F'), (IStructureElement)StructureUtility.ofHatchAdder(TT_OilCrackingUnit::addOutputFluidHatch, (int)49, (int)3)).addElement(Character.valueOf('G'), (IStructureElement)StructureUtility.ofHatchAdder(TT_OilCrackingUnit::addMiddleFluidHatch, (int)49, (int)4)).build();
    GT_MetaTileEntity_Hatch_Input middleFluidHatch;

    public TT_OilCrackingUnit(Object unused) {
        super(32765, "multimachine.cracker", "Oil Cracking Unit");
        GregTech_API.METATILEENTITIES[32765] = null;
        GregTech_API.METATILEENTITIES[1160] = this;
    }

    private TT_OilCrackingUnit(String aName) {
        super(aName);
    }

    @Override
    public void setCoilMeta(short coilMeta) {
        this.coilMeta = coilMeta;
    }

    @Override
    public short getCoilMeta() {
        return this.coilMeta;
    }

    protected boolean cyclicUpdate_EM() {
        return false;
    }

    public final boolean addMiddleFluidHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            this.middleFluidHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.coilMeta = (short)-1;
        this.blocks = 0;
        return this.structureCheck_EM("main", 2, 1, 0) && this.blocks >= 18;
    }

    public final boolean addOutputFluidHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        return false;
    }

    public final boolean addInputFluidHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        return false;
    }

    public IStructureDefinition<TT_OilCrackingUnit> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new TT_OilCrackingUnit(this.mName);
    }

    public String[] getDescription() {
        return new String[]{"Controller Block for the Oil Cracking Unit", "Thermally cracks heavy hydrocarbons into lighter fractions", "Size(WxHxD): 5x3x3 (Hollow), Controller (Front center)", "Ring of 8 Coils (Each side of Controller)", "Gets 5% energy cost reduction per coil tier", "1x Hydrocarbon Input Bus/Hatch (Any left/right side casing)", "1x Steam/Hydrogen Input Hatch (Any middle ring casing)", "1x Cracked Hydrocarbon Output Hatch (Any left/right side casing)", "1x Maintenance Hatch (Any casing)", "1x Energy Hatch (Any casing)", "Clean Stainless Steel Machine Casings for the rest (18 at least!)", "Input/Output Hatches must be on opposite sides", BW_Tooltip_Reference.ADV_STR_CHECK};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "OilCrackingUnit.png");
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_MultiMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        ArrayList<FluidStack> tInputList = this.getStoredFluids();
        FluidStack[] tFluidInputs = tInputList.toArray(new FluidStack[0]);
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sCrakingRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluidInputs, new ItemStack[]{this.mInventory[1]});
        if (tRecipe != null && tRecipe.isRecipeInputEqual(true, tFluidInputs, new ItemStack[]{this.mInventory[1]})) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, this.getMaxInputVoltage());
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            this.mEUt = (int)((double)this.mEUt * Math.pow(0.95, this.coilMeta));
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
            return true;
        }
        return false;
    }

    public boolean isMachineBlockUpdateRecursive() {
        return true;
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            FluidStack tStack;
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!TT_OilCrackingUnit.isValidMetaTileEntity((MetaTileEntity)tHatch) || tHatch.getFillableStack() == null || (tStack = tHatch.getFillableStack()).isFluidEqual(GT_ModHandler.getSteam((long)1000L)) || tStack.isFluidEqual(Materials.Hydrogen.getGas(1000L))) continue;
            rList.add(tStack);
        }
        if (this.middleFluidHatch != null && TT_OilCrackingUnit.isValidMetaTileEntity((MetaTileEntity)this.middleFluidHatch) && this.middleFluidHatch.getFillableStack() != null) {
            this.middleFluidHatch.mRecipeMap = this.getRecipeMap();
            FluidStack tStack = this.middleFluidHatch.getFillableStack();
            if (tStack.isFluidEqual(GT_ModHandler.getSteam((long)1000L)) || tStack.isFluidEqual(Materials.Hydrogen.getGas(1000L))) {
                rList.add(tStack);
            }
        }
        return rList;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM("main", 2, 1, 0, b, itemStack);
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return new String[0];
    }
}

