/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement;

import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.crossmod.tectech.helper.CoilAdder;
import com.github.bartimaeusnek.crossmod.tectech.helper.IHasCoils;
import com.github.technus.tectech.mechanics.constructable.IConstructable;
import com.github.technus.tectech.mechanics.structure.IStructureDefinition;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import com.github.technus.tectech.mechanics.structure.StructureDefinition;
import com.github.technus.tectech.mechanics.structure.StructureUtility;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.google.common.collect.ImmutableSet;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TT_ElectronicBlastFurnace
extends GT_MetaTileEntity_MultiblockBase_EM
implements IHasCoils,
IConstructable {
    private short coilMeta = (short)-1;
    private static final byte TEXTURE_INDEX = 11;
    private static final IStructureDefinition<TT_ElectronicBlastFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"AAA", "AMA", "AAA"}, {"CCC", "C-C", "CCC"}, {"CCC", "C-C", "CCC"}, {"B~B", "BBB", "BBB"}})).addElement(Character.valueOf('C'), CoilAdder.getINSTANCE()).addElement(Character.valueOf('M'), (IStructureElement)StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicMufflerToMachineList, (int)11, (int)1)).addElement(Character.valueOf('A'), StructureUtility.ofHatchAdderOptional(TT_ElectronicBlastFurnace::addEBFInputsTop, (int)11, (Block)GregTech_API.sBlockCasings1, (int)11, (Block)GregTech_API.sBlockCasings1, (int)11)).addElement(Character.valueOf('B'), StructureUtility.ofHatchAdderOptional(TT_ElectronicBlastFurnace::addEBFInputsBottom, (int)11, (Block)GregTech_API.sBlockCasings1, (int)11, (Block)GregTech_API.sBlockCasings1, (int)11)).build();
    private static final Set<FluidStack> POLLUTION_FLUID_STACKS = ImmutableSet.of((Object)Materials.CarbonDioxide.getGas(1000L), (Object)Materials.CarbonMonoxide.getGas(1000L), (Object)Materials.SulfurDioxide.getGas(1000L));

    public TT_ElectronicBlastFurnace(Object unused) {
        super(32765, "multimachine.blastfurnace", "Electric Blast Furnace");
        GregTech_API.METATILEENTITIES[32765] = null;
        GregTech_API.METATILEENTITIES[1000] = this;
    }

    private TT_ElectronicBlastFurnace(String aName) {
        super(aName);
    }

    public IStructureDefinition<TT_ElectronicBlastFurnace> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        boolean ret;
        this.setCoilMeta((short)-1);
        boolean bl = ret = this.structureCheck_EM("main", 1, 3, 0) && this.getHeatingCapacity() > -1;
        if (this.mMufflerHatches.stream().map(MetaTileEntity::getBaseMetaTileEntity).mapToInt(ITurnable::getFrontFacing).noneMatch(x -> x == this.getExtendedFacing().getRelativeUpInWorld().ordinal())) {
            return false;
        }
        return ret;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM("main", 1, 3, 0, b, itemStack);
    }

    protected boolean cyclicUpdate_EM() {
        return false;
    }

    public final boolean addEBFInputsTop(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output)) {
            return false;
        }
        ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
    }

    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        FluidStack tLiquid = aLiquid.copy();
        if (POLLUTION_FLUID_STACKS.stream().anyMatch(arg_0 -> ((FluidStack)tLiquid).isFluidEqual(arg_0))) {
            tLiquid.amount = tLiquid.amount * (this.mMufflerHatches.stream().filter(GT_MetaTileEntity_MultiBlockBase::isValidMetaTileEntity).findFirst().map(tHatch -> 100 - tHatch.calculatePollutionReduction(100)).orElse(0) + 5) / 100;
        }
        for (GT_MetaTileEntity_Hatch_Output tHatch2 : this.mOutputHatches) {
            if ((!TT_ElectronicBlastFurnace.isValidMetaTileEntity((MetaTileEntity)tHatch2) || !GT_ModHandler.isSteam((FluidStack)aLiquid) ? !tHatch2.outputsLiquids() : !tHatch2.outputsSteam()) || tHatch2.getBaseMetaTileEntity().getYCoord() <= this.getBaseMetaTileEntity().getYCoord()) continue;
            int tAmount = tHatch2.fill(tLiquid, false);
            if (tAmount >= tLiquid.amount) {
                return tHatch2.fill(tLiquid, true) >= tLiquid.amount;
            }
            if (tAmount <= 0) continue;
            tLiquid.amount -= tHatch2.fill(tLiquid, true);
        }
        return false;
    }

    public final boolean addEBFInputsBottom(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch)) {
            return false;
        }
        ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            return this.eEnergyMulti.add((GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
            return this.eDynamoMulti.add((GT_MetaTileEntity_Hatch_DynamoMulti)aMetaTileEntity);
        }
        return false;
    }

    public String[] getDescription() {
        return new String[]{"Controller Block for the Blast Furnace", "Size(WxHxD): 3x4x3 (Hollow), Controller (Front middle bottom)", "16x Heating Coils (Two middle Layers, hollow)", "1x Input Hatch/Bus (Any bottom layer casing)", "1x Output Hatch/Bus (Any bottom layer casing)", "1x Energy Hatch (Any bottom layer casing)", "1x Maintenance Hatch (Any bottom layer casing)", "1x Muffler Hatch (Top middle)", "1x Output Hatch to recover CO2/CO/SO2 (optional, any top layer casing),", "    Recovery scales with Muffler Hatch tier", "Heat Proof Machine Casings for the rest", "Each 900K over the min. Heat Capacity multiplies eu/t by 0.95", "Each 1800K over the min. Heat Capacity allows for one upgraded overclock", "Upgraded overclocks reduce recipe time to 25% and increase EU/t to 400%", "Causes " + 20 * this.getPollutionPerTick(null) + " Pollution per second", BW_Tooltip_Reference.ADV_STR_CHECK};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "ElectricBlastFurnace.png");
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_MultiMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public void setCoilMeta(short coilMeta) {
        this.coilMeta = coilMeta;
    }

    @Override
    public short getCoilMeta() {
        return this.coilMeta;
    }

    private int getHeatingCapacity() {
        switch (this.coilMeta) {
            case 0: {
                return 1801;
            }
            case 1: {
                return 2701;
            }
            case 2: {
                return 3601;
            }
            case 3: {
                return 4501;
            }
            case 4: {
                return 5401;
            }
            case 5: {
                return 7201;
            }
            case 6: {
                return 9001;
            }
            case 7: {
                return 9901;
            }
            case 8: {
                return 10801;
            }
        }
        return -1;
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return new String[0];
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new TT_ElectronicBlastFurnace(this.mName);
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        ArrayList tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                if (((ItemStack)tInputList.get((int)i)).field_77994_a >= ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
        ArrayList tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block2: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual((FluidStack)((FluidStack)tFluidList.get(i)), (FluidStack)((FluidStack)tFluidList.get(j)))) continue;
                if (((FluidStack)tFluidList.get((int)i)).amount >= ((FluidStack)tFluidList.get((int)j)).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block2;
            }
        }
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[0]);
        if (tInputList.size() > 0) {
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            if (tRecipe == null || this.getHeatingCapacity() < tRecipe.mSpecialValue || !tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                return false;
            }
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            int tHeatCapacityDivTiers = (this.getHeatingCapacity() - tRecipe.mSpecialValue) / 900;
            byte overclockCount = this.calculateOverclockednessEBF(tRecipe.mEUt, tRecipe.mDuration, tVoltage);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            if (tHeatCapacityDivTiers > 0) {
                this.mEUt = (int)((double)this.mEUt * Math.pow(0.95, tHeatCapacityDivTiers));
                this.mMaxProgresstime >>= Math.min(tHeatCapacityDivTiers / 2, overclockCount);
                if (this.mMaxProgresstime < 1) {
                    this.mMaxProgresstime = 1;
                }
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
            this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
            this.updateSlots();
            return true;
        }
        return false;
    }

    protected byte calculateOverclockednessEBF(int aEUt, int aDuration, long maxInputVoltage) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier((long)maxInputVoltage));
        byte timesOverclocked = 0;
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = aEUt >> 2;
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgresstime = aDuration;
            while (tempEUt <= GT_Values.V[mTier - 1]) {
                tempEUt <<= 2;
                this.mMaxProgresstime >>= 1;
                xEUt = this.mMaxProgresstime == 0 ? xEUt >> 1 : xEUt << 2;
                timesOverclocked = (byte)(timesOverclocked + 1);
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = (int)xEUt;
                if (this.mEUt == 0) {
                    this.mEUt = 1;
                }
                if (this.mMaxProgresstime == 0) {
                    this.mMaxProgresstime = 1;
                }
            }
        }
        return timesOverclocked;
    }

    public boolean isMachineBlockUpdateRecursive() {
        return true;
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 20;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

