/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_ImplosionCompressor;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_TileEntity_ElectricImplosionCompressor
extends GT_MetaTileEntity_ImplosionCompressor {
    public static GT_Recipe.GT_Recipe_Map eicMap;
    private Boolean piston = null;

    public GT_TileEntity_ElectricImplosionCompressor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_ElectricImplosionCompressor(String aName) {
        super(aName);
    }

    public boolean checkRecipe(ItemStack aStack) {
        GT_Recipe tRecipe;
        if (((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0)).getEUVar() <= 0L || ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(1)).getEUVar() <= 0L) {
            return false;
        }
        ArrayList tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                if (((ItemStack)tInputList.get((int)i)).field_77994_a < ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                    tInputList.remove(i--);
                    tInputList_sS = tInputList.size();
                    continue block0;
                }
                tInputList.remove(j--);
                tInputList_sS = tInputList.size();
            }
        }
        ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
        if (tInputList.size() > 0 && (tRecipe = eicMap.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, tInputs)) != null && tRecipe.isRecipeInputEqual(true, null, tInputs)) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.mEUt = -tRecipe.mEUt;
            this.mMaxProgresstime = Math.max(1, tRecipe.mDuration);
            this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
            this.sendLoopStart((byte)20);
            this.updateSlots();
            return true;
        }
        return false;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mRuntime % 10 == 0) {
            this.togglePiston();
        }
        return super.onRunningTick(aStack);
    }

    public void stopMachine() {
        this.resetPiston();
        super.stopMachine();
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.piston == null) {
            this.piston = true;
        }
    }

    private void resetPiston() {
        if (this.getBaseMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        if (!this.piston.booleanValue()) {
            int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX;
            int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ;
            int aX = this.getBaseMetaTileEntity().getXCoord();
            short aY = this.getBaseMetaTileEntity().getYCoord();
            int aZ = this.getBaseMetaTileEntity().getZCoord();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                    this.getBaseMetaTileEntity().getWorld().func_147465_d(xDir + aX + x, aY + 2, zDir + aZ + z, GregTech_API.sBlockMetal5, 2, 3);
                }
            }
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(5)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
            this.piston = this.piston == false;
        }
    }

    private void togglePiston() {
        if (this.getBaseMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ;
        int aX = this.getBaseMetaTileEntity().getXCoord();
        short aY = this.getBaseMetaTileEntity().getYCoord();
        int aZ = this.getBaseMetaTileEntity().getZCoord();
        boolean hax = false;
        if (this.piston.booleanValue()) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                    if (this.getBaseMetaTileEntity().getBlock(xDir + aX + x, aY + 2, zDir + aZ + z) != GregTech_API.sBlockMetal5 && this.getBaseMetaTileEntity().getMetaID(xDir + aX + x, aY + 2, zDir + aZ + z) != 2) {
                        hax = true;
                    }
                    this.getBaseMetaTileEntity().getWorld().func_147468_f(xDir + aX + x, aY + 2, zDir + aZ + z);
                }
            }
        } else {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                    this.getBaseMetaTileEntity().getWorld().func_147465_d(xDir + aX + x, aY + 2, zDir + aZ + z, GregTech_API.sBlockMetal5, 2, 3);
                }
            }
        }
        GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(5)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        this.piston = this.piston == false;
        if (hax) {
            this.explodeMultiblock();
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("piston", this.piston.booleanValue());
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.piston = aNBT.func_74767_n("piston");
        super.loadNBTData(aNBT);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -2; y < 7; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    byte tMeta;
                    Block tBlock;
                    IGregTechTileEntity te = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, z + zDir);
                    if (y == -2 || y == 6) {
                        if (x != 0 || z != 0) {
                            if (this.addMaintenanceToMachineList(te, 16) || this.addInputToMachineList(te, 16) || this.addOutputToMachineList(te, 16)) continue;
                            tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z);
                            tMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z);
                            if (tBlock == GregTech_API.sBlockCasings2 && tMeta == 0 || tBlock == GregTech_API.sBlockCasings3 && tMeta == 4) continue;
                            return false;
                        }
                        if (x != 0 || z != 0) continue;
                        if (y == -2 && !this.addEnergyInputToMachineList(te, 16)) {
                            return false;
                        }
                        if (y != 6 || this.addEnergyInputToMachineList(te, 16)) continue;
                        return false;
                    }
                    if (y > -2 && y < 1 || y > 3 && y < 6) {
                        if (y == 0 && xDir + x == 0 && zDir + z == 0) continue;
                        tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z);
                        tMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z);
                        if (!(x == 0 && z == 0 ? tBlock != ItemRegistry.BW_BLOCKS[2] || tMeta != 0 : tBlock != ItemRegistry.BW_BLOCKS[2] || tMeta != 1)) continue;
                        return false;
                    }
                    if (!(y == 1 ? !GT_Utility.areStacksEqual((ItemStack)new ItemStack(aBaseMetaTileEntity.getBlockOffset(xDir + x, 1, zDir + z), 1, (int)aBaseMetaTileEntity.getMetaIDOffset(xDir + x, 1, zDir + z)), (ItemStack)Materials.Neutronium.getBlocks(1)) : (y == 2 ? (this.piston == false ? Math.abs(x) == 1 && Math.abs(z) == 1 && !GT_Utility.areStacksEqual((ItemStack)new ItemStack(aBaseMetaTileEntity.getBlockOffset(xDir + x, 2, zDir + z), 1, (int)aBaseMetaTileEntity.getMetaIDOffset(xDir + x, 2, zDir + z)), (ItemStack)Materials.Neutronium.getBlocks(1)) : !GT_Utility.areStacksEqual((ItemStack)new ItemStack(aBaseMetaTileEntity.getBlockOffset(xDir + x, 2, zDir + z), 1, (int)aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z)), (ItemStack)Materials.Neutronium.getBlocks(1))) : y == 3 && !GT_Utility.areStacksEqual((ItemStack)new ItemStack(aBaseMetaTileEntity.getBlockOffset(xDir + x, 3, zDir + z), 1, (int)aBaseMetaTileEntity.getMetaIDOffset(xDir + x, 3, zDir + z)), (ItemStack)Materials.Neutronium.getBlocks(1))))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_ElectricImplosionCompressor(this.mName);
    }

    public String[] getDescription() {
        return BW_Tooltip_Reference.getTranslatedBrandedTooltip("tooltip.tile.eic.0.name");
    }
}

