/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.neiHandler;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.github.bartimaeusnek.bartworks.neiHandler.NEI_BW_Config;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Ores;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_SmallOres;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.oregen.BW_OreLayer;
import com.github.bartimaeusnek.bartworks.system.oregen.BW_WorldGenRoss128b;
import com.github.bartimaeusnek.bartworks.system.oregen.BW_WorldGenRoss128ba;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregtech.api.enums.OrePrefixes;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BW_NEI_OreHandler
extends TemplateRecipeHandler {
    public BW_NEI_OreHandler() {
        if (!NEI_BW_Config.sIsAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)"bartworks", (String)"NEIPlugins", (String)"register-crafting-handler", (String)("bartworks@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
        }
    }

    public void drawBackground(int recipe) {
        GuiDraw.drawRect((int)0, (int)0, (int)166, (int)65, (int)0x888888);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(0, 40, 40, 120), "quickanddirtyneihandler", new Object[0]));
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equalsIgnoreCase("quickanddirtyneihandler")) {
            HashSet result = new HashSet();
            Werkstoff.werkstoffHashSet.stream().filter(w -> w.getGenerationFeatures().hasOres()).forEach(w -> result.add(w.get(OrePrefixes.ore)));
            result.forEach(this::loadCraftingRecipes);
            result.clear();
            Werkstoff.werkstoffHashSet.stream().filter(w -> w.getGenerationFeatures().hasOres()).forEach(w -> result.add(w.get(OrePrefixes.oreSmall)));
            result.forEach(this::loadCraftingRecipes);
            result.clear();
            HashSet hashSet = new HashSet(this.arecipes);
            this.arecipes.clear();
            this.arecipes.addAll(hashSet);
        }
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
            HashSet hashSet = new HashSet(this.arecipes);
            this.arecipes.clear();
            this.arecipes.addAll(hashSet);
        }
    }

    public void drawExtras(int recipe) {
        if (recipe < this.arecipes.size() && this.arecipes.get(recipe) instanceof CachedOreRecipe) {
            CachedOreRecipe cachedOreRecipe = (CachedOreRecipe)((Object)this.arecipes.get(recipe));
            if (cachedOreRecipe == null || cachedOreRecipe.getOtherStacks() == null || cachedOreRecipe.getOtherStacks().size() == 0) {
                return;
            }
            if (!cachedOreRecipe.small ? cachedOreRecipe.getOtherStacks().get(0) == null || cachedOreRecipe.getOtherStacks().get((int)0).item == null || cachedOreRecipe.getOtherStacks().get(1) == null || cachedOreRecipe.getOtherStacks().get(2) == null || cachedOreRecipe.getOtherStacks().get(3) == null || cachedOreRecipe.getOtherStacks().get((int)1).item == null || cachedOreRecipe.getOtherStacks().get((int)2).item == null || cachedOreRecipe.getOtherStacks().get((int)3).item == null : cachedOreRecipe.getOtherStacks().get(0) == null || cachedOreRecipe.getOtherStacks().get((int)0).item == null) {
                return;
            }
            if (cachedOreRecipe.worldGen != null) {
                GuiDraw.drawString((String)("\u00a7lDIM: \u00a7r" + cachedOreRecipe.worldGen.getDimName()), (int)0, (int)40, (int)0, (boolean)false);
            }
            GuiDraw.drawString((String)"\u00a7lPrimary:", (int)0, (int)50, (int)0, (boolean)false);
            GuiDraw.drawString((String)cachedOreRecipe.getOtherStacks().get((int)0).item.func_82833_r(), (int)0, (int)60, (int)0, (boolean)false);
            if (!cachedOreRecipe.small) {
                GuiDraw.drawString((String)"\u00a7lSecondary:", (int)0, (int)70, (int)0, (boolean)false);
                GuiDraw.drawString((String)cachedOreRecipe.getOtherStacks().get((int)1).item.func_82833_r(), (int)0, (int)80, (int)0, (boolean)false);
                GuiDraw.drawString((String)"\u00a7lInBetween:", (int)0, (int)90, (int)0, (boolean)false);
                GuiDraw.drawString((String)cachedOreRecipe.getOtherStacks().get((int)2).item.func_82833_r(), (int)0, (int)100, (int)0, (boolean)false);
                GuiDraw.drawString((String)"\u00a7lSporadic:", (int)0, (int)110, (int)0, (boolean)false);
                GuiDraw.drawString((String)cachedOreRecipe.getOtherStacks().get((int)3).item.func_82833_r(), (int)0, (int)120, (int)0, (boolean)false);
            } else if (cachedOreRecipe.worldGen != null) {
                GuiDraw.drawString((String)"\u00a7lAmount per Chunk:", (int)0, (int)70, (int)0, (boolean)false);
                GuiDraw.drawString((String)(cachedOreRecipe.worldGen.mDensity + ""), (int)0, (int)80, (int)0, (boolean)false);
            }
        }
        super.drawExtras(recipe);
    }

    public void loadCraftingRecipes(ItemStack result) {
        Block ore = Block.func_149634_a((Item)result.func_77973_b());
        if (ore instanceof BW_MetaGenerated_Ores) {
            BW_OreLayer.NEIMAP.get((Object)((short)result.func_77960_j())).stream().filter(l -> !(ore instanceof BW_MetaGenerated_SmallOres) || !((Object)l).getClass().equals(BW_WorldGenRoss128b.class) && !((Object)l).getClass().equals(BW_WorldGenRoss128ba.class)).forEach(l -> this.arecipes.add(new CachedOreRecipe((BW_OreLayer)((Object)l), result, ore instanceof BW_MetaGenerated_SmallOres)));
        }
    }

    public String getGuiTexture() {
        return "textures/gui/container/brewing_stand.png";
    }

    public String getRecipeName() {
        return "BartWorks Ores";
    }

    class CachedOreRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        boolean small;
        BW_OreLayer worldGen;
        PositionedStack stack;

        public CachedOreRecipe(BW_OreLayer worldGen, ItemStack result, boolean smallOres) {
            super((TemplateRecipeHandler)BW_NEI_OreHandler.this);
            this.worldGen = worldGen;
            this.stack = new PositionedStack((Object)result, 0, 0);
            this.small = smallOres;
        }

        public PositionedStack getResult() {
            return this.stack;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            int x = 0;
            for (int i = 0; i < (this.small ? 1 : 4); ++i) {
                ret.add(new PositionedStack((Object)this.worldGen.getStacks().get(i), x += 20, 12));
            }
            return ret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CachedOreRecipe)) {
                return false;
            }
            CachedOreRecipe that = (CachedOreRecipe)((Object)o);
            return Objects.equals((Object)this.worldGen, (Object)that.worldGen);
        }

        public int hashCode() {
            return this.worldGen.hashCode();
        }
    }
}

