/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement;

import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.crossmod.tectech.helper.CoilAdder;
import com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement.TT_Abstract_GT_Replacement_Coils;
import com.github.technus.tectech.mechanics.structure.IStructureDefinition;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import com.github.technus.tectech.mechanics.structure.StructureDefinition;
import com.github.technus.tectech.mechanics.structure.StructureUtility;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TT_OilCrackingUnit
extends TT_Abstract_GT_Replacement_Coils {
    private byte blocks = 0;
    private static final byte TEXTURE_INDEX = 49;
    private static final IStructureDefinition<TT_OilCrackingUnit> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"EBGBF", "EBGBF", "EBGBF"}, {"EB~BF", "E---F", "EBGBF"}, {"EBGBF", "EBGBF", "EBGBF"}})).addElement(Character.valueOf('B'), CoilAdder.getINSTANCE()).addElement(Character.valueOf('E'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofHatchAdder(TT_OilCrackingUnit::addInputFluidHatch, (int)49, (int)1), StructureUtility.onElementPass(x -> {
        x.blocks = (byte)(x.blocks + 1);
    }, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)), StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicMaintenanceToMachineList, (int)49, (int)1), StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addEnergyIOToMachineList, (int)49, (int)1)})).addElement(Character.valueOf('F'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofHatchAdder(TT_OilCrackingUnit::addOutputFluidHatch, (int)49, (int)2), StructureUtility.onElementPass(x -> {
        x.blocks = (byte)(x.blocks + 1);
    }, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)), StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicMaintenanceToMachineList, (int)49, (int)1), StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addEnergyIOToMachineList, (int)49, (int)1)})).addElement(Character.valueOf('G'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofHatchAdder(TT_OilCrackingUnit::addMiddleFluidHatch, (int)49, (int)3), StructureUtility.onElementPass(x -> {
        x.blocks = (byte)(x.blocks + 1);
    }, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)), StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicMaintenanceToMachineList, (int)49, (int)1), StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addEnergyIOToMachineList, (int)49, (int)1)})).build();
    private static final String[] sfStructureDescription = new String[]{"0 - Air", "1 - Input Hatch", "2 - Output Hatch", "3 - 1x Input Hatch, rest Casings, Maintenance Hatch or Energy Hatch", "Required: Maintenance Hatch, Energy Hatch, at Position 3 or instead of Casings", "18 Casings at least!"};
    private GT_MetaTileEntity_Hatch_Input middleFluidHatch;
    private static final String[] desc = new String[]{"Cracker", "Controller block for the Oil Cracking Unit", "Thermally cracks heavy hydrocarbons into lighter fractions", "More efficient than the Chemical Reactor", "Place the appropriate circuit in the controller", "Gets 5% energy cost reduction per coil tier", BW_Tooltip_Reference.ADV_STR_CHECK, BW_Tooltip_Reference.TT_BLUEPRINT};

    public TT_OilCrackingUnit(Object unused, Object unused2) {
        super(1160, "multimachine.cracker", "Oil Cracking Unit");
    }

    private TT_OilCrackingUnit(String aName) {
        super(aName);
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return sfStructureDescription;
    }

    public final boolean addMiddleFluidHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            this.middleFluidHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.setCoilHeat(HeatingCoilLevel.None);
        this.blocks = 0;
        boolean ret = this.structureCheck_EM("main", 2, 1, 0);
        this.setInputFilters();
        return ret && this.blocks >= 18;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sCrakingRecipes;
    }

    public final boolean addOutputFluidHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        return false;
    }

    public final boolean addInputFluidHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        return false;
    }

    public IStructureDefinition<TT_OilCrackingUnit> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new TT_OilCrackingUnit(this.mName);
    }

    public String[] getDescription() {
        return desc;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        ArrayList<FluidStack> tInputList = this.getStoredFluids();
        FluidStack[] tFluidInputs = tInputList.toArray(new FluidStack[0]);
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sCrakingRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluidInputs, new ItemStack[]{this.mInventory[1]});
        if (tRecipe == null || !tRecipe.isRecipeInputEqual(true, tFluidInputs, new ItemStack[]{this.mInventory[1]})) {
            return false;
        }
        this.setEfficiencyAndOc(tRecipe);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        this.mEUt = (int)((double)this.mEUt * Math.pow(0.95, this.getCoilHeat().getTier()));
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
        return true;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            FluidStack tStack;
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!TT_OilCrackingUnit.isValidMetaTileEntity((MetaTileEntity)tHatch) || tHatch.getFillableStack() == null || (tStack = tHatch.getFillableStack()).isFluidEqual(GT_ModHandler.getSteam((long)1000L)) || tStack.isFluidEqual(Materials.Hydrogen.getGas(1000L))) continue;
            rList.add(tStack);
        }
        if (this.middleFluidHatch == null || !TT_OilCrackingUnit.isValidMetaTileEntity((MetaTileEntity)this.middleFluidHatch) || this.middleFluidHatch.getFillableStack() == null) {
            return rList;
        }
        this.middleFluidHatch.mRecipeMap = this.getRecipeMap();
        FluidStack tStack = this.middleFluidHatch.getFillableStack();
        rList.add(tStack);
        return rList;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM("main", 2, 1, 0, b, itemStack);
    }
}

