/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement;

import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.crossmod.tectech.helper.StructureDefinitions;
import com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement.TT_Abstract_GT_Replacement;
import com.github.technus.tectech.mechanics.structure.IStructureDefinition;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import com.github.technus.tectech.mechanics.structure.StructureDefinition;
import com.github.technus.tectech.mechanics.structure.StructureUtility;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.google.common.collect.ArrayListMultimap;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TT_ImplosionCompressor
extends TT_Abstract_GT_Replacement {
    private byte blocks = 0;
    private static final byte TEXTURE_INDEX = 16;
    private static final byte SOUND_INDEX = 20;
    private static final ArrayListMultimap<Block, Integer> BLOCKS = ArrayListMultimap.create();
    private static final IStructureDefinition<TT_ImplosionCompressor> STRUCTURE_DEFINITION;
    private static final int pollutionPerTick = 500;
    private static final String[] desc;
    private static final String[] sfStructureDescription;

    public TT_ImplosionCompressor(Object unused, Object unused2) {
        super(1001, "multimachine.implosioncompressor", "Implosion Compressor");
    }

    private TT_ImplosionCompressor(String aName) {
        super(aName);
    }

    public final boolean addImplosionHatches(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch)) {
            return false;
        }
        ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            return this.eEnergyMulti.add((GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
            return this.eDynamoMulti.add((GT_MetaTileEntity_Hatch_DynamoMulti)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        return false;
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.blocks = 0;
        boolean ret = this.structureCheck_EM("main", 1, 1, 0) && this.blocks >= 16;
        this.mMufflerHatches.forEach(x -> x.setInValidFacings(new ForgeDirection[]{this.getExtendedFacing().getRelativeUpInWorld().getOpposite()}));
        if (this.mMufflerHatches.stream().map(MetaTileEntity::getBaseMetaTileEntity).mapToInt(ITurnable::getFrontFacing).noneMatch(x -> x == this.getExtendedFacing().getRelativeUpInWorld().ordinal())) {
            return false;
        }
        this.setInputFilters();
        return ret;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sImplosionRecipes;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM("main", 1, 1, 0, b, itemStack);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new TT_ImplosionCompressor(this.mName);
    }

    public String[] getDescription() {
        return desc;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16]};
    }

    public IStructureDefinition<TT_ImplosionCompressor> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        ArrayList tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                if (((ItemStack)tInputList.get((int)i)).field_77994_a >= ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
        if (tInputList.size() <= 0) {
            return false;
        }
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sImplosionRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, tInputs);
        if (tRecipe == null || !tRecipe.isRecipeInputEqual(true, null, tInputs)) {
            return false;
        }
        this.setEfficiencyAndOc(tRecipe);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
        this.sendLoopStart((byte)20);
        this.updateSlots();
        return true;
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 20) {
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(5)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 500;
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return sfStructureDescription;
    }

    static {
        BLOCKS.put((Object)GregTech_API.sBlockCasings2, (Object)0);
        BLOCKS.put((Object)GregTech_API.sBlockCasings3, (Object)4);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureDefinitions.CUBE_NO_MUFFLER.getDefinition()).addElement(Character.valueOf('V'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(x -> {
            x.blocks = (byte)(x.blocks + 1);
        }, (IStructureElement)StructureUtility.ofBlocksMap((Map)BLOCKS.asMap(), (Block)GregTech_API.sBlockCasings2, (int)0)), StructureUtility.ofHatchAdder(TT_ImplosionCompressor::addImplosionHatches, (int)16, (int)1)})).build();
        desc = new String[]{"Implosion Compressor", "Explosions are fun", "Controller block for the Implosion Compressor", "Creates up to: 10000 Pollution per Second", BW_Tooltip_Reference.ADV_STR_CHECK, BW_Tooltip_Reference.TT_BLUEPRINT};
        sfStructureDescription = new String[]{"0 - Air", "Required: Muffler Hatch, Output Bus, Input Bus, Energy Hatch, Maintenance Hatch", "16 Casings at least!"};
    }
}

