/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement;

import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.crossmod.tectech.helper.CoilAdder;
import com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement.TT_Abstract_GT_Replacement;
import com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement.TT_Abstract_GT_Replacement_Coils;
import com.github.technus.tectech.mechanics.structure.IStructureDefinition;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import com.github.technus.tectech.mechanics.structure.StructureDefinition;
import com.github.technus.tectech.mechanics.structure.StructureUtility;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.google.common.collect.ImmutableSet;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class TT_ElectronicBlastFurnace
extends TT_Abstract_GT_Replacement_Coils {
    private int mHeatingCapacity = 0;
    private static final byte TEXTURE_INDEX = 11;
    private static final IStructureDefinition<TT_ElectronicBlastFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"AAA", "AMA", "AAA"}, {"CCC", "C-C", "CCC"}, {"CCC", "C-C", "CCC"}, {"B~B", "BBB", "BBB"}})).addElement(Character.valueOf('C'), CoilAdder.getINSTANCE()).addElement(Character.valueOf('M'), (IStructureElement)StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicMufflerToMachineList, (int)11, (int)1)).addElement(Character.valueOf('A'), StructureUtility.ofHatchAdderOptional(TT_ElectronicBlastFurnace::addEBFInputsTop, (int)11, (Block)GregTech_API.sBlockCasings1, (int)11, (Block)GregTech_API.sBlockCasings1, (int)11)).addElement(Character.valueOf('B'), StructureUtility.ofHatchAdderOptional(TT_Abstract_GT_Replacement::addEBFInputsBottom, (int)11, (Block)GregTech_API.sBlockCasings1, (int)11, (Block)GregTech_API.sBlockCasings1, (int)11)).build();
    private static final Set<FluidStack> POLLUTION_FLUID_STACKS = ImmutableSet.of((Object)Materials.CarbonDioxide.getGas(1000L), (Object)Materials.CarbonMonoxide.getGas(1000L), (Object)Materials.SulfurDioxide.getGas(1000L));
    private static final int pollutionPerTick = 20;
    private static final String[] desc = new String[]{"Blast Furnace", "Controller block for the Electric Blast Furnace", "You can use some fluids to reduce recipe time. Place the circuit in the Input Bus", "Each 900K over the min. Heat required multiplies EU/t by 0.95", "Each 1800K over the min. Heat required allows for one upgraded overclock instead of normal", "Upgraded overclocks reduce recipe time to 25% (instead of 50%) and increase EU/t to 400%", "Additionally gives +100K for every tier past MV", "Creates up to: 400 Pollution per Second", BW_Tooltip_Reference.ADV_STR_CHECK, BW_Tooltip_Reference.TT_BLUEPRINT};
    private static final String[] sfStructureDescription = new String[]{"0 - Air", "1 - Muffler", "Required: Output Bus, Input Bus, Energy Hatch, Maintenance Hatch", "Optional: Input Hatch, Output Hatch at Bottom, Output Hatch at top to regain CO/CO2/SO2"};

    public TT_ElectronicBlastFurnace(Object unused, Object unused2) {
        super(1000, "multimachine.blastfurnace", "Electric Blast Furnace");
    }

    private TT_ElectronicBlastFurnace(String aName) {
        super(aName);
    }

    public IStructureDefinition<TT_ElectronicBlastFurnace> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.mHeatingCapacity = 0;
        this.setCoilHeat(HeatingCoilLevel.None);
        boolean ret = this.structureCheck_EM("main", 1, 3, 0) && this.getCoilHeat() != HeatingCoilLevel.None;
        this.mMufflerHatches.forEach(x -> x.setInValidFacings(new ForgeDirection[]{this.getExtendedFacing().getRelativeUpInWorld().getOpposite()}));
        if (this.mMufflerHatches.stream().map(MetaTileEntity::getBaseMetaTileEntity).mapToInt(ITurnable::getFrontFacing).noneMatch(x -> x == this.getExtendedFacing().getRelativeUpInWorld().ordinal())) {
            return false;
        }
        this.mHeatingCapacity = (int)this.getCoilHeat().getHeat();
        this.mHeatingCapacity += 100 * (GT_Utility.getTier((long)this.getMaxInputVoltage()) - 2);
        this.setInputFilters();
        return ret;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sBlastRecipes;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM("main", 1, 3, 0, b, itemStack);
    }

    public final boolean addEBFInputsTop(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output)) {
            return false;
        }
        ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
    }

    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        FluidStack tLiquid = aLiquid.copy();
        if (POLLUTION_FLUID_STACKS.stream().anyMatch(arg_0 -> ((FluidStack)tLiquid).isFluidEqual(arg_0))) {
            tLiquid.amount = tLiquid.amount * (this.mMufflerHatches.stream().filter(GT_MetaTileEntity_MultiBlockBase::isValidMetaTileEntity).findFirst().map(tHatch -> 100 - tHatch.calculatePollutionReduction(100)).orElse(0) + 5) / 100;
            for (GT_MetaTileEntity_Hatch_Output tHatch2 : this.mOutputHatches) {
                if (!TT_ElectronicBlastFurnace.isValidMetaTileEntity((MetaTileEntity)tHatch2) || !GT_ModHandler.isSteam((FluidStack)aLiquid) ? !tHatch2.outputsLiquids() : !tHatch2.outputsSteam()) continue;
                if (tHatch2.getBaseMetaTileEntity().getYCoord() <= this.getBaseMetaTileEntity().getYCoord() || this.canNotFillOutput(tHatch2, tLiquid)) continue;
                return true;
            }
        } else {
            for (GT_MetaTileEntity_Hatch_Output tHatch3 : this.mOutputHatches) {
                if (!TT_ElectronicBlastFurnace.isValidMetaTileEntity((MetaTileEntity)tHatch3) || !GT_ModHandler.isSteam((FluidStack)aLiquid) ? !tHatch3.outputsLiquids() : !tHatch3.outputsSteam()) continue;
                if (tHatch3.getBaseMetaTileEntity().getYCoord() > this.getBaseMetaTileEntity().getYCoord() || this.canNotFillOutput(tHatch3, tLiquid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canNotFillOutput(GT_MetaTileEntity_Hatch_Output tHatch, FluidStack tLiquid) {
        int tAmount = tHatch.fill(tLiquid, false);
        if (tAmount >= tLiquid.amount) {
            return tHatch.fill(tLiquid, true) < tLiquid.amount;
        }
        if (tAmount > 0) {
            tLiquid.amount -= tHatch.fill(tLiquid, true);
        }
        return true;
    }

    public String[] getDescription() {
        return desc;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new TT_ElectronicBlastFurnace(this.mName);
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        ItemStack[] tInputs = this.getCompactedInputs();
        FluidStack[] tFluids = this.getCompactedFluids();
        if (tInputs.length <= 0) {
            return false;
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
        if (tRecipe == null || this.mHeatingCapacity < tRecipe.mSpecialValue || !tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
            return false;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        int tHeatCapacityDivTiers = (this.mHeatingCapacity - tRecipe.mSpecialValue) / 900;
        byte overclockCount = this.calculateOverclockednessEBF(tRecipe.mEUt, tRecipe.mDuration, tVoltage);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        if (tHeatCapacityDivTiers > 0) {
            this.mEUt = (int)((double)this.mEUt * Math.pow(0.95, tHeatCapacityDivTiers));
            this.mMaxProgresstime >>= Math.min(tHeatCapacityDivTiers / 2, overclockCount);
            if (this.mMaxProgresstime < 1) {
                this.mMaxProgresstime = 1;
            }
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
        this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
        this.updateSlots();
        return true;
    }

    protected byte calculateOverclockednessEBF(int aEUt, int aDuration, long maxInputVoltage) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier((long)maxInputVoltage));
        byte timesOverclocked = 0;
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = aEUt >> 2;
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgresstime = aDuration;
            while (tempEUt <= GT_Values.V[mTier - 1]) {
                tempEUt <<= 2;
                this.mMaxProgresstime >>= 1;
                xEUt = this.mMaxProgresstime == 0 ? xEUt >> 1 : xEUt << 2;
                timesOverclocked = (byte)(timesOverclocked + 1);
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = (int)xEUt;
                if (this.mEUt == 0) {
                    this.mEUt = 1;
                }
                if (this.mMaxProgresstime == 0) {
                    this.mMaxProgresstime = 1;
                }
            }
        }
        return timesOverclocked;
    }

    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!TT_ElectronicBlastFurnace.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!TT_ElectronicBlastFurnace.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + this.mProgresstime / 20 + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + storedEnergy + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + maxEnergy + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + -this.mEUt + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + this.getMaxInputVoltage() + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier((long)this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.EBF.heat") + ": " + EnumChatFormatting.GREEN + this.mHeatingCapacity + EnumChatFormatting.RESET + " K", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 20;
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return sfStructureDescription;
    }
}

