/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement;

import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement.TT_Abstract_GT_Replacement;
import com.github.technus.tectech.mechanics.structure.IStructureDefinition;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import com.github.technus.tectech.mechanics.structure.StructureDefinition;
import com.github.technus.tectech.mechanics.structure.StructureUtility;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BW_TT_HeatExchanger
extends TT_Abstract_GT_Replacement {
    public static float penalty_per_config = 0.015f;
    private GT_MetaTileEntity_Hatch_Input mInputHotFluidHatch;
    private GT_MetaTileEntity_Hatch_Output mOutputColdFluidHatch;
    private boolean superheated = false;
    private int superheated_threshold = 0;
    private float water;
    private byte blocks = 0;
    private static final byte TEXTURE_INDEX = 50;
    private static final byte SOLID_CASING_META = 2;
    private static final byte PIPE_CASING_META = 14;
    private static final IStructureDefinition<BW_TT_HeatExchanger> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"AAA", "ACA", "AAA"}, {"AAA", "ABA", "AAA"}, {"AAA", "ABA", "AAA"}, {"A~A", "ADA", "AAA"}})).addElement(Character.valueOf('A'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicToMachineList, (int)50, (Block)GregTech_API.sBlockCasings4, (int)2), StructureUtility.onElementPass(x -> {
        x.blocks = (byte)(x.blocks + 1);
    }, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)2))})).addElement(Character.valueOf('B'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)14, (Block)GregTech_API.sBlockCasings2, (int)14)).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofHatchAdder(BW_TT_HeatExchanger::addColdFluidOutputToMachineList, (int)50, (int)1)).addElement(Character.valueOf('D'), (IStructureElement)StructureUtility.ofHatchAdder(BW_TT_HeatExchanger::addHotFluidInputToMachineList, (int)50, (int)2)).build();
    private static final String[] desc = new String[]{"Heat Exchanger", "Controller Block for the Large Heat Exchanger", "Inputs are Hot Fluids and Distilled Water", "Outputs Cold Fluids and SH Steam/Steam", "Requires an additional Input and Output Hatch anywhere!", BW_Tooltip_Reference.ADV_STR_CHECK, BW_Tooltip_Reference.TT_BLUEPRINT};
    Materials last = null;
    private static final String[] sfStructureDescription = new String[]{"1 - Cold Fluid Output", "2 - Hot Fluid Input", "Needs an additional Output Hatch", "Needs an additional Input Hatch", "20 Casings at least!"};

    public BW_TT_HeatExchanger(Object unused, Object unused2) {
        super(1154, "multimachine.heatexchanger", "Large Heat Exchanger");
    }

    public BW_TT_HeatExchanger(String aName) {
        super(aName);
    }

    public IStructureDefinition<BW_TT_HeatExchanger> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.blocks = 0;
        return this.structureCheck_EM("main", 1, 3, 0) && this.blocks >= 20;
    }

    public String[] getDescription() {
        return desc;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.superheated = aNBT.func_74767_n("superheated");
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("superheated", this.superheated);
        super.saveNBTData(aNBT);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.of((ITexture[])new ITexture[]{aActive ? TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW}).glow().build()}) : TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW}).glow().build()})})};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50]};
    }

    private void checkRecipeClassic(float efficiency) {
        int fluidAmountToConsume = this.mInputHotFluidHatch.getFluidAmount();
        float steam_output_multiplier = 20.0f;
        boolean do_lava = false;
        if (GT_ModHandler.isLava((FluidStack)this.mInputHotFluidHatch.getFluid())) {
            steam_output_multiplier /= 5.0f;
            this.superheated_threshold = (int)((float)this.superheated_threshold / 4.0f);
            do_lava = true;
        } else if (this.mInputHotFluidHatch.getFluid().isFluidEqual(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)1))) {
            steam_output_multiplier /= 2.0f;
            this.superheated_threshold = (int)((float)this.superheated_threshold / 5.0f);
        }
        this.superheated = fluidAmountToConsume >= this.superheated_threshold;
        fluidAmountToConsume = Math.min(fluidAmountToConsume, this.superheated_threshold * 2);
        this.mInputHotFluidHatch.drain(fluidAmountToConsume, true);
        this.mMaxProgresstime = 20;
        this.mEUt = (int)((float)fluidAmountToConsume * steam_output_multiplier * efficiency);
        if (do_lava) {
            this.mOutputColdFluidHatch.fill(FluidRegistry.getFluidStack((String)"ic2pahoehoelava", (int)fluidAmountToConsume), true);
        } else {
            this.mOutputColdFluidHatch.fill(FluidRegistry.getFluidStack((String)"ic2coolant", (int)fluidAmountToConsume), true);
        }
        this.mEfficiencyIncrease = 80;
    }

    private void checkRecipe_Additions(float efficiency) {
        Materials m = null;
        if (this.last != null && this.mInputHotFluidHatch.getFluid().isFluidEqual(this.last.getPlasma(1L))) {
            m = this.last;
        } else {
            for (Materials materials : Materials.values()) {
                if (this.mInputHotFluidHatch.getFluid().isFluidEqual(materials.getPlasma(1L))) {
                    this.last = m = materials;
                    break;
                }
                if (!this.mInputHotFluidHatch.getFluid().isFluidEqual(materials.getMolten(1L))) continue;
                GT_Log.exp.println(this.mName + " had Molten Metal Injected!");
                this.explodeMultiblock();
                return;
            }
        }
        if (m == null) {
            return;
        }
        int heat = this.getFuelValue(this.mInputHotFluidHatch.getFluid(), (int)(100.0f * efficiency));
        this.superheated_threshold = (int)((float)this.superheated_threshold / 4.0f);
        this.superheated = heat >= this.superheated_threshold;
        this.mInputHotFluidHatch.drain(1, true);
        this.mMaxProgresstime = 20;
        this.mEUt = heat;
        this.mOutputColdFluidHatch.fill(m.getMolten(1L), true);
        this.mEfficiencyIncrease = 80;
    }

    private int getFuelValue(FluidStack aLiquid, int efficency) {
        if (aLiquid == null || this.getRecipes() == null) {
            return 0;
        }
        Collection tRecipeList = this.getRecipes().mRecipeList;
        if (tRecipeList == null) {
            return 0;
        }
        for (GT_Recipe tFuel : tRecipeList) {
            FluidStack tLiquid = GT_Utility.getFluidForFilledItem((ItemStack)tFuel.getRepresentativeInput(0), (boolean)true);
            if (tLiquid == null || !aLiquid.isFluidEqual(tLiquid)) continue;
            long val = (long)tFuel.mSpecialValue * (long)efficency / 100L;
            if (val > Integer.MAX_VALUE) {
                throw new ArithmeticException("Integer LOOPBACK!");
            }
            return (int)val;
        }
        return 0;
    }

    private GT_Recipe.GT_Recipe_Map getRecipes() {
        return GT_Recipe.GT_Recipe_Map.sPlasmaFuels;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        if (this.mInputHotFluidHatch.getFluid() == null) {
            return true;
        }
        FluidStack fluid = this.mInputHotFluidHatch.getFluid();
        this.superheated_threshold = 4000;
        float efficiency = this.calculateEfficiency();
        if (GT_ModHandler.isLava((FluidStack)fluid) || fluid.isFluidEqual(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)1))) {
            this.checkRecipeClassic(efficiency);
        } else {
            this.checkRecipe_Additions(efficiency);
        }
        return true;
    }

    private float calculateEfficiency() {
        float defaultEff = 1.0f;
        int shs_reduction_per_config = 150;
        if (this.mInventory[1] == null || this.mInventory[1].func_77973_b() != GT_Utility.getIntegratedCircuit((int)0).func_77973_b()) {
            return defaultEff;
        }
        int circuit_config = this.mInventory[1].func_77960_j();
        if (circuit_config < 1 || circuit_config > 25) {
            return defaultEff;
        }
        float penalty = (float)(circuit_config - 1) * penalty_per_config;
        this.superheated_threshold -= shs_reduction_per_config * (circuit_config - 1);
        return defaultEff - penalty;
    }

    private int useWater(float input) {
        this.water += input;
        int usage = (int)this.water;
        this.water -= (float)usage;
        return usage;
    }

    public boolean onRunningTick(ItemStack aStack) {
        int distilledConsumed;
        FluidStack distilledStack;
        if (this.mEUt <= 0) {
            return false;
        }
        int tGeneratedEU = (int)((long)this.mEUt * 2L * (long)this.mEfficiency / 10000L);
        if (tGeneratedEU <= 0) {
            return false;
        }
        if (this.superheated) {
            tGeneratedEU /= 2;
        }
        if (this.depleteInput(distilledStack = GT_ModHandler.getDistilledWater((long)(distilledConsumed = this.useWater((float)tGeneratedEU / 160.0f))))) {
            if (this.superheated) {
                this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)tGeneratedEU));
            } else {
                this.addOutput(GT_ModHandler.getSteam((long)tGeneratedEU));
            }
        } else {
            GT_Log.exp.println(this.mName + " had no more Distilled water!");
            this.explodeMultiblock();
            return false;
        }
        return true;
    }

    public boolean addColdFluidOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output)) {
            return false;
        }
        ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        this.mOutputColdFluidHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
        return true;
    }

    public boolean addHotFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input)) {
            return false;
        }
        ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        this.mInputHotFluidHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
        this.mInputHotFluidHatch.mRecipeMap = null;
        return true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new BW_TT_HeatExchanger(this.mName);
    }

    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + this.mProgresstime / 20 + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + " " + StatCollector.func_74838_a((String)"GT5U.LHE.steam") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.YELLOW) + (this.superheated ? -2 * this.mEUt : -this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.LHE.superheated") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.BLUE) + this.superheated + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.LHE.superheated") + " " + StatCollector.func_74838_a((String)"GT5U.LHE.threshold") + ": " + EnumChatFormatting.GREEN + this.superheated_threshold + EnumChatFormatting.RESET};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM("main", 1, 3, 0, b, itemStack);
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return sfStructureDescription;
    }
}

