/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MegaUtils;
import com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti;
import com.github.bartimaeusnek.crossmod.tectech.helper.TecTechUtils;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_VacuumFreezer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

@Optional.Interface(iface="com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti", modid="tectech", striprefs=true)
public class GT_TileEntity_MegaVacuumFreezer
extends GT_MetaTileEntity_VacuumFreezer
implements TecTechEnabledMulti {
    public ArrayList TTTunnels = new ArrayList();
    public ArrayList TTMultiAmp = new ArrayList();

    public GT_TileEntity_MegaVacuumFreezer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaVacuumFreezer(String aName) {
        super(aName);
    }

    public String[] getDescription() {
        return BW_Tooltip_Reference.getTranslatedBrandedTooltip("tooltip.tile.mvf.0.name");
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaVacuumFreezer(this.mName);
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (LoaderReference.tectech) {
            return TecTechUtils.addEnergyInputToMachineList(this, aTileEntity, aBaseCasingIndex);
        }
        return super.addEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean drainEnergyInput(long aEU) {
        if (LoaderReference.tectech) {
            return TecTechUtils.drainEnergyMEBFTecTech(this, aEU);
        }
        return MegaUtils.drainEnergyMegaVanilla((GT_MetaTileEntity_MultiBlockBase)this, aEU);
    }

    public long getMaxInputVoltage() {
        if (LoaderReference.tectech) {
            return TecTechUtils.getMaxInputVoltage(this);
        }
        return super.getMaxInputVoltage();
    }

    public boolean checkRecipe(ItemStack itemStack) {
        int processed;
        ItemStack[] tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        long nominalV = LoaderReference.tectech ? TecTechUtils.getnominalVoltageTT(this) : BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)nominalV));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sVacuumRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], null, tInputs);
        boolean found_Recipe = false;
        for (processed = 0; this.getStoredInputs().size() > 0 && processed < ConfigHandler.megaMachinesMax && tRecipe != null && (long)tRecipe.mEUt * (long)(processed + 1) < nominalV && tRecipe.isRecipeInputEqual(true, null, tInputs); ++processed) {
            found_Recipe = true;
            for (int i = 0; i < tRecipe.mOutputs.length; ++i) {
                outputItems.add(tRecipe.getOutput(i));
            }
        }
        if (found_Recipe) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            long actualEUT = (long)tRecipe.mEUt * (long)processed;
            if (actualEUT > Integer.MAX_VALUE) {
                int divider = 0;
                while (actualEUT > Integer.MAX_VALUE) {
                    actualEUT /= 2L;
                    divider = (byte)(divider + 1);
                }
                BW_Util.calculateOverclockedNessMulti((int)(actualEUT / (long)(divider * 2)), tRecipe.mDuration * (divider * 2), 1, nominalV, (GT_MetaTileEntity_MultiBlockBase)this);
            } else {
                BW_Util.calculateOverclockedNessMulti((int)actualEUT, tRecipe.mDuration, 1, nominalV, (GT_MetaTileEntity_MultiBlockBase)this);
            }
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = new ItemStack[outputItems.size()];
            this.mOutputItems = outputItems.toArray(this.mOutputItems);
            this.updateSlots();
            return true;
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (LoaderReference.tectech) {
            this.getTecTechEnergyMultis().clear();
            this.getTecTechEnergyTunnels().clear();
        }
        return BW_Util.check_layer(aBaseMetaTileEntity, 7, -7, -6, GregTech_API.sBlockCasings2, 1, 7, false, false, true, GregTech_API.sBlockCasings2, 1, true, 17) && BW_Util.check_layer(aBaseMetaTileEntity, 7, -6, 0, GregTech_API.sBlockCasings2, 1, 7, false, false, true, Blocks.field_150350_a, -1, true, 17) && BW_Util.check_layer(aBaseMetaTileEntity, 7, 0, 1, GregTech_API.sBlockCasings2, 1, 7, true, false, true, Blocks.field_150350_a, -1, true, 17) && BW_Util.check_layer(aBaseMetaTileEntity, 7, 1, 7, GregTech_API.sBlockCasings2, 1, 7, false, false, true, Blocks.field_150350_a, -1, true, 17) && BW_Util.check_layer(aBaseMetaTileEntity, 7, 7, 8, GregTech_API.sBlockCasings2, 1, 7, false, false, true, GregTech_API.sBlockCasings2, 1, true, 17) && !this.mInputBusses.isEmpty() && !this.mOutputBusses.isEmpty() && !this.mMaintenanceHatches.isEmpty() && LoaderReference.tectech ? !(this.getTecTechEnergyMultis().isEmpty() && this.getTecTechEnergyTunnels().isEmpty() && this.mEnergyHatches.isEmpty()) : !this.mEnergyHatches.isEmpty();
    }

    public String[] getInfoData() {
        return LoaderReference.tectech ? this.getInfoDataArray((GT_MetaTileEntity_MultiBlockBase)this) : super.getInfoData();
    }

    @Override
    @Optional.Method(modid="tectech")
    public List<GT_MetaTileEntity_Hatch_Energy> getVanillaEnergyHatches() {
        return this.mEnergyHatches;
    }

    @Optional.Method(modid="tectech")
    public List getTecTechEnergyTunnels() {
        return this.TTTunnels;
    }

    @Optional.Method(modid="tectech")
    public List getTecTechEnergyMultis() {
        return this.TTMultiAmp;
    }
}

