/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.client.gui.GT_GUIContainer_LESU;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.server.container.GT_Container_LESU;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.ConnectedBlocksChecker;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class GT_TileEntity_LESU
extends GT_MetaTileEntity_MultiBlockBase {
    private static final byte TEXID_SIDE = 0;
    private static final byte TEXID_CHARGING = 1;
    private static final byte TEXID_IDLE = 2;
    private static final byte TEXID_EMPTY = 3;
    private static final IIcon[] iIcons = new IIcon[4];
    private static final IIconContainer[] iIconContainers = new IIconContainer[4];
    private static final ITexture[][] iTextures = new ITexture[4][1];
    public ConnectedBlocksChecker connectedcells;
    public ItemStack[] circuits = new ItemStack[5];
    private long mStorage;

    public GT_TileEntity_LESU(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.mStorage = ConfigHandler.energyPerCell;
    }

    public GT_TileEntity_LESU(String aName) {
        super(aName);
    }

    public boolean isEnetOutput() {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public long maxEUStore() {
        return this.mStorage >= 0x7FFFFFFFFFFFFFFEL || this.mStorage < 0L ? 0x7FFFFFFFFFFFFFFEL : this.mStorage;
    }

    public long maxAmperesIn() {
        int ret = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.circuits[i] == null || !this.circuits[i].func_77973_b().equals(GT_Utility.getIntegratedCircuit((int)0).func_77973_b())) continue;
            ret += this.circuits[i].func_77960_j();
        }
        return ret > 0 ? (long)ret : 1L;
    }

    public long maxAmperesOut() {
        return this.maxAmperesIn();
    }

    public long maxEUInput() {
        for (int i = 1; i < GT_Values.V.length; ++i) {
            if (this.maxEUOutput() > GT_Values.V[i] || this.maxEUOutput() <= GT_Values.V[i - 1]) continue;
            return Math.min(GT_Values.V[i], 32768L);
        }
        return 8L;
    }

    public long maxEUOutput() {
        return Math.min(Math.max(this.mStorage / ConfigHandler.energyPerCell, 1L), 32768L);
    }

    public int rechargerSlotStartIndex() {
        return 0;
    }

    public int rechargerSlotCount() {
        return 1;
    }

    public int dechargerSlotStartIndex() {
        return 1;
    }

    public int dechargerSlotCount() {
        return 1;
    }

    public boolean isTeleporterCompatible() {
        return true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_LESU(this.mName);
    }

    public String[] getDescription() {
        ArrayList<String> e = new ArrayList<String>();
        String[] dsc = StatCollector.func_74838_a((String)"tooltip.tile.lesu.0.name").split(";");
        Collections.addAll(e, dsc);
        e.add(StatCollector.func_74838_a((String)"tooltip.tile.lesu.1.name") + " " + ConfigHandler.energyPerCell + "EU");
        dsc = StatCollector.func_74838_a((String)"tooltip.tile.lesu.2.name").split(";");
        Collections.addAll(e, dsc);
        e.add("\u00a7c" + StatCollector.func_74838_a((String)"tooltip.tile.lesu.3.name"));
        e.add(BW_Tooltip_Reference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get());
        return e.toArray(new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        for (int i = 0; i < iTextures.length; ++i) {
            GT_TileEntity_LESU.iIcons[i] = aBlockIconRegister.func_94245_a("bartworks:LESU_CASING_" + i);
            final int finalI = i;
            GT_TileEntity_LESU.iIconContainers[i] = new IIconContainer(){

                public IIcon getIcon() {
                    return iIcons[finalI];
                }

                public IIcon getOverlayIcon() {
                    return iIcons[finalI];
                }

                public ResourceLocation getTextureFile() {
                    return new ResourceLocation("bartworks:LESU_CASING_" + finalI);
                }
            };
        }
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_LESU(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_LESU(aPlayerInventory, aBaseMetaTileEntity);
    }

    public boolean isClientSide() {
        if (this.getWorld() != null) {
            return this.getWorld().field_72995_K ? FMLCommonHandler.instance().getSide() == Side.CLIENT : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] ret = new ITexture[]{};
        if (this.isClientSide()) {
            for (int i = 0; i < iTextures.length; ++i) {
                GT_TileEntity_LESU.iTextures[i][0] = TextureFactory.of((IIconContainer)iIconContainers[i], (short[])Dyes.getModulation((int)0, (short[])Dyes.MACHINE_METAL.mRGBa));
            }
            ret = aSide == aFacing && this.getBaseMetaTileEntity().getUniversalEnergyStored() <= 0L ? iTextures[3] : (aSide == aFacing && !aActive ? iTextures[2] : (aSide == aFacing && aActive ? iTextures[1] : iTextures[0]));
        }
        return ret;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return true;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return true;
    }

    public int func_70302_i_() {
        return 6;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        if (p_70301_1_ > 1) {
            return this.circuits[p_70301_1_ - 2];
        }
        return this.mInventory[p_70301_1_];
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        if (p_70299_1_ < 2) {
            this.mInventory[p_70299_1_] = p_70299_2_;
        } else {
            this.circuits[p_70299_1_ - 2] = p_70299_2_;
        }
    }

    public String func_145825_b() {
        return "L.E.S.U.";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        switch (p_94041_1_) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return p_94041_2_ != null && p_94041_2_.func_77973_b().equals(GT_Utility.getIntegratedCircuit((int)0).func_77973_b());
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public boolean checkRecipe(ItemStack itemStack) {
        return true;
    }

    public boolean isInputFacing(byte aSide) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.checkMachine(aBaseMetaTileEntity, null);
        super.onFirstTick(aBaseMetaTileEntity);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mMaxProgresstime = 1;
            if (aTick % 20L == 0L) {
                this.checkMachine(aBaseMetaTileEntity, null);
            }
            this.mWrench = true;
            this.mScrewdriver = true;
            this.mSoftHammer = true;
            this.mHardHammer = true;
            this.mSolderingTool = true;
            this.mCrowbar = true;
        }
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public boolean onRunningTick(ItemStack aStack) {
        this.mMaxProgresstime = 1;
        return true;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74783_a("customCircuitInv", GT_Utility.stacksToIntArray((ItemStack[])this.circuits));
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        int[] stacks = aNBT.func_74759_k("customCircuitInv");
        for (int i = 0; i < stacks.length; ++i) {
            this.circuits[i] = GT_Utility.intToStack((int)stacks[i]);
        }
        super.loadNBTData(aNBT);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        long startingTime = System.nanoTime();
        this.connectedcells = new ConnectedBlocksChecker();
        this.connectedcells.get_connected(aBaseMetaTileEntity.getWorld(), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord(), ItemRegistry.BW_BLOCKS[1]);
        if (this.connectedcells.get_meta_of_sideblocks(aBaseMetaTileEntity.getWorld(), this.getBaseMetaTileEntity().getMetaTileID(), new int[]{aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord()}, true)) {
            this.getBaseMetaTileEntity().disableWorking();
            this.getBaseMetaTileEntity().setActive(false);
            this.mStorage = 0L;
            this.mMaxProgresstime = 0;
            this.mProgresstime = 0;
            return false;
        }
        this.mEfficiency = this.getMaxEfficiency(null);
        this.mStorage = ConfigHandler.energyPerCell * (long)this.connectedcells.hashset.size() >= 0x7FFFFFFFFFFFFFFEL || ConfigHandler.energyPerCell * (long)this.connectedcells.hashset.size() < 0L ? 0x7FFFFFFFFFFFFFFEL : ConfigHandler.energyPerCell * (long)this.connectedcells.hashset.size();
        this.mMaxProgresstime = 1;
        this.mProgresstime = 0;
        this.mCrowbar = true;
        this.mHardHammer = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mSolderingTool = true;
        this.mWrench = true;
        this.getBaseMetaTileEntity().enableWorking();
        this.getBaseMetaTileEntity().setActive(true);
        long finishedTime = System.nanoTime();
        if (finishedTime - startingTime > 5000000L) {
            MainMod.LOGGER.warn("LESU LookUp took longer than 5ms!(" + (finishedTime - startingTime) + "ns / " + (finishedTime - startingTime) / 1000000L + "ms) Owner:" + this.getBaseMetaTileEntity().getOwnerName() + " Check at x:" + this.getBaseMetaTileEntity().getXCoord() + " y:" + this.getBaseMetaTileEntity().getYCoord() + " z:" + this.getBaseMetaTileEntity().getZCoord() + " DIM-ID: " + this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
        }
        return true;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public World getWorld() {
        return this.getBaseMetaTileEntity().getWorld();
    }
}

