/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.classic;

import com.github.bartimaeusnek.bartworks.API.ITileAddsInformation;
import com.github.bartimaeusnek.bartworks.util.Coords;
import java.util.Comparator;
import java.util.PriorityQueue;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.TileFluidHandler;

public class BW_TileEntity_ExperimentalFloodGate
extends TileFluidHandler
implements ITileAddsInformation {
    private static final ForgeDirection[] allowed_directions = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.NORTH};
    private PriorityQueue<Coords> breadthFirstQueue = new PriorityQueue<Coords>(Comparator.comparingInt(x -> x.y));
    private boolean wasInited = false;

    public BW_TileEntity_ExperimentalFloodGate() {
        this.tank.setCapacity(64000);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.canBePlacedInWorld();
    }

    public void initEntity() {
        if (this.wasInited) {
            return;
        }
        this.breadthFirstQueue.add(new Coords(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.wasInited = true;
    }

    public void func_145845_h() {
        this.initEntity();
        Coords current = this.breadthFirstQueue.poll();
        if (current == null) {
            return;
        }
        this.setFluidBlock(current);
        for (ForgeDirection allowed_direction : allowed_directions) {
            this.addBlockToQueue(current, allowed_direction);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("init", this.wasInited);
        int[] x = new int[this.breadthFirstQueue.size()];
        int[] y = new int[this.breadthFirstQueue.size()];
        int[] z = new int[this.breadthFirstQueue.size()];
        Coords[] arr = this.breadthFirstQueue.toArray(new Coords[0]);
        for (int i = 0; i < this.breadthFirstQueue.size(); ++i) {
            x[i] = arr[i].x;
            y[i] = arr[i].y;
            z[i] = arr[i].z;
        }
        tag.func_74783_a("queueX", x);
        tag.func_74783_a("queueY", y);
        tag.func_74783_a("queueZ", z);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.wasInited = tag.func_74767_n("init");
        int[] x = tag.func_74759_k("queueX");
        int[] y = tag.func_74759_k("queueY");
        int[] z = tag.func_74759_k("queueZ");
        for (int i = 0; i < x.length; ++i) {
            this.breadthFirstQueue.add(new Coords(x[i], y[i], z[i]));
        }
    }

    private void setFluidBlock(Coords current) {
        if (!this.checkForAir(current)) {
            return;
        }
        if (this.tank.drain(1000, false) == null || this.tank.drain((int)1000, (boolean)false).amount != 1000) {
            return;
        }
        FluidStack stack = this.tank.drain(1000, true);
        this.field_145850_b.func_147465_d(current.x, (int)current.y, current.z, stack.getFluid().getBlock(), 0, 2);
    }

    private void addBlockToQueue(Coords current, ForgeDirection allowed_direction) {
        Coords side = current.getCoordsFromSide(allowed_direction);
        if (this.checkForAir(side)) {
            this.breadthFirstQueue.add(side);
        }
    }

    private boolean checkForAir(Coords coords) {
        return this.field_145850_b.func_147437_c(coords.x, (int)coords.y, coords.z);
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Experimental Machine to fill Holes with Fluids"};
    }
}

