/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.model;

import de.eydamos.backpack.misc.Constants;
import de.eydamos.backpack.model.ModelBackpackL;
import de.eydamos.backpack.model.ModelBackpackM;
import de.eydamos.backpack.model.ModelBackpackS;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class BackpackModelWorker {
    ModelBiped[] backModels = new ModelBiped[]{new ModelBackpackS(), new ModelBackpackM(), new ModelBackpackL()};
    float[][] backpackColors = new float[][]{{0.6f, 0.3f, 0.1f}, {0.1f, 0.1f, 0.1f}, {0.6f, 0.2f, 0.2f}, {0.4f, 0.5f, 0.2f}, {0.4f, 0.3f, 0.2f}, {0.2f, 0.3f, 0.7f}, {0.5f, 0.25f, 0.7f}, {0.3f, 0.5f, 0.6f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.3f, 0.3f}, {0.95f, 0.5f, 0.65f}, {0.5f, 0.8f, 0.1f}, {0.9f, 0.9f, 0.2f}, {0.4f, 0.6f, 0.85f}, {0.7f, 0.3f, 0.85f}, {0.85f, 0.5f, 0.2f}, {1.0f, 1.0f, 1.0f}, {0.1f, 0.2f, 0.2f}};

    public void renderAt(EntityPlayer player, int meta) {
        if (meta == -1) {
            return;
        }
        ModelBiped backModel = this.getModel(meta);
        if (backModel == null) {
            return;
        }
        GL11.glPushMatrix();
        float[] colors = this.getColor(meta);
        GL11.glColor4f((float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Constants.modelTexture);
        backModel.func_78088_a((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    public float[] getColor(int meta) {
        if (this.isEnder(meta)) {
            return this.backpackColors[17];
        }
        if (this.isCrafting(meta)) {
            return this.backpackColors[0];
        }
        int colorIndex = meta % 100;
        if (colorIndex < 0 || colorIndex > this.backpackColors.length - 1) {
            return this.backpackColors[0];
        }
        return this.backpackColors[colorIndex];
    }

    public ModelBiped getModel(int meta) {
        if (this.isEnder(meta)) {
            return this.backModels[0];
        }
        int index = this.getModelIndex(meta);
        return this.backModels[index];
    }

    boolean isEnder(int meta) {
        return meta == 31999;
    }

    boolean isCrafting(int meta) {
        return meta == 17 || meta == 217;
    }

    public int getModelIndex(int meta) {
        int index = meta / 100;
        if (index < 0 || index > this.backModels.length - 1) {
            return 0;
        }
        return index;
    }
}

