/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.inventory;

import de.eydamos.backpack.helper.InventoryHelper;
import de.eydamos.backpack.inventory.InventoryBasic;
import de.eydamos.backpack.saves.BackpackSave;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryRecipes
extends InventoryBasic {
    protected IInventory craftingGrid = null;
    protected ItemStack[][] recipesIngredients = new ItemStack[9][9];

    public InventoryRecipes(IInventory craftingMatrix) {
        super("text.backpack.recipes", false, 9);
        this.craftingGrid = craftingMatrix;
    }

    @Override
    public void func_70299_a(int slotIndex, ItemStack newContent) {
        super.func_70299_a(slotIndex, newContent);
        for (int i = 0; i < this.craftingGrid.func_70302_i_(); ++i) {
            ItemStack itemStack = this.craftingGrid.func_70301_a(i);
            this.recipesIngredients[slotIndex][i] = itemStack == null ? null : itemStack.func_77946_l();
        }
    }

    @Override
    public void readFromNBT(BackpackSave backpackSave) {
        InventoryHelper.readInventory(backpackSave, "recipes", this.inventoryContent);
        for (int i = 0; i < this.recipesIngredients.length; ++i) {
            InventoryHelper.readInventory(backpackSave, "recipe-" + i, this.recipesIngredients[i]);
        }
    }

    @Override
    public void writeToNBT(BackpackSave backpackSave) {
        InventoryHelper.writeInventory(backpackSave, "recipes", this.inventoryContent);
        for (int i = 0; i < this.recipesIngredients.length; ++i) {
            InventoryHelper.writeInventory(backpackSave, "recipe-" + i, this.recipesIngredients[i]);
        }
    }

    public void loadRecipe(int slotIndex) {
        for (int i = 0; i < this.recipesIngredients[slotIndex].length; ++i) {
            this.craftingGrid.func_70299_a(i, this.recipesIngredients[slotIndex][i]);
        }
    }
}

