/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.helper;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.factory.FactoryBackpack;
import de.eydamos.backpack.gui.GuiBackpackRename;
import de.eydamos.backpack.inventory.container.ContainerAdvanced;
import de.eydamos.backpack.misc.ConfigurationBackpack;
import de.eydamos.backpack.network.message.MessageGuiCommand;
import de.eydamos.backpack.network.message.MessageOpenBackpack;
import de.eydamos.backpack.network.message.MessageOpenGui;
import de.eydamos.backpack.network.message.MessageOpenPersonalSlot;
import de.eydamos.backpack.network.message.MessageRenameBackpack;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.backpack.saves.PlayerSave;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;

public class GuiHelper {
    @SideOnly(value=Side.CLIENT)
    public static void displayRenameGui() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiBackpackRename());
    }

    public static void displayBackpack(BackpackSave backpackSave, IInventory inventory, EntityPlayerMP entityPlayer) {
        if (!GuiHelper.isDimensionAllowed(entityPlayer)) {
            return;
        }
        GuiHelper.prepare(entityPlayer);
        MessageOpenBackpack message = new MessageOpenBackpack(backpackSave, inventory, entityPlayer.field_71139_cq);
        Backpack.packetHandler.networkWrapper.sendTo((IMessage)message, entityPlayer);
        ContainerAdvanced container = FactoryBackpack.getContainer(backpackSave, new IInventory[]{entityPlayer.field_71071_by, inventory}, (EntityPlayer)entityPlayer);
        GuiHelper.openContainer(container, entityPlayer);
    }

    public static void displayPersonalSlot(EntityPlayerMP entityPlayer) {
        if (!GuiHelper.isDimensionAllowed(entityPlayer)) {
            return;
        }
        PlayerSave playerSave = new PlayerSave((EntityPlayer)entityPlayer);
        playerSave.setType((byte)-1);
        GuiHelper.prepare(entityPlayer);
        MessageOpenPersonalSlot message = new MessageOpenPersonalSlot(entityPlayer.field_71139_cq);
        Backpack.packetHandler.networkWrapper.sendTo((IMessage)message, entityPlayer);
        ContainerAdvanced container = FactoryBackpack.getContainer(playerSave, new IInventory[]{entityPlayer.field_71071_by}, (EntityPlayer)entityPlayer);
        GuiHelper.openContainer(container, entityPlayer);
    }

    private static boolean isDimensionAllowed(EntityPlayerMP entityPlayer) {
        Integer currentDimID = entityPlayer.field_70170_p.field_73011_w.field_76574_g;
        for (String id : ConfigurationBackpack.FORBIDDEN_DIMENSIONS) {
            if (!id.equals(currentDimID.toString())) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendOpenPersonalGui(byte gui) {
        MessageOpenGui message = new MessageOpenGui(gui);
        Backpack.packetHandler.networkWrapper.sendToServer((IMessage)message);
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendGuiCommand(byte command) {
        MessageGuiCommand message = new MessageGuiCommand(command);
        Backpack.packetHandler.networkWrapper.sendToServer((IMessage)message);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renameBackpack(String name) {
        MessageRenameBackpack message = new MessageRenameBackpack(name);
        Backpack.packetHandler.networkWrapper.sendToServer((IMessage)message);
        message.setName((EntityPlayer)Minecraft.func_71410_x().field_71439_g, name);
    }

    protected static void prepare(EntityPlayerMP entityPlayer) {
        if (entityPlayer.field_71070_bA != entityPlayer.field_71069_bz) {
            entityPlayer.func_71053_j();
        }
        entityPlayer.func_71117_bO();
    }

    protected static void openContainer(Container container, EntityPlayerMP entityPlayer) {
        entityPlayer.field_71070_bA = container;
        entityPlayer.field_71070_bA.field_75152_c = entityPlayer.field_71139_cq;
        entityPlayer.field_71070_bA.func_75132_a((ICrafting)entityPlayer);
    }
}

