/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.helpers;

import java.util.Comparator;
import net.minecraft.world.ChunkCoordIntPair;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkQueueSorter
implements Comparator<Pair<ChunkCoordIntPair, Runnable>> {
    private final ChunkCoordIntPair[] playerChunks;

    public ChunkQueueSorter(ChunkCoordIntPair[] playerChunks) {
        this.playerChunks = playerChunks;
    }

    private int averagePlayerDistance(ChunkCoordIntPair pair) {
        int shortestDistance = Integer.MAX_VALUE;
        for (ChunkCoordIntPair p : this.playerChunks) {
            int xDist = p.field_77276_a - pair.field_77276_a;
            int zDist = p.field_77275_b - pair.field_77275_b;
            shortestDistance = Math.min(shortestDistance, xDist * xDist + zDist * zDist);
        }
        return shortestDistance;
    }

    @Override
    public int compare(Pair<ChunkCoordIntPair, Runnable> c1, Pair<ChunkCoordIntPair, Runnable> c2) {
        int d1 = this.averagePlayerDistance((ChunkCoordIntPair)c1.getLeft());
        int d2 = this.averagePlayerDistance((ChunkCoordIntPair)c2.getLeft());
        return d1 - d2;
    }
}

