/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.asm;

import com.gtnewhorizon.gtnhmixins.ILateMixinLoader;
import com.gtnewhorizon.gtnhmixins.LateMixin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.archaicfix.ArchaicCore;
import org.embeddedt.archaicfix.asm.Mixin;
import org.embeddedt.archaicfix.asm.TargetedMod;

@LateMixin
public class LateMixinPlugin
implements ILateMixinLoader {
    private static final Logger LOGGER = LogManager.getLogger();

    public String getMixinConfig() {
        return "mixins.archaicfix.late.json";
    }

    public List<String> getMixins(Set<String> loadedMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        HashSet<TargetedMod> validMods = new HashSet<TargetedMod>(ArchaicCore.coreMods);
        HashMap<String, TargetedMod> modById = new HashMap<String, TargetedMod>();
        for (TargetedMod t : TargetedMod.values()) {
            if (t.getModId() == null) continue;
            modById.put(t.getModId(), t);
        }
        for (String modId : loadedMods) {
            TargetedMod t = (TargetedMod)((Object)modById.get(modId));
            if (t == null) continue;
            validMods.add(t);
        }
        LOGGER.info("Detected mods: [" + validMods.stream().map(Enum::name).collect(Collectors.joining(", ")) + "]");
        for (Mixin mixin : Mixin.values()) {
            if (mixin.getPhase() != Mixin.Phase.LATE || !mixin.shouldLoadSide() || !mixin.getFilter().test(validMods)) continue;
            mixins.add(mixin.getMixin());
        }
        return mixins;
    }
}

