/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.api;

import java.util.Locale;
import org.embeddedt.archaicfix.ArchaicLogger;
import speiger.src.collections.ints.maps.impl.misc.Int2ObjectArrayMap;
import speiger.src.collections.objects.sets.ObjectOpenHashSet;

public class LoliStringPool {
    public static final int FILE_PERMISSIONS_ID = 1;
    private static final Int2ObjectArrayMap<Internal> POOLS = new Int2ObjectArrayMap();

    public static void establishPool(int poolId, int expectedSize, String ... startingValues) {
        if (POOLS.containsKey(poolId)) {
            return;
        }
        POOLS.put(poolId, new Internal(poolId, expectedSize, startingValues));
    }

    public static Internal purgePool(int poolId) {
        return POOLS.remove(poolId);
    }

    public static int getSize() {
        return ((Internal)LoliStringPool.POOLS.getDefaultReturnValue()).internalPool.size();
    }

    public static int getSize(int pool) {
        return LoliStringPool.POOLS.get((int)pool).internalPool.size();
    }

    public static long getDeduplicatedCount() {
        return ((Internal)LoliStringPool.POOLS.getDefaultReturnValue()).deduplicatedCount;
    }

    public static long getDeduplicatedCount(int pool) {
        return LoliStringPool.POOLS.get((int)pool).deduplicatedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String canonicalize(String string) {
        Int2ObjectArrayMap<Internal> int2ObjectArrayMap = POOLS;
        synchronized (int2ObjectArrayMap) {
            return ((Internal)POOLS.getDefaultReturnValue()).addOrGet(string);
        }
    }

    public static String unsafe$Canonicalize(String string) {
        return ((Internal)POOLS.getDefaultReturnValue()).addOrGet(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lowerCaseAndCanonicalize(String string) {
        Int2ObjectArrayMap<Internal> int2ObjectArrayMap = POOLS;
        synchronized (int2ObjectArrayMap) {
            return ((Internal)POOLS.getDefaultReturnValue()).addOrGet(string.toLowerCase(Locale.ROOT));
        }
    }

    public static String unsafe$LowerCaseAndCanonicalize(String string) {
        return ((Internal)POOLS.getDefaultReturnValue()).addOrGet(string.toLowerCase(Locale.ROOT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String canonicalize(String string, int poolId, boolean checkMainPool) {
        Int2ObjectArrayMap<Internal> int2ObjectArrayMap;
        if (checkMainPool) {
            int2ObjectArrayMap = POOLS;
            synchronized (int2ObjectArrayMap) {
                String canonicalized;
                ObjectOpenHashSet<String> internalPool = LoliStringPool.POOLS.get((int)poolId).internalPool;
                String string2 = canonicalized = internalPool.contains(string) ? internalPool.addOrGet(string) : null;
                if (canonicalized != null) {
                    return canonicalized;
                }
            }
        }
        int2ObjectArrayMap = POOLS;
        synchronized (int2ObjectArrayMap) {
            return POOLS.get(poolId).addOrGet(string);
        }
    }

    public static String unsafe$Canonicalize(String string, int poolId, boolean checkMainPool) {
        if (checkMainPool) {
            String canonicalized;
            ObjectOpenHashSet<String> internalPool = LoliStringPool.POOLS.get((int)poolId).internalPool;
            String string2 = canonicalized = internalPool.contains(string) ? internalPool.addOrGet(string) : null;
            if (canonicalized != null) {
                return canonicalized;
            }
        }
        return POOLS.get(poolId).addOrGet(string);
    }

    static {
        LoliStringPool.establishPool(-1, 12288, "", " ");
        POOLS.setDefaultReturnValue((Object)POOLS.get(-1));
    }

    static class Internal {
        final int id;
        final ObjectOpenHashSet<String> internalPool;
        long deduplicatedCount;

        Internal(int id, int expectedSize, String ... startingValues) {
            this.id = id;
            this.internalPool = new ObjectOpenHashSet(expectedSize);
            for (String startingValue : startingValues) {
                this.internalPool.add(startingValue);
            }
        }

        String addOrGet(String string) {
            ++this.deduplicatedCount;
            return this.internalPool.addOrGet(string);
        }

        protected void finalize() {
            ArchaicLogger.LOGGER.warn("Clearing LoliStringPool {}", new Object[]{this.id});
        }
    }

    public static class EventHandler {
    }
}

