/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.lists;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectSplititerator;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.lists.AbstractObjectList;
import speiger.src.collections.objects.lists.ObjectList;
import speiger.src.collections.objects.utils.ObjectArrays;
import speiger.src.collections.objects.utils.ObjectIterators;
import speiger.src.collections.objects.utils.ObjectSplititerators;
import speiger.src.collections.utils.IArray;
import speiger.src.collections.utils.SanityChecks;
import speiger.src.collections.utils.Stack;

public class ObjectArrayList<T>
extends AbstractObjectList<T>
implements IArray,
Stack<T> {
    static final int DEFAULT_ARRAY_SIZE = 10;
    protected transient T[] data;
    protected int size = 0;

    public ObjectArrayList() {
        this.data = ObjectArrays.EMPTY_ARRAY;
    }

    public ObjectArrayList(int size) {
        if (size < 0) {
            throw new IllegalStateException("Size has to be 0 or greater");
        }
        this.data = new Object[size];
    }

    public ObjectArrayList(Collection<? extends T> c) {
        this(c.size());
        this.size = ObjectIterators.unwrap(this.data, c.iterator());
    }

    public ObjectArrayList(ObjectCollection<T> c) {
        this(c.size());
        this.size = ObjectIterators.unwrap(this.data, c.iterator());
    }

    public ObjectArrayList(ObjectList<T> l) {
        this(l.size());
        this.size = l.size();
        l.getElements(0, this.data, 0, this.size);
    }

    public ObjectArrayList(T ... a) {
        this(a, 0, a.length);
    }

    public ObjectArrayList(T[] a, int length) {
        this(a, 0, length);
    }

    public ObjectArrayList(T[] a, int offset, int length) {
        this(length);
        SanityChecks.checkArrayCapacity(a.length, offset, length);
        System.arraycopy(a, offset, this.data, 0, length);
        this.size = length;
    }

    public static <T> ObjectArrayList<T> wrap(T ... a) {
        return ObjectArrayList.wrap(a, a.length);
    }

    public static <T> ObjectArrayList<T> wrap(T[] a, int length) {
        SanityChecks.checkArrayCapacity(a.length, 0, length);
        ObjectArrayList<T> list = new ObjectArrayList<T>();
        list.data = a;
        list.size = length;
        return list;
    }

    public static <T> ObjectArrayList<T> of(Class<T> c) {
        ObjectArrayList<T> list = new ObjectArrayList<T>();
        list.data = ObjectArrays.newArray(c, 0);
        return list;
    }

    public static <T> ObjectArrayList<T> of(Class<T> c, int size) {
        ObjectArrayList<T> list = new ObjectArrayList<T>();
        list.data = ObjectArrays.newArray(c, size);
        return list;
    }

    @Override
    public boolean add(T e) {
        this.grow(this.size + 1);
        this.data[this.size++] = e;
        return true;
    }

    @Override
    public void push(T e) {
        this.add(e);
    }

    @Override
    public void add(int index, T e) {
        this.checkAddRange(index);
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        }
        this.data[index] = e;
        ++this.size;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (c instanceof ObjectCollection) {
            return this.addAll(index, (ObjectCollection)c);
        }
        int add = c.size();
        if (add <= 0) {
            return false;
        }
        this.grow(this.size + add);
        if (index != this.size) {
            System.arraycopy(this.data, index, this.data, index + add, this.size - index);
        }
        this.size += add;
        Iterator<T> iter = c.iterator();
        while (add-- != 0) {
            this.data[index++] = iter.next();
        }
        return true;
    }

    @Override
    public boolean addAll(int index, ObjectCollection<T> c) {
        if (c instanceof ObjectList) {
            return this.addAll(index, (ObjectList)c);
        }
        int add = c.size();
        if (add <= 0) {
            return false;
        }
        this.grow(this.size + add);
        if (index != this.size) {
            System.arraycopy(this.data, index, this.data, index + add, this.size - index);
        }
        this.size += add;
        Iterator iter = c.iterator();
        while (add-- != 0) {
            this.data[index++] = iter.next();
        }
        return true;
    }

    @Override
    public boolean addAll(int index, ObjectList<T> c) {
        int add = c.size();
        if (add <= 0) {
            return false;
        }
        this.checkAddRange(index);
        this.grow(this.size + add);
        if (index != this.size) {
            System.arraycopy(this.data, index, this.data, index + add, this.size - index);
        }
        this.size += add;
        c.getElements(0, this.data, index, c.size());
        return true;
    }

    @Override
    public boolean addAll(T[] e, int offset, int length) {
        if (length <= 0) {
            return false;
        }
        SanityChecks.checkArrayCapacity(e.length, offset, length);
        this.grow(this.size + length);
        System.arraycopy(e, offset, this.data, this.size, length);
        this.size += length;
        return true;
    }

    @Override
    public void addElements(int from, T[] a, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.checkAddRange(from);
        SanityChecks.checkArrayCapacity(a.length, offset, length);
        this.grow(this.size + length);
        if (from != this.size) {
            System.arraycopy(this.data, from, this.data, from + length, this.size - from);
        }
        this.size += length;
        System.arraycopy(a, offset, this.data, from, length);
    }

    @Override
    public T[] getElements(int from, T[] a, int offset, int length) {
        SanityChecks.checkArrayCapacity(this.size, from, length);
        SanityChecks.checkArrayCapacity(a.length, offset, length);
        System.arraycopy(this.data, from, a, offset, length);
        return a;
    }

    @Override
    public void removeElements(int from, int to) {
        this.checkRange(from);
        this.checkAddRange(to);
        int length = to - from;
        if (length <= 0) {
            return;
        }
        if (to != this.size) {
            System.arraycopy(this.data, to, this.data, from, this.size - to);
        }
        this.size -= length;
        for (int i = 0; i < length; ++i) {
            this.data[i + this.size] = null;
        }
    }

    @Override
    public <K> K[] extractElements(int from, int to, Class<K> type) {
        this.checkRange(from);
        this.checkAddRange(to);
        int length = to - from;
        if (length <= 0) {
            return ObjectArrays.newArray(type, 0);
        }
        K[] a = ObjectArrays.newArray(type, length);
        System.arraycopy(this.data, from, a, 0, length);
        if (to != this.size) {
            System.arraycopy(this.data, to, this.data, from, this.size - to);
        }
        this.size -= length;
        for (int i = 0; i < length; ++i) {
            this.data[i + this.size] = null;
        }
        return a;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(o, this.data[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.data[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (!Objects.equals(o, this.data[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void sort(Comparator<? super T> c) {
        if (c != null) {
            ObjectArrays.stableSort(this.data, this.size, c);
        } else {
            ObjectArrays.stableSort(this.data, this.size);
        }
    }

    @Override
    public void unstableSort(Comparator<? super T> c) {
        if (c != null) {
            ObjectArrays.unstableSort(this.data, this.size, c);
        } else {
            ObjectArrays.unstableSort(this.data, this.size);
        }
    }

    @Override
    public T get(int index) {
        this.checkRange(index);
        return this.data[index];
    }

    @Override
    public T peek(int index) {
        this.checkRange(this.size() - 1 - index);
        return this.data[this.size() - 1 - index];
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.size; ++i) {
            action.accept(this.data[i]);
        }
    }

    @Override
    public <E> void forEach(E input, ObjectObjectConsumer<E, T> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.size; ++i) {
            action.accept(input, (E)this.data[i]);
        }
    }

    @Override
    public boolean matchesAny(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        for (int i = 0; i < this.size; ++i) {
            if (!filter.test(this.data[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesNone(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        for (int i = 0; i < this.size; ++i) {
            if (!filter.test(this.data[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesAll(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        for (int i = 0; i < this.size; ++i) {
            if (filter.test(this.data[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public T findFirst(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        for (int i = 0; i < this.size; ++i) {
            if (!filter.test(this.data[i])) continue;
            return this.data[i];
        }
        return null;
    }

    @Override
    public <E> E reduce(E identity, BiFunction<E, T, E> operator) {
        Objects.requireNonNull(operator);
        E state = identity;
        for (int i = 0; i < this.size; ++i) {
            state = operator.apply(state, this.data[i]);
        }
        return state;
    }

    @Override
    public T reduce(ObjectObjectUnaryOperator<T, T> operator) {
        Objects.requireNonNull(operator);
        Object state = null;
        boolean empty = true;
        for (int i = 0; i < this.size; ++i) {
            if (empty) {
                empty = false;
                state = this.data[i];
                continue;
            }
            state = operator.apply(state, this.data[i]);
        }
        return state;
    }

    @Override
    public int count(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        int result = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!filter.test(this.data[i])) continue;
            ++result;
        }
        return result;
    }

    @Override
    public T set(int index, T e) {
        this.checkRange(index);
        T old = this.data[index];
        this.data[index] = e;
        return old;
    }

    @Override
    public void replaceAll(UnaryOperator<T> o) {
        Objects.requireNonNull(o);
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = o.apply(this.data[i]);
        }
    }

    @Override
    public T remove(int index) {
        this.checkRange(index);
        T old = this.data[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        this.data[this.size] = null;
        return old;
    }

    @Override
    public T swapRemove(int index) {
        this.checkRange(index);
        T old = this.data[index];
        --this.size;
        this.data[index] = this.data[this.size];
        this.data[this.size] = null;
        return old;
    }

    @Override
    public boolean remove(Object type) {
        int index = this.indexOf(type);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public T pop() {
        return this.remove(this.size() - 1);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!c.contains(this.data[i])) {
                this.data[j++] = this.data[i];
                continue;
            }
            modified = true;
        }
        Arrays.fill(this.data, j, this.size, null);
        this.size = j;
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c.isEmpty()) {
            boolean modifed = this.size > 0;
            this.clear();
            return modifed;
        }
        boolean modified = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (c.contains(this.data[i])) {
                this.data[j++] = this.data[i];
                continue;
            }
            modified = true;
        }
        Arrays.fill(this.data, j, this.size, null);
        this.size = j;
        return modified;
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        Objects.requireNonNull(filter);
        boolean modified = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!filter.test(this.data[i])) {
                this.data[j++] = this.data[i];
                continue;
            }
            modified = true;
        }
        Arrays.fill(this.data, j, this.size, null);
        this.size = j;
        return modified;
    }

    @Override
    public boolean removeAll(ObjectCollection<T> c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!c.contains(this.data[i])) {
                this.data[j++] = this.data[i];
                continue;
            }
            modified = true;
        }
        Arrays.fill(this.data, j, this.size, null);
        this.size = j;
        return modified;
    }

    @Override
    public boolean removeAll(ObjectCollection<T> c, Consumer<T> r) {
        if (c.isEmpty()) {
            return false;
        }
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!c.contains(this.data[i])) {
                this.data[j++] = this.data[i];
                continue;
            }
            r.accept(this.data[i]);
        }
        boolean modified = j != this.size;
        Arrays.fill(this.data, j, this.size, null);
        this.size = j;
        return modified;
    }

    @Override
    public boolean retainAll(ObjectCollection<T> c) {
        if (c.isEmpty()) {
            boolean modifed = this.size > 0;
            this.clear();
            return modifed;
        }
        boolean modified = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (c.contains(this.data[i])) {
                this.data[j++] = this.data[i];
                continue;
            }
            modified = true;
        }
        Arrays.fill(this.data, j, this.size, null);
        this.size = j;
        return modified;
    }

    @Override
    public boolean retainAll(ObjectCollection<T> c, Consumer<T> r) {
        if (c.isEmpty()) {
            boolean modifed = this.size > 0;
            this.forEach(r);
            this.clear();
            return modifed;
        }
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (c.contains(this.data[i])) {
                this.data[j++] = this.data[i];
                continue;
            }
            r.accept(this.data[i]);
        }
        boolean modified = j != this.size;
        Arrays.fill(this.data, j, this.size, null);
        this.size = j;
        return modified;
    }

    @Override
    public Object[] toArray() {
        if (this.size == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        Object[] obj = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            obj[i] = this.data[i];
        }
        return obj;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        if (a == null) {
            a = new Object[this.size];
        } else if (a.length < this.size) {
            a = ObjectArrays.newArray(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.data, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void size(int size) {
        if (size > this.data.length) {
            this.data = Arrays.copyOf(this.data, size);
        } else if (size < this.size() && size >= 0) {
            Arrays.fill(this.data, size, this.size(), null);
        }
        this.size = size;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean trim(int size) {
        if (size > this.size() || this.size() == this.data.length) {
            return false;
        }
        int value = Math.max(size, this.size());
        this.data = value == 0 ? ObjectArrays.EMPTY_ARRAY : Arrays.copyOf(this.data, value);
        return true;
    }

    @Override
    public void clearAndTrim(int size) {
        if (this.data.length <= size) {
            this.clear();
            return;
        }
        this.data = size == 0 ? ObjectArrays.EMPTY_ARRAY : new Object[size];
        this.size = size;
    }

    @Override
    public void ensureCapacity(int size) {
        this.grow(size);
    }

    @Override
    public ObjectArrayList<T> copy() {
        ObjectArrayList<T> list = new ObjectArrayList<T>();
        list.data = Arrays.copyOf(this.data, this.data.length);
        list.size = this.size;
        return list;
    }

    protected void grow(int capacity) {
        if (capacity <= this.data.length) {
            return;
        }
        this.data = Arrays.copyOf(this.data, this.data == ObjectArrays.EMPTY_ARRAY ? Math.max(10, capacity) : (int)Math.max(Math.min((long)this.data.length + (long)(this.data.length >> 1), 0x7FFFFFF7L), (long)capacity));
    }

    protected void checkRange(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    protected void checkAddRange(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    @Override
    public ObjectSplititerator<T> spliterator() {
        return ObjectSplititerators.createArraySplititerator(this.data, this.size, 16464);
    }
}

